/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper;

import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import tech.grasshopper.json.JsonFileConverter;
import tech.grasshopper.json.JsonPathCollector;
import tech.grasshopper.logging.ExtentReportsCucumberLogger;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.reporters.ReporterInitializer;
import tech.grasshopper.test.ExtentTestManager;

@Mojo(name="extentreport")
public class ExtentReportsCucumberPlugin
extends AbstractMojo {
    @Parameter(property="extentreport.cucumberJsonReportDirectory", required=true)
    private String cucumberJsonReportDirectory;
    @Parameter(property="extentreport.extentPropertiesDirectory", defaultValue="")
    private String extentPropertiesDirectory;
    @Parameter(property="extentreport.displayAllHooks", defaultValue="false")
    private String displayAllHooks;
    @Parameter(property="strictCucumber6Behavior", defaultValue="true")
    private String strictCucumber6Behavior;
    private JsonPathCollector jsonPathCollector;
    private JsonFileConverter jsonFileConverter;
    private ReportProperties reportProperties;
    private ReporterInitializer reportInitializer;
    private ExtentTestManager extentTestManager;
    private ExtentReportsCucumberLogger logger;

    @Inject
    public ExtentReportsCucumberPlugin(JsonPathCollector jsonPathCollector, JsonFileConverter jsonFileConverter, ReportProperties reportProperties, ReporterInitializer reportInitializer, ExtentTestManager extentTestManager, ExtentReportsCucumberLogger logger) {
        this.jsonPathCollector = jsonPathCollector;
        this.jsonFileConverter = jsonFileConverter;
        this.reportProperties = reportProperties;
        this.reportInitializer = reportInitializer;
        this.extentTestManager = extentTestManager;
        this.logger = logger;
    }

    public void execute() {
        try {
            this.logger.initializeLogger(this.getLog());
            this.logger.info("STARTED EXTENT REPORT GENERATION PLUGIN");
            this.reportProperties.setDisplayAllHooks(this.displayAllHooks);
            this.reportProperties.loadPropertyFiles(this.extentPropertiesDirectory);
            this.reportProperties.setStrictCucumber6Behavior(this.strictCucumber6Behavior);
            List<Path> jsonFilePaths = this.jsonPathCollector.retrieveFilePaths(this.cucumberJsonReportDirectory);
            List<Feature> features = this.jsonFileConverter.retrieveFeaturesFromReport(jsonFilePaths);
            this.reportInitializer.instantiate();
            this.extentTestManager.initialize(features);
            this.extentTestManager.flushToReporters();
            this.logger.info("FINISHED EXTENT REPORT GENERATION PLUGIN");
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.logger.error(String.format("STOPPING EXTENT REPORT GENERATION - %s", t.getMessage()));
        }
    }
}

