/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.exception;

import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.logging.ExtentReportsCucumberLogger;
import tech.grasshopper.pojo.Result;

@Singleton
public class ExceptionParser {
    private ExtentReportsCucumberLogger logger;

    @Inject
    public ExceptionParser(ExtentReportsCucumberLogger logger) {
        this.logger = logger;
    }

    public Throwable parseStackTrace(Result result) {
        String[] details = this.retrieveExceptionNameAndStack(result.getErrorMessage());
        String exceptionClzName = details[0];
        String exceptionMessage = details[1];
        return this.createThrowableInstance(exceptionClzName, exceptionMessage);
    }

    private String[] retrieveExceptionNameAndStack(String stackTrace) {
        String[] details = new String[]{"", ""};
        Matcher m = Pattern.compile("\\R").matcher(stackTrace);
        if (m.find()) {
            String excepNameMsg = stackTrace.substring(0, m.start());
            int colonIndex = excepNameMsg.indexOf(":");
            if (colonIndex > -1) {
                details[0] = excepNameMsg.substring(0, colonIndex);
                details[1] = stackTrace.substring(colonIndex + 2);
            } else {
                details[0] = excepNameMsg;
                details[1] = stackTrace.substring(m.start());
            }
        }
        return details;
    }

    private Throwable createThrowableInstance(String className, String message) {
        Class<?> throwableClass = null;
        try {
            throwableClass = Class.forName(className);
            if (!Throwable.class.isAssignableFrom(throwableClass)) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.warn(className + " class cannot be found or not an instance of Throwable.");
            return new Exception("Generic Exception for " + className + " : " + message);
        }
        return this.createThrowableInstance(className, message, throwableClass);
    }

    private Throwable createThrowableInstance(String className, String message, Class<?> throwableClass) {
        Throwable throwableInstance;
        block5: {
            Constructor<?> throwableConstructor = null;
            throwableInstance = null;
            try {
                if (message.isEmpty()) {
                    throwableConstructor = throwableClass.getConstructor(new Class[0]);
                    throwableInstance = (Throwable)throwableConstructor.newInstance(new Object[0]);
                    break block5;
                }
                try {
                    throwableConstructor = throwableClass.getConstructor(String.class);
                }
                catch (NoSuchMethodException e) {
                    throwableConstructor = throwableClass.getConstructor(Object.class);
                }
                throwableInstance = (Throwable)throwableConstructor.newInstance(message);
            }
            catch (ReflectiveOperationException | SecurityException e) {
                this.logger.warn(className + " constructor cannot be found or cannot be instanciated.");
                throwableInstance = new Exception("Generic Exception for " + className + " : " + message);
            }
        }
        return throwableInstance;
    }
}

