/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.json.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import tech.grasshopper.logging.ExtentReportsCucumberLogger;
import tech.grasshopper.pojo.Embedded;
import tech.grasshopper.properties.ReportProperties;

public class EmbeddedDeserializer
implements JsonDeserializer<Embedded> {
    private static final AtomicInteger EMBEDDED_INT = new AtomicInteger(0);
    private static final Map<String, String> MIME_TYPES_EXTENSIONS = new HashMap<String, String>(){
        {
            this.put("image/bmp", "bmp");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
            this.put("image/svg+xml", "svg");
            this.put("video/ogg", "ogg");
        }
    };
    private ReportProperties reportProperties;
    private ExtentReportsCucumberLogger logger;

    public EmbeddedDeserializer(ReportProperties reportProperties, ExtentReportsCucumberLogger logger) {
        this.reportProperties = reportProperties;
        this.logger = logger;
    }

    public Embedded deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject jsonObject = json.getAsJsonObject();
        Embedded embedded = new Embedded();
        embedded.setData(jsonObject.get("data").getAsString());
        embedded.setMimeType(jsonObject.get("mime_type").getAsString());
        if (jsonObject.has("name")) {
            embedded.setName(jsonObject.get("name").getAsString());
        } else {
            embedded.setName("");
        }
        this.processEmbedding(embedded);
        return embedded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEmbedding(Embedded embedded) {
        String mimeType = embedded.getMimeType();
        String extension = MIME_TYPES_EXTENSIONS.get(mimeType);
        if (extension != null) {
            Path path = this.createEmbeddedFileStructure(extension);
            try {
                Files.write(path, Base64.getDecoder().decode(embedded.getData()), new OpenOption[0]);
            }
            catch (IOException e) {
                this.logger.warn("Skipping embedded file creation at location - " + path.toString() + ", due to error in creating file.");
                return;
            }
            finally {
                embedded.setData("");
            }
            embedded.setFilePath(Paths.get(this.reportProperties.getReportRelativeScreenshotLocation(), path.getFileName().toString()).toString());
        } else {
            this.logger.warn("Mime type '" + mimeType + "' not supported.");
        }
    }

    private Path createEmbeddedFileStructure(String extension) {
        StringBuilder fileName = new StringBuilder("embedded").append(EMBEDDED_INT.incrementAndGet()).append(".").append(extension);
        String embedDirPath = this.reportProperties.getReportScreenshotLocation();
        File dir = new File(embedDirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Path path = Paths.get(embedDirPath, fileName.toString());
        return path;
    }
}

