/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporters;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.observer.ExtentObserver;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import com.aventstack.extentreports.reporter.ExtentSparkReporter;
import com.aventstack.extentreports.reporter.JsonFormatter;
import com.aventstack.extentreports.reporter.ReporterFilterable;
import com.aventstack.extentreports.reporter.configuration.ViewName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tech.grasshopper.pdf.extent.ExtentPDFCucumberReporter;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.reporter.ExtentExcelCucumberReporter;

public abstract class ReporterAdapter {
    protected String id;
    protected ReportProperties reportProperties;

    public ReporterAdapter(String id, ReportProperties reportProperties) {
        this.id = id;
        this.reportProperties = reportProperties;
    }

    public abstract ExtentObserver<?> createReporter();

    public void filterReportStatus(ReporterFilterable<?> reporter) {
        try {
            String statusFilter = this.reportProperties.getStatusFilter();
            if (statusFilter == null || statusFilter.isEmpty()) {
                return;
            }
            List statuses = Arrays.stream(statusFilter.split(",")).map(s -> ReporterAdapter.convertToStatus(s)).collect(Collectors.toList());
            reporter.filter().statusFilter().as(statuses);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Status convertToStatus(String status) {
        String lowerStatus;
        switch (lowerStatus = status.toLowerCase()) {
            case "info": {
                return Status.INFO;
            }
            case "pass": {
                return Status.PASS;
            }
            case "Warning": {
                return Status.WARNING;
            }
            case "skip": {
                return Status.SKIP;
            }
            case "fail": {
                return Status.FAIL;
            }
        }
        throw new IllegalArgumentException();
    }

    public static class ExcelReportAdapter
    extends ReporterAdapter {
        public ExcelReportAdapter(String id, ReportProperties reportProperties) {
            super(id, reportProperties);
        }

        @Override
        public ExtentObserver<?> createReporter() {
            return new ExtentExcelCucumberReporter(this.reportProperties.getReportOutProperty(this.id));
        }
    }

    public static class HtmlReportAdapter
    extends ReporterAdapter {
        public HtmlReportAdapter(String id, ReportProperties reportProperties) {
            super(id, reportProperties);
        }

        @Override
        public ExtentObserver<?> createReporter() {
            ExtentHtmlReporter html = new ExtentHtmlReporter(this.reportProperties.getReportOutProperty(this.id));
            this.filterReportStatus((ReporterFilterable<?>)html);
            return html;
        }
    }

    public static class PDFReportAdapter
    extends ReporterAdapter {
        public PDFReportAdapter(String id, ReportProperties reportProperties) {
            super(id, reportProperties);
        }

        @Override
        public ExtentObserver<?> createReporter() {
            ExtentPDFCucumberReporter pdf = new ExtentPDFCucumberReporter(this.reportProperties.getReportOutProperty(this.id), this.reportProperties.getReportScreenshotLocation());
            this.filterReportStatus((ReporterFilterable<?>)pdf);
            return pdf;
        }
    }

    public static class JsonReportAdapter
    extends ReporterAdapter {
        public JsonReportAdapter(String id, ReportProperties reportProperties) {
            super(id, reportProperties);
        }

        @Override
        public ExtentObserver<?> createReporter() {
            return new JsonFormatter(this.reportProperties.getReportOutProperty(this.id));
        }
    }

    public static class SparkReportAdapter
    extends ReporterAdapter {
        public SparkReportAdapter(String id, ReportProperties reportProperties) {
            super(id, reportProperties);
        }

        @Override
        public ExtentObserver<?> createReporter() {
            ExtentSparkReporter spark = new ExtentSparkReporter(this.reportProperties.getReportOutProperty(this.id));
            this.sparkReportViewOrder(spark);
            this.filterReportStatus((ReporterFilterable<?>)spark);
            return spark;
        }

        private void sparkReportViewOrder(ExtentSparkReporter spark) {
            try {
                String viewOrder = this.reportProperties.getSparkViewOrder();
                if (viewOrder == null || viewOrder.isEmpty()) {
                    return;
                }
                List viewOrders = Arrays.stream(viewOrder.split(",")).map(v -> ViewName.valueOf((String)v.toUpperCase())).collect(Collectors.toList());
                spark.viewConfigurer().viewOrder().as(viewOrders).apply();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

