/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.test;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.observer.ExtentObserver;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import tech.grasshopper.pojo.Feature;
import tech.grasshopper.properties.ReportProperties;
import tech.grasshopper.reporters.ReporterInitializer;
import tech.grasshopper.tests.ExtentTestHeirarchy;

@Singleton
public class ExtentTestManager {
    private ExtentReports extent = new ExtentReports();
    private ReporterInitializer reportInitializer;
    private ReportProperties reportProperties;

    @Inject
    public ExtentTestManager(ReporterInitializer reportInitializer, ReportProperties reportProperties) {
        this.reportInitializer = reportInitializer;
        this.reportProperties = reportProperties;
    }

    public void initialize(List<Feature> features) {
        Map<String, ExtentObserver<?>> reporters = this.reportInitializer.getReportKeyToInstance();
        this.extent.setReportUsesManualConfiguration(true);
        this.reportProperties.getSystemInfomation().forEach((k, v) -> this.extent.setSystemInfo(k, v));
        ExtentTestHeirarchy.builder().extent(this.extent).features(features).displayAllHooks(this.reportProperties.isDisplayAllHooks()).strictCucumber6Behavior(this.reportProperties.isStrictCucumber6Behavior()).build().createTestHeirarchy();
        for (String key : reporters.keySet()) {
            ExtentObserver<?> reporter = reporters.get(key);
            this.extent.attachReporter(new ExtentObserver[]{reporter});
        }
    }

    public void flushToReporters() {
        this.extent.flush();
    }
}

