/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.component.decorator;

import java.awt.Color;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import tech.grasshopper.reporter.component.Component;
import tech.grasshopper.reporter.exception.PdfReportException;

public class BorderDecorator
extends Component {
    private static final Logger logger = Logger.getLogger(BorderDecorator.class.getName());
    private Component component;
    private PDPageContentStream content;
    private Color borderColor;
    private float xContainerBottomLeft;
    private float yContainerBottomLeft;
    private float containerWidth;
    private float containerHeight;
    private int borderwidth;

    @Override
    public void display() {
        try {
            this.content.setStrokingColor(this.borderColor);
            this.content.addRect(this.xContainerBottomLeft - (float)this.borderwidth, this.yContainerBottomLeft - (float)this.borderwidth, this.containerWidth + (float)(2 * this.borderwidth), this.containerHeight + (float)(2 * this.borderwidth));
            this.content.stroke();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
        this.component.display();
    }

    private static Color $default$borderColor() {
        return Color.DARK_GRAY;
    }

    private static int $default$borderwidth() {
        return 1;
    }

    protected BorderDecorator(BorderDecoratorBuilder<?, ?> b) {
        super(b);
        this.component = ((BorderDecoratorBuilder)b).component;
        this.content = ((BorderDecoratorBuilder)b).content;
        this.borderColor = ((BorderDecoratorBuilder)b).borderColor$set ? ((BorderDecoratorBuilder)b).borderColor$value : BorderDecorator.$default$borderColor();
        this.xContainerBottomLeft = ((BorderDecoratorBuilder)b).xContainerBottomLeft;
        this.yContainerBottomLeft = ((BorderDecoratorBuilder)b).yContainerBottomLeft;
        this.containerWidth = ((BorderDecoratorBuilder)b).containerWidth;
        this.containerHeight = ((BorderDecoratorBuilder)b).containerHeight;
        this.borderwidth = ((BorderDecoratorBuilder)b).borderwidth$set ? ((BorderDecoratorBuilder)b).borderwidth$value : BorderDecorator.$default$borderwidth();
    }

    public static BorderDecoratorBuilder<?, ?> builder() {
        return new BorderDecoratorBuilderImpl();
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public PDPageContentStream getContent() {
        return this.content;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public float getXContainerBottomLeft() {
        return this.xContainerBottomLeft;
    }

    public float getYContainerBottomLeft() {
        return this.yContainerBottomLeft;
    }

    public float getContainerWidth() {
        return this.containerWidth;
    }

    public float getContainerHeight() {
        return this.containerHeight;
    }

    public int getBorderwidth() {
        return this.borderwidth;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setXContainerBottomLeft(float xContainerBottomLeft) {
        this.xContainerBottomLeft = xContainerBottomLeft;
    }

    public void setYContainerBottomLeft(float yContainerBottomLeft) {
        this.yContainerBottomLeft = yContainerBottomLeft;
    }

    public void setContainerWidth(float containerWidth) {
        this.containerWidth = containerWidth;
    }

    public void setContainerHeight(float containerHeight) {
        this.containerHeight = containerHeight;
    }

    public void setBorderwidth(int borderwidth) {
        this.borderwidth = borderwidth;
    }

    @Override
    public String toString() {
        return "BorderDecorator(component=" + this.getComponent() + ", content=" + this.getContent() + ", borderColor=" + this.getBorderColor() + ", xContainerBottomLeft=" + this.getXContainerBottomLeft() + ", yContainerBottomLeft=" + this.getYContainerBottomLeft() + ", containerWidth=" + this.getContainerWidth() + ", containerHeight=" + this.getContainerHeight() + ", borderwidth=" + this.getBorderwidth() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BorderDecorator)) {
            return false;
        }
        BorderDecorator other = (BorderDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getXContainerBottomLeft(), other.getXContainerBottomLeft()) != 0) {
            return false;
        }
        if (Float.compare(this.getYContainerBottomLeft(), other.getYContainerBottomLeft()) != 0) {
            return false;
        }
        if (Float.compare(this.getContainerWidth(), other.getContainerWidth()) != 0) {
            return false;
        }
        if (Float.compare(this.getContainerHeight(), other.getContainerHeight()) != 0) {
            return false;
        }
        if (this.getBorderwidth() != other.getBorderwidth()) {
            return false;
        }
        Component this$component = this.getComponent();
        Component other$component = other.getComponent();
        if (this$component == null ? other$component != null : !((Object)this$component).equals(other$component)) {
            return false;
        }
        PDPageContentStream this$content = this.getContent();
        PDPageContentStream other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        return !(this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BorderDecorator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getXContainerBottomLeft());
        result = result * 59 + Float.floatToIntBits(this.getYContainerBottomLeft());
        result = result * 59 + Float.floatToIntBits(this.getContainerWidth());
        result = result * 59 + Float.floatToIntBits(this.getContainerHeight());
        result = result * 59 + this.getBorderwidth();
        Component $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : ((Object)$component).hashCode());
        PDPageContentStream $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        return result;
    }

    private static final class BorderDecoratorBuilderImpl
    extends BorderDecoratorBuilder<BorderDecorator, BorderDecoratorBuilderImpl> {
        private BorderDecoratorBuilderImpl() {
        }

        @Override
        protected BorderDecoratorBuilderImpl self() {
            return this;
        }

        @Override
        public BorderDecorator build() {
            return new BorderDecorator(this);
        }
    }

    public static abstract class BorderDecoratorBuilder<C extends BorderDecorator, B extends BorderDecoratorBuilder<C, B>>
    extends Component.ComponentBuilder<C, B> {
        private Component component;
        private PDPageContentStream content;
        private boolean borderColor$set;
        private Color borderColor$value;
        private float xContainerBottomLeft;
        private float yContainerBottomLeft;
        private float containerWidth;
        private float containerHeight;
        private boolean borderwidth$set;
        private int borderwidth$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B component(Component component) {
            this.component = component;
            return (B)this.self();
        }

        @Override
        public B content(PDPageContentStream content) {
            this.content = content;
            return (B)this.self();
        }

        public B borderColor(Color borderColor) {
            this.borderColor$value = borderColor;
            this.borderColor$set = true;
            return (B)this.self();
        }

        public B xContainerBottomLeft(float xContainerBottomLeft) {
            this.xContainerBottomLeft = xContainerBottomLeft;
            return (B)this.self();
        }

        public B yContainerBottomLeft(float yContainerBottomLeft) {
            this.yContainerBottomLeft = yContainerBottomLeft;
            return (B)this.self();
        }

        public B containerWidth(float containerWidth) {
            this.containerWidth = containerWidth;
            return (B)this.self();
        }

        public B containerHeight(float containerHeight) {
            this.containerHeight = containerHeight;
            return (B)this.self();
        }

        public B borderwidth(int borderwidth) {
            this.borderwidth$value = borderwidth;
            this.borderwidth$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BorderDecorator.BorderDecoratorBuilder(super=" + super.toString() + ", component=" + this.component + ", content=" + this.content + ", borderColor$value=" + this.borderColor$value + ", xContainerBottomLeft=" + this.xContainerBottomLeft + ", yContainerBottomLeft=" + this.yContainerBottomLeft + ", containerWidth=" + this.containerWidth + ", containerHeight=" + this.containerHeight + ", borderwidth$value=" + this.borderwidth$value + ")";
        }
    }
}

