/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.component.text;

import java.awt.Color;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class Text {
    private Color textColor;
    @NonNull
    private PDFont font;
    private float fontSize;
    private float xlocation;
    private float ylocation;
    private String text;

    private static Color $default$textColor() {
        return Color.BLACK;
    }

    private static float $default$fontSize() {
        return 12.0f;
    }

    Text(Color textColor, @NonNull PDFont font, float fontSize, float xlocation, float ylocation, String text) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        this.textColor = textColor;
        this.font = font;
        this.fontSize = fontSize;
        this.xlocation = xlocation;
        this.ylocation = ylocation;
        this.text = text;
    }

    public static TextBuilder builder() {
        return new TextBuilder();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    @NonNull
    public PDFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public float getXlocation() {
        return this.xlocation;
    }

    public float getYlocation() {
        return this.ylocation;
    }

    public String getText() {
        return this.text;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setFont(@NonNull PDFont font) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        this.font = font;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setXlocation(float xlocation) {
        this.xlocation = xlocation;
    }

    public void setYlocation(float ylocation) {
        this.ylocation = ylocation;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text other = (Text)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getFontSize(), other.getFontSize()) != 0) {
            return false;
        }
        if (Float.compare(this.getXlocation(), other.getXlocation()) != 0) {
            return false;
        }
        if (Float.compare(this.getYlocation(), other.getYlocation()) != 0) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Text;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getFontSize());
        result = result * 59 + Float.floatToIntBits(this.getXlocation());
        result = result * 59 + Float.floatToIntBits(this.getYlocation());
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "Text(textColor=" + this.getTextColor() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", xlocation=" + this.getXlocation() + ", ylocation=" + this.getYlocation() + ", text=" + this.getText() + ")";
    }

    public static class TextBuilder {
        private boolean textColor$set;
        private Color textColor$value;
        private PDFont font;
        private boolean fontSize$set;
        private float fontSize$value;
        private float xlocation;
        private float ylocation;
        private String text;

        TextBuilder() {
        }

        public TextBuilder textColor(Color textColor) {
            this.textColor$value = textColor;
            this.textColor$set = true;
            return this;
        }

        public TextBuilder font(@NonNull PDFont font) {
            if (font == null) {
                throw new NullPointerException("font is marked non-null but is null");
            }
            this.font = font;
            return this;
        }

        public TextBuilder fontSize(float fontSize) {
            this.fontSize$value = fontSize;
            this.fontSize$set = true;
            return this;
        }

        public TextBuilder xlocation(float xlocation) {
            this.xlocation = xlocation;
            return this;
        }

        public TextBuilder ylocation(float ylocation) {
            this.ylocation = ylocation;
            return this;
        }

        public TextBuilder text(String text) {
            this.text = text;
            return this;
        }

        public Text build() {
            Color textColor$value = this.textColor$value;
            if (!this.textColor$set) {
                textColor$value = Text.$default$textColor();
            }
            float fontSize$value = this.fontSize$value;
            if (!this.fontSize$set) {
                fontSize$value = Text.$default$fontSize();
            }
            return new Text(textColor$value, this.font, fontSize$value, this.xlocation, this.ylocation, this.text);
        }

        public String toString() {
            return "Text.TextBuilder(textColor$value=" + this.textColor$value + ", font=" + this.font + ", fontSize$value=" + this.fontSize$value + ", xlocation=" + this.xlocation + ", ylocation=" + this.ylocation + ", text=" + this.text + ")";
        }
    }
}

