/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard.header;

import java.time.LocalDateTime;
import org.apache.pdfbox.pdmodel.font.PDFont;
import tech.grasshopper.reporter.component.text.Text;
import tech.grasshopper.reporter.component.text.TextComponent;
import tech.grasshopper.reporter.optimizer.TextLengthOptimizer;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;

public class DashboardHeaderDisplay
extends Display {
    private static final int TITLE_FONT_SIZE = 22;
    private static final int TITLE_X_LOCATION = 50;
    private static final int DATE_FONT_SIZE = 16;
    private static final int DATE_X_LOCATION = 600;
    private static final int Y_LOCATION = 520;

    @Override
    public void display() {
        this.createReportTitleText();
        this.createReportDateText();
    }

    private void createReportTitleText() {
        PDFont titleFont = this.reportFont.getBoldFont();
        TextLengthOptimizer titleLengthOptimizer = TextLengthOptimizer.builder().font(titleFont).fontsize(22).spaceWidth(530).build();
        TextSanitizer textSanitizer = TextSanitizer.builder().font(titleFont).build();
        Text text = Text.builder().textColor(this.config.getReportTitleColor()).font(titleFont).fontSize(22.0f).text(titleLengthOptimizer.optimizeText(textSanitizer.sanitizeText(this.config.getReportTitle()))).xlocation(50.0f).ylocation(520.0f).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    private void createReportDateText() {
        Text text = Text.builder().textColor(this.config.getReportDateColor()).font(this.reportFont.getRegularFont()).fontSize(16.0f).xlocation(600.0f).ylocation(520.0f).text(LocalDateTime.now().format(this.config.getReportDateFormat())).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    protected DashboardHeaderDisplay(DashboardHeaderDisplayBuilder<?, ?> b) {
        super(b);
    }

    public static DashboardHeaderDisplayBuilder<?, ?> builder() {
        return new DashboardHeaderDisplayBuilderImpl();
    }

    @Override
    public String toString() {
        return "DashboardHeaderDisplay()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardHeaderDisplay)) {
            return false;
        }
        DashboardHeaderDisplay other = (DashboardHeaderDisplay)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashboardHeaderDisplay;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class DashboardHeaderDisplayBuilderImpl
    extends DashboardHeaderDisplayBuilder<DashboardHeaderDisplay, DashboardHeaderDisplayBuilderImpl> {
        private DashboardHeaderDisplayBuilderImpl() {
        }

        @Override
        protected DashboardHeaderDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardHeaderDisplay build() {
            return new DashboardHeaderDisplay(this);
        }
    }

    public static abstract class DashboardHeaderDisplayBuilder<C extends DashboardHeaderDisplay, B extends DashboardHeaderDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DashboardHeaderDisplay.DashboardHeaderDisplayBuilder(super=" + super.toString() + ")";
        }
    }
}

