/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard.legend;

import com.aventstack.extentreports.Status;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import tech.grasshopper.reporter.dashboard.AnalysisStrategyDisplay;
import tech.grasshopper.reporter.dashboard.legend.DashboardChartLegend;
import tech.grasshopper.reporter.structure.Display;

public class DashboardChartLegendDisplay
extends Display {
    private static final int TOP_LEGEND_Y_LOCATION = 180;
    private static final int CHART_TITLE_X_PADDING = 25;
    private static final Map<Status, Color> statusColor = new LinkedHashMap<Status, Color>();
    private AnalysisStrategyDisplay strategyDisplay;

    @Override
    public void display() {
        statusColor.put(Status.PASS, this.config.getPassColor());
        statusColor.put(Status.FAIL, this.config.getFailColor());
        statusColor.put(Status.SKIP, this.config.getSkipColor());
        statusColor.put(Status.WARNING, this.config.getWarnColor());
        statusColor.put(Status.INFO, this.config.getInfoColor());
        this.strategyDisplay = AnalysisStrategyDisplay.displaySettings(this.report);
        this.createFirstChartDataBox();
        this.createSecondChartDataBox();
        this.createThirdChartDataBox();
        this.createLogsChartDataBox();
    }

    private void createChartLegend(Map<Status, Long> data, float xLocation) {
        DashboardChartLegend.builder().content(this.content).xlocation(xLocation).ylocation(180.0f).statusColor(statusColor).statusData(data).keyFont(this.reportFont.getItalicFont()).valueFont(this.reportFont.getBoldFont()).build().display();
    }

    private void createFirstChartDataBox() {
        this.createChartLegend(this.report.getStats().getParent(), this.strategyDisplay.firstLevelChartXLocation() + 25);
    }

    private void createSecondChartDataBox() {
        this.createChartLegend(this.report.getStats().getChild(), this.strategyDisplay.secondLevelChartXLocation() + 25);
    }

    private void createThirdChartDataBox() {
        this.createChartLegend(this.report.getStats().getGrandchild(), this.strategyDisplay.thirdLevelChartXLocation() + 25);
    }

    private void createLogsChartDataBox() {
        if (this.strategyDisplay.displayLogsChart()) {
            this.createChartLegend(this.report.getStats().getLog(), this.strategyDisplay.logsChartXLocation() + 25);
        }
    }

    protected DashboardChartLegendDisplay(DashboardChartLegendDisplayBuilder<?, ?> b) {
        super(b);
        this.strategyDisplay = ((DashboardChartLegendDisplayBuilder)b).strategyDisplay;
    }

    public static DashboardChartLegendDisplayBuilder<?, ?> builder() {
        return new DashboardChartLegendDisplayBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardChartLegendDisplay)) {
            return false;
        }
        DashboardChartLegendDisplay other = (DashboardChartLegendDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnalysisStrategyDisplay this$strategyDisplay = this.strategyDisplay;
        AnalysisStrategyDisplay other$strategyDisplay = other.strategyDisplay;
        return !(this$strategyDisplay == null ? other$strategyDisplay != null : !((Object)((Object)this$strategyDisplay)).equals((Object)other$strategyDisplay));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashboardChartLegendDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnalysisStrategyDisplay $strategyDisplay = this.strategyDisplay;
        result = result * 59 + ($strategyDisplay == null ? 43 : ((Object)((Object)$strategyDisplay)).hashCode());
        return result;
    }

    private static final class DashboardChartLegendDisplayBuilderImpl
    extends DashboardChartLegendDisplayBuilder<DashboardChartLegendDisplay, DashboardChartLegendDisplayBuilderImpl> {
        private DashboardChartLegendDisplayBuilderImpl() {
        }

        @Override
        protected DashboardChartLegendDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardChartLegendDisplay build() {
            return new DashboardChartLegendDisplay(this);
        }
    }

    public static abstract class DashboardChartLegendDisplayBuilder<C extends DashboardChartLegendDisplay, B extends DashboardChartLegendDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private AnalysisStrategyDisplay strategyDisplay;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B strategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
            this.strategyDisplay = strategyDisplay;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DashboardChartLegendDisplay.DashboardChartLegendDisplayBuilder(super=" + super.toString() + ", strategyDisplay=" + (Object)((Object)this.strategyDisplay) + ")";
        }
    }
}

