/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.annotation.FileAnnotation;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.pdf.structure.cell.TextFileLinkCell;
import tech.grasshopper.pdf.structure.cell.TextLinkCell;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.medias.Medias;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.TestMedia;
import tech.grasshopper.reporter.tests.TestStackTrace;
import tech.grasshopper.reporter.tests.markup.TestMarkup;

public class LogDetailsCollector {
    private PDDocument document;
    protected ReportFont reportFont;
    protected Test test;
    protected ExtentPDFReporterConfig config;
    private AnnotationStore annotations;
    protected float width;
    private boolean bddReport;
    protected static final float PADDING = 5.0f;
    private static final float LOGS_MEDIA_HEIGHT = 100.0f;
    private static final float LOGS_MEDIA_WIDTH = 100.0f;
    protected static final int LOGS_TABLE_CONTENT_FONT_SIZE = 10;
    private static final int LOGS_STACK_TRACE_TABLE_CONTENT_FONT_SIZE = 10;
    private static final float LOGS_DETAILS_HEIGHT = 15.0f;
    private static final float LOGS_MEDIA_PLUS_WIDTH = 15.0f;

    public List<AbstractCell> createLogDetailCells(Log log) {
        ArrayList<AbstractCell> allDetailCells = new ArrayList<AbstractCell>();
        if (!log.getDetails().isEmpty()) {
            allDetailCells.add(this.createDetailsMarkupCell(log));
        }
        if (log.hasException()) {
            allDetailCells.add(this.createExceptionCell(log));
        }
        if (log.hasMedia()) {
            allDetailCells.add(this.createMediaCell(log));
        }
        return allDetailCells;
    }

    protected AbstractCell createDetailsMarkupCell(Log log) {
        PDFont LOGS_TABLE_CONTENT_FONT = this.reportFont.getRegularFont();
        TextSanitizer textSanitizer = TextSanitizer.builder().font(LOGS_TABLE_CONTENT_FONT).build();
        Status status = this.bddReport ? this.test.getStatus() : log.getStatus();
        TextCell detailMarkupCell = ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(textSanitizer.sanitizeText(log.getDetails())).font(LOGS_TABLE_CONTENT_FONT)).fontSize(Integer.valueOf(10))).textColor(this.config.statusColor(status))).build();
        if (TestMarkup.isMarkup(log.getDetails())) {
            detailMarkupCell = ((TestMarkup)((TestMarkup.TestMarkupBuilder)((TestMarkup.TestMarkupBuilder)((TestMarkup.TestMarkupBuilder)((TestMarkup.TestMarkupBuilder)((TestMarkup.TestMarkupBuilder)((TestMarkup.TestMarkupBuilder)TestMarkup.builder().log(log)).test(this.test)).bddReport(this.bddReport)).reportFont(this.reportFont)).width(this.width - 10.0f)).config(this.config)).build()).createMarkupCell();
        }
        return detailMarkupCell;
    }

    protected AbstractCell createMediaCell(Log log) {
        if (this.config.isDisplayExpandedMedia() || this.config.isDisplayAttachedMedia()) {
            Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{15.0f, this.width - 15.0f}).padding(0.0f);
            Medias testMedia = ((TestMedia.TestMediaBuilder)((Medias.MediasBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)TestMedia.builder().media(log.getMedia())).document(this.document)).padding(5.0f)).width(this.width - 15.0f)).height(100.0f)).locations(this.config.getMediaFolders())).build();
            ImageCell image = ((TestMedia)testMedia).createImageCell();
            boolean imageAbsent = testMedia.isImageNotAvailable();
            if (imageAbsent) {
                tableBuilder.addRow(Row.builder().add((AbstractCell)TextCell.builder().text(" ").build()).add((AbstractCell)image).build());
            } else if (this.config.isDisplayExpandedMedia()) {
                Annotation annotation = Annotation.builder().id(this.test.getId()).build();
                this.annotations.addTestMediaAnnotation(annotation);
                tableBuilder.addRow(Row.builder().add((AbstractCell)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().text("+")).annotation(annotation).font(this.reportFont.getRegularFont())).fontSize(Integer.valueOf(15))).textColor(Color.RED)).showLine(false).verticalAlignment(VerticalAlignment.TOP)).horizontalAlignment(HorizontalAlignment.CENTER)).build()).add((AbstractCell)image).build());
            } else {
                ArrayList<FileAnnotation> fileAnnotations = new ArrayList<FileAnnotation>();
                fileAnnotations.add(FileAnnotation.builder().text(" ").link(log.getMedia().getResolvedPath()).build());
                tableBuilder.addRow(Row.builder().add((AbstractCell)((TextFileLinkCell.TextFileLinkCellBuilder)TextFileLinkCell.builder().text(" ")).annotations(fileAnnotations).build()).add((AbstractCell)image).build());
                this.annotations.addTestMediaFileAnnotation((FileAnnotation)fileAnnotations.get(0));
            }
            return ((TableWithinTableCell.TableWithinTableCellBuilder)TableWithinTableCell.builder().table(tableBuilder.build()).width(this.width - 15.0f)).build();
        }
        return ((TestMedia)((TestMedia.TestMediaBuilder)((Medias.MediasBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)TestMedia.builder().media(log.getMedia())).document(this.document)).width(100.0f)).height(100.0f)).padding(5.0f)).build()).createImageCell();
    }

    protected AbstractCell createExceptionCell(Log log) {
        return TestStackTrace.builder().log(log).font(this.reportFont.getRegularFont()).color(this.config.getTestExceptionColor()).width(this.width - 10.0f).height(15.0f).fontSize(10).padding(5.0f).build().createStackTraceCell();
    }

    private static boolean $default$bddReport() {
        return false;
    }

    protected LogDetailsCollector(LogDetailsCollectorBuilder<?, ?> b) {
        this.document = ((LogDetailsCollectorBuilder)b).document;
        this.reportFont = ((LogDetailsCollectorBuilder)b).reportFont;
        this.test = ((LogDetailsCollectorBuilder)b).test;
        this.config = ((LogDetailsCollectorBuilder)b).config;
        this.annotations = ((LogDetailsCollectorBuilder)b).annotations;
        this.width = ((LogDetailsCollectorBuilder)b).width;
        this.bddReport = ((LogDetailsCollectorBuilder)b).bddReport$set ? ((LogDetailsCollectorBuilder)b).bddReport$value : LogDetailsCollector.$default$bddReport();
    }

    public static LogDetailsCollectorBuilder<?, ?> builder() {
        return new LogDetailsCollectorBuilderImpl();
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public ReportFont getReportFont() {
        return this.reportFont;
    }

    public Test getTest() {
        return this.test;
    }

    public ExtentPDFReporterConfig getConfig() {
        return this.config;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isBddReport() {
        return this.bddReport;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setReportFont(ReportFont reportFont) {
        this.reportFont = reportFont;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setConfig(ExtentPDFReporterConfig config) {
        this.config = config;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setBddReport(boolean bddReport) {
        this.bddReport = bddReport;
    }

    public String toString() {
        return "LogDetailsCollector(document=" + this.getDocument() + ", reportFont=" + this.getReportFont() + ", test=" + this.getTest() + ", config=" + (Object)((Object)this.getConfig()) + ", annotations=" + this.getAnnotations() + ", width=" + this.getWidth() + ", bddReport=" + this.isBddReport() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogDetailsCollector)) {
            return false;
        }
        LogDetailsCollector other = (LogDetailsCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (this.isBddReport() != other.isBddReport()) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        ReportFont this$reportFont = this.getReportFont();
        ReportFont other$reportFont = other.getReportFont();
        if (this$reportFont == null ? other$reportFont != null : !this$reportFont.equals(other$reportFont)) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        ExtentPDFReporterConfig this$config = this.getConfig();
        ExtentPDFReporterConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)((Object)this$config)).equals((Object)other$config)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogDetailsCollector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + (this.isBddReport() ? 79 : 97);
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        ReportFont $reportFont = this.getReportFont();
        result = result * 59 + ($reportFont == null ? 43 : $reportFont.hashCode());
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        ExtentPDFReporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)((Object)$config)).hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    private static final class LogDetailsCollectorBuilderImpl
    extends LogDetailsCollectorBuilder<LogDetailsCollector, LogDetailsCollectorBuilderImpl> {
        private LogDetailsCollectorBuilderImpl() {
        }

        @Override
        protected LogDetailsCollectorBuilderImpl self() {
            return this;
        }

        @Override
        public LogDetailsCollector build() {
            return new LogDetailsCollector(this);
        }
    }

    public static abstract class LogDetailsCollectorBuilder<C extends LogDetailsCollector, B extends LogDetailsCollectorBuilder<C, B>> {
        private PDDocument document;
        private ReportFont reportFont;
        private Test test;
        private ExtentPDFReporterConfig config;
        private AnnotationStore annotations;
        private float width;
        private boolean bddReport$set;
        private boolean bddReport$value;

        protected abstract B self();

        public abstract C build();

        public B document(PDDocument document) {
            this.document = document;
            return this.self();
        }

        public B reportFont(ReportFont reportFont) {
            this.reportFont = reportFont;
            return this.self();
        }

        public B test(Test test) {
            this.test = test;
            return this.self();
        }

        public B config(ExtentPDFReporterConfig config) {
            this.config = config;
            return this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return this.self();
        }

        public B width(float width) {
            this.width = width;
            return this.self();
        }

        public B bddReport(boolean bddReport) {
            this.bddReport$value = bddReport;
            this.bddReport$set = true;
            return this.self();
        }

        public String toString() {
            return "LogDetailsCollector.LogDetailsCollectorBuilder(document=" + this.document + ", reportFont=" + this.reportFont + ", test=" + this.test + ", config=" + (Object)((Object)this.config) + ", annotations=" + this.annotations + ", width=" + this.width + ", bddReport$value=" + this.bddReport$value + ")";
        }
    }
}

