/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;
import tech.grasshopper.reporter.tests.LogDetailsCollector;

public class TestBDDExecutableDisplay
extends Display {
    private final PDFont CONTENT_FONT;
    private static final int CONTENT_FONT_SIZE = 12;
    private static final int LOGS_TABLE_CONTENT_FONT_SIZE = 10;
    private final PDFont LOGS_TABLE_CONTENT_FONT;
    private static final float PADDING = 5.0f;
    private static final float WIDTH = 500.0f;
    private static final float GAP_HEIGHT = 5.0f;
    private static final float CONTENT_HEIGHT = 20.0f;
    private static final float BORDER_WIDTH = 1.0f;
    protected Test test;
    private Table.TableBuilder tableBuilder;
    private AnnotationStore annotations;
    protected final TextSanitizer textSanitizer;

    @Override
    public void display() {
        this.xlocation += (float)(this.test.getLevel() * 20);
        this.createTableBuilder();
        this.createExecutableRow();
        this.drawTable();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{500.0f - (float)(this.test.getLevel() * 20)}).padding(5.0f).borderWidth(1.0f).borderColor(Color.LIGHT_GRAY).font(this.CONTENT_FONT).fontSize(Integer.valueOf(12)).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.MIDDLE);
    }

    private void createExecutableRow() {
        this.test.getChildren().forEach(t -> {
            ArrayList<AbstractCell> nameAndLogDetails = new ArrayList<AbstractCell>();
            nameAndLogDetails.add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().minHeight(20.0f)).text(this.textSanitizer.sanitizeText(t.getName())).textColor(this.config.statusColor(t.getStatus()))).font(this.LOGS_TABLE_CONTENT_FONT)).fontSize(Integer.valueOf(10))).build());
            Object logDetailsCollector = ((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)((LogDetailsCollector.LogDetailsCollectorBuilder)LogDetailsCollector.builder().annotations(this.annotations)).config(this.config)).document(this.document)).reportFont(this.reportFont)).test((Test)t)).bddReport(true)).width(500.0f - (float)(this.test.getLevel() * 20))).build();
            t.getLogs().forEach(l -> {
                List<AbstractCell> cellDetails = logDetailsCollector.createLogDetailCells((Log)l);
                if (!cellDetails.isEmpty()) {
                    nameAndLogDetails.addAll(cellDetails);
                }
            });
            if (nameAndLogDetails.size() == 1) {
                this.tableBuilder.addRow(Row.builder().add((AbstractCell)nameAndLogDetails.get(0)).padding(5.0f).build());
            } else if (nameAndLogDetails.size() > 1) {
                this.tableBuilder.addRow(Row.builder().add(this.createMultipleDetailsLogCell(nameAndLogDetails)).padding(5.0f).build());
            }
        });
    }

    private AbstractCell createMultipleDetailsLogCell(List<AbstractCell> allDetailCells) {
        Table.TableBuilder multipleDetailsBuilder = Table.builder().addColumnsOfWidth(new float[]{500.0f - (float)(this.test.getLevel() * 20)}).borderWidth(0.0f);
        allDetailCells.forEach(c -> {
            if (c != null) {
                multipleDetailsBuilder.addRow(Row.builder().add(c).build());
            }
        });
        return ((TableWithinTableCell.TableWithinTableCellBuilder)TableWithinTableCell.builder().table(multipleDetailsBuilder.build()).padding(0.0f)).build();
    }

    private void drawTable() {
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(0).splitRow(true).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 5.0f;
    }

    protected TestBDDExecutableDisplay(TestBDDExecutableDisplayBuilder<?, ?> b) {
        super(b);
        this.CONTENT_FONT = this.reportFont.getItalicFont();
        this.LOGS_TABLE_CONTENT_FONT = this.reportFont.getRegularFont();
        this.textSanitizer = TextSanitizer.builder().font(this.CONTENT_FONT).build();
        this.test = ((TestBDDExecutableDisplayBuilder)b).test;
        this.tableBuilder = ((TestBDDExecutableDisplayBuilder)b).tableBuilder;
        this.annotations = ((TestBDDExecutableDisplayBuilder)b).annotations;
    }

    public static TestBDDExecutableDisplayBuilder<?, ?> builder() {
        return new TestBDDExecutableDisplayBuilderImpl();
    }

    public PDFont getCONTENT_FONT() {
        return this.CONTENT_FONT;
    }

    public PDFont getLOGS_TABLE_CONTENT_FONT() {
        return this.LOGS_TABLE_CONTENT_FONT;
    }

    public Test getTest() {
        return this.test;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    @Override
    public String toString() {
        return "TestBDDExecutableDisplay(CONTENT_FONT=" + this.getCONTENT_FONT() + ", LOGS_TABLE_CONTENT_FONT=" + this.getLOGS_TABLE_CONTENT_FONT() + ", test=" + this.getTest() + ", tableBuilder=" + this.getTableBuilder() + ", annotations=" + this.getAnnotations() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestBDDExecutableDisplay)) {
            return false;
        }
        TestBDDExecutableDisplay other = (TestBDDExecutableDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDFont this$CONTENT_FONT = this.getCONTENT_FONT();
        PDFont other$CONTENT_FONT = other.getCONTENT_FONT();
        if (this$CONTENT_FONT == null ? other$CONTENT_FONT != null : !this$CONTENT_FONT.equals(other$CONTENT_FONT)) {
            return false;
        }
        PDFont this$LOGS_TABLE_CONTENT_FONT = this.getLOGS_TABLE_CONTENT_FONT();
        PDFont other$LOGS_TABLE_CONTENT_FONT = other.getLOGS_TABLE_CONTENT_FONT();
        if (this$LOGS_TABLE_CONTENT_FONT == null ? other$LOGS_TABLE_CONTENT_FONT != null : !this$LOGS_TABLE_CONTENT_FONT.equals(other$LOGS_TABLE_CONTENT_FONT)) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestBDDExecutableDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDFont $CONTENT_FONT = this.getCONTENT_FONT();
        result = result * 59 + ($CONTENT_FONT == null ? 43 : $CONTENT_FONT.hashCode());
        PDFont $LOGS_TABLE_CONTENT_FONT = this.getLOGS_TABLE_CONTENT_FONT();
        result = result * 59 + ($LOGS_TABLE_CONTENT_FONT == null ? 43 : $LOGS_TABLE_CONTENT_FONT.hashCode());
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    private static final class TestBDDExecutableDisplayBuilderImpl
    extends TestBDDExecutableDisplayBuilder<TestBDDExecutableDisplay, TestBDDExecutableDisplayBuilderImpl> {
        private TestBDDExecutableDisplayBuilderImpl() {
        }

        @Override
        protected TestBDDExecutableDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public TestBDDExecutableDisplay build() {
            return new TestBDDExecutableDisplay(this);
        }
    }

    public static abstract class TestBDDExecutableDisplayBuilder<C extends TestBDDExecutableDisplay, B extends TestBDDExecutableDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Test test;
        private Table.TableBuilder tableBuilder;
        private AnnotationStore annotations;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B test(Test test) {
            this.test = test;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestBDDExecutableDisplay.TestBDDExecutableDisplayBuilder(super=" + super.toString() + ", test=" + this.test + ", tableBuilder=" + this.tableBuilder + ", annotations=" + this.annotations + ")";
        }
    }
}

