/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class JsonMarkup
extends MarkupDisplay {
    private static final Logger logger = Logger.getLogger(JsonMarkup.class.getName());
    private String html;

    @Override
    public AbstractCell displayDetails() {
        TextSanitizer textSanitizer = TextSanitizer.builder().font(this.logFont).build();
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(textSanitizer.sanitizeText(this.jsonText())).textColor(this.textColor)).fontSize(Integer.valueOf(11))).font(this.logFont)).lineSpacing(1.0f)).build();
    }

    private String jsonText() {
        try {
            String jsonStringHolder = this.html.substring(this.html.indexOf("JSONTree"));
            int startIndex = jsonStringHolder.indexOf(123);
            if (startIndex == -1) {
                return "";
            }
            int endIndex = startIndex;
            int bktCnt = 0;
            for (char c : jsonStringHolder.substring(startIndex).toCharArray()) {
                ++endIndex;
                if (c == '{') {
                    ++bktCnt;
                } else if (c == '}') {
                    --bktCnt;
                }
                if (bktCnt == 0) break;
            }
            if (endIndex == startIndex) {
                return "";
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson(JsonParser.parseString((String)jsonStringHolder.substring(startIndex, endIndex)));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to process JSON code block.");
            return "Error in accessing and processing JSON code block.";
        }
    }

    protected JsonMarkup(JsonMarkupBuilder<?, ?> b) {
        super(b);
        this.html = ((JsonMarkupBuilder)b).html;
    }

    public static JsonMarkupBuilder<?, ?> builder() {
        return new JsonMarkupBuilderImpl();
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    @Override
    public String toString() {
        return "JsonMarkup(html=" + this.getHtml() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonMarkup)) {
            return false;
        }
        JsonMarkup other = (JsonMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$html = this.getHtml();
        String other$html = other.getHtml();
        return !(this$html == null ? other$html != null : !this$html.equals(other$html));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsonMarkup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $html = this.getHtml();
        result = result * 59 + ($html == null ? 43 : $html.hashCode());
        return result;
    }

    private static final class JsonMarkupBuilderImpl
    extends JsonMarkupBuilder<JsonMarkup, JsonMarkupBuilderImpl> {
        private JsonMarkupBuilderImpl() {
        }

        @Override
        protected JsonMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public JsonMarkup build() {
            return new JsonMarkup(this);
        }
    }

    public static abstract class JsonMarkupBuilder<C extends JsonMarkup, B extends JsonMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        private String html;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B html(String html) {
            this.html = html;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "JsonMarkup.JsonMarkupBuilder(super=" + super.toString() + ", html=" + this.html + ")";
        }
    }
}

