/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.nodes.Element;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class OrderedListMarkup
extends MarkupDisplay {
    private static final Logger logger = Logger.getLogger(OrderedListMarkup.class.getName());
    private float width;
    private static final float SNO_COLUMN_WIDTH = 25.0f;

    @Override
    public AbstractCell displayDetails() {
        return TableWithinTableCell.builder().table(this.listTable()).build();
    }

    private Table listTable() {
        Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{25.0f, this.width - 25.0f}).fontSize(Integer.valueOf(11)).font(this.logFont).borderWidth(0.0f).wordBreak(Boolean.valueOf(true));
        TextSanitizer textSanitizer = TextSanitizer.builder().font(this.logFont).build();
        int sno = 1;
        for (Element elem : this.elements) {
            String text = "";
            try {
                text = elem.text();
            }
            catch (Exception e) {
                text = "Error in accessing line.";
                logger.log(Level.SEVERE, "Unable to get text for cell, default to error message.");
            }
            tableBuilder.addRow(Row.builder().add((AbstractCell)TextCell.builder().text(String.valueOf(sno)).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(textSanitizer.sanitizeText(text)).textColor(this.textColor)).lineSpacing(1.0f)).build()).build());
            ++sno;
        }
        return tableBuilder.build();
    }

    protected OrderedListMarkup(OrderedListMarkupBuilder<?, ?> b) {
        super(b);
        this.width = ((OrderedListMarkupBuilder)b).width;
    }

    public static OrderedListMarkupBuilder<?, ?> builder() {
        return new OrderedListMarkupBuilderImpl();
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public String toString() {
        return "OrderedListMarkup(width=" + this.getWidth() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderedListMarkup)) {
            return false;
        }
        OrderedListMarkup other = (OrderedListMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getWidth(), other.getWidth()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrderedListMarkup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        return result;
    }

    private static final class OrderedListMarkupBuilderImpl
    extends OrderedListMarkupBuilder<OrderedListMarkup, OrderedListMarkupBuilderImpl> {
        private OrderedListMarkupBuilderImpl() {
        }

        @Override
        protected OrderedListMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public OrderedListMarkup build() {
            return new OrderedListMarkup(this);
        }
    }

    public static abstract class OrderedListMarkupBuilder<C extends OrderedListMarkup, B extends OrderedListMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        private float width;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B width(float width) {
            this.width = width;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "OrderedListMarkup.OrderedListMarkupBuilder(super=" + super.toString() + ", width=" + this.width + ")";
        }
    }
}

