/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.tests.markup.CodeBlockMarkup;
import tech.grasshopper.reporter.tests.markup.DefaultMarkup;
import tech.grasshopper.reporter.tests.markup.JsonMarkup;
import tech.grasshopper.reporter.tests.markup.LabelMarkup;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;
import tech.grasshopper.reporter.tests.markup.OrderedListMarkup;
import tech.grasshopper.reporter.tests.markup.TableMarkup;
import tech.grasshopper.reporter.tests.markup.UnorderedListMarkup;

public class TestMarkup {
    private static final Logger logger = Logger.getLogger(TestMarkup.class.getName());
    private Test test;
    private Log log;
    protected float width;
    protected ExtentPDFReporterConfig config;
    @NonNull
    protected ReportFont reportFont;
    private boolean bddReport;

    public AbstractCell createMarkupCell() {
        String html = this.log.getDetails();
        Status status = this.bddReport ? this.test.getStatus() : this.log.getStatus();
        Document document = null;
        try {
            document = Jsoup.parseBodyFragment((String)html);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error is parsing markup html, diplaying raw log details");
            return this.displayDefault(status);
        }
        Element element = document.selectFirst("body > span[class*=\"badge\"]");
        if (element != null) {
            return this.createLabelMarkup(element);
        }
        element = document.selectFirst("body > table[class*=\"markup-table table\"]");
        if (element != null) {
            return this.createTableMarkup(status, element);
        }
        Elements elements = document.select("body > ol > li");
        if (elements.size() > 0) {
            return this.createOrderedListMarkup(status, elements);
        }
        elements = document.select("body > ul > li");
        if (elements.size() > 0) {
            return this.createUnorderedListMarkup(status, elements);
        }
        elements = document.select("body textarea[class*=\"code-block\"]");
        if (elements.size() > 0) {
            return this.createCodeBlockMarkup(status, elements);
        }
        if (html.contains("JSONTree")) {
            return this.createJsonMarkup(html, status);
        }
        return this.displayDefault(status);
    }

    protected AbstractCell createJsonMarkup(String html, Status status) {
        return ((JsonMarkup)((JsonMarkup.JsonMarkupBuilder)((JsonMarkup.JsonMarkupBuilder)((MarkupDisplay.MarkupDisplayBuilder)JsonMarkup.builder().html(html)).logFont(this.reportFont.getRegularFont())).textColor(this.config.statusColor(status))).build()).displayDetails();
    }

    protected AbstractCell createCodeBlockMarkup(Status status, Elements elements) {
        return ((CodeBlockMarkup)((CodeBlockMarkup.CodeBlockMarkupBuilder)((CodeBlockMarkup.CodeBlockMarkupBuilder)((CodeBlockMarkup.CodeBlockMarkupBuilder)((CodeBlockMarkup.CodeBlockMarkupBuilder)CodeBlockMarkup.builder().elements(elements)).logFont(this.reportFont.getRegularFont())).textColor(this.config.statusColor(status))).width(this.width)).build()).displayDetails();
    }

    protected AbstractCell createUnorderedListMarkup(Status status, Elements elements) {
        return ((UnorderedListMarkup)((UnorderedListMarkup.UnorderedListMarkupBuilder)((UnorderedListMarkup.UnorderedListMarkupBuilder)((UnorderedListMarkup.UnorderedListMarkupBuilder)((UnorderedListMarkup.UnorderedListMarkupBuilder)UnorderedListMarkup.builder().elements(elements)).logFont(this.reportFont.getRegularFont())).textColor(this.config.statusColor(status))).width(this.width)).build()).displayDetails();
    }

    protected AbstractCell createOrderedListMarkup(Status status, Elements elements) {
        return ((OrderedListMarkup)((OrderedListMarkup.OrderedListMarkupBuilder)((OrderedListMarkup.OrderedListMarkupBuilder)((OrderedListMarkup.OrderedListMarkupBuilder)((OrderedListMarkup.OrderedListMarkupBuilder)OrderedListMarkup.builder().elements(elements)).logFont(this.reportFont.getRegularFont())).textColor(this.config.statusColor(status))).width(this.width)).build()).displayDetails();
    }

    protected AbstractCell createTableMarkup(Status status, Element element) {
        return ((TableMarkup)((TableMarkup.TableMarkupBuilder)((TableMarkup.TableMarkupBuilder)((TableMarkup.TableMarkupBuilder)((TableMarkup.TableMarkupBuilder)((TableMarkup.TableMarkupBuilder)TableMarkup.builder().element(element)).logFont(this.reportFont.getRegularFont())).textColor(this.config.statusColor(status))).maxTableColumnCount(this.config.getMaxTableColumnCount())).width(this.width)).build()).displayDetails();
    }

    protected AbstractCell createLabelMarkup(Element element) {
        return ((LabelMarkup)((LabelMarkup.LabelMarkupBuilder)((LabelMarkup.LabelMarkupBuilder)LabelMarkup.builder().element(element)).logFont(this.reportFont.getRegularFont())).build()).displayDetails();
    }

    private AbstractCell displayDefault(Status status) {
        return ((DefaultMarkup)((DefaultMarkup.DefaultMarkupBuilder)((DefaultMarkup.DefaultMarkupBuilder)((MarkupDisplay.MarkupDisplayBuilder)DefaultMarkup.builder().log(this.log)).logFont(this.reportFont.getRegularFont())).textColor(this.config.statusColor(status))).build()).displayDetails();
    }

    public static boolean isMarkup(String markup) {
        return markup.trim().startsWith("<") && markup.trim().endsWith(">");
    }

    private static boolean $default$bddReport() {
        return false;
    }

    protected TestMarkup(TestMarkupBuilder<?, ?> b) {
        this.test = ((TestMarkupBuilder)b).test;
        this.log = ((TestMarkupBuilder)b).log;
        this.width = ((TestMarkupBuilder)b).width;
        this.config = ((TestMarkupBuilder)b).config;
        this.reportFont = ((TestMarkupBuilder)b).reportFont;
        if (this.reportFont == null) {
            throw new NullPointerException("reportFont is marked non-null but is null");
        }
        this.bddReport = ((TestMarkupBuilder)b).bddReport$set ? ((TestMarkupBuilder)b).bddReport$value : TestMarkup.$default$bddReport();
    }

    public static TestMarkupBuilder<?, ?> builder() {
        return new TestMarkupBuilderImpl();
    }

    public Test getTest() {
        return this.test;
    }

    public Log getLog() {
        return this.log;
    }

    public float getWidth() {
        return this.width;
    }

    public ExtentPDFReporterConfig getConfig() {
        return this.config;
    }

    @NonNull
    public ReportFont getReportFont() {
        return this.reportFont;
    }

    public boolean isBddReport() {
        return this.bddReport;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setConfig(ExtentPDFReporterConfig config) {
        this.config = config;
    }

    public void setReportFont(@NonNull ReportFont reportFont) {
        if (reportFont == null) {
            throw new NullPointerException("reportFont is marked non-null but is null");
        }
        this.reportFont = reportFont;
    }

    public void setBddReport(boolean bddReport) {
        this.bddReport = bddReport;
    }

    public String toString() {
        return "TestMarkup(test=" + this.getTest() + ", log=" + this.getLog() + ", width=" + this.getWidth() + ", config=" + (Object)((Object)this.getConfig()) + ", reportFont=" + this.getReportFont() + ", bddReport=" + this.isBddReport() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestMarkup)) {
            return false;
        }
        TestMarkup other = (TestMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (this.isBddReport() != other.isBddReport()) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        ExtentPDFReporterConfig this$config = this.getConfig();
        ExtentPDFReporterConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)((Object)this$config)).equals((Object)other$config)) {
            return false;
        }
        ReportFont this$reportFont = this.getReportFont();
        ReportFont other$reportFont = other.getReportFont();
        return !(this$reportFont == null ? other$reportFont != null : !this$reportFont.equals(other$reportFont));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestMarkup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + (this.isBddReport() ? 79 : 97);
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        ExtentPDFReporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)((Object)$config)).hashCode());
        ReportFont $reportFont = this.getReportFont();
        result = result * 59 + ($reportFont == null ? 43 : $reportFont.hashCode());
        return result;
    }

    private static final class TestMarkupBuilderImpl
    extends TestMarkupBuilder<TestMarkup, TestMarkupBuilderImpl> {
        private TestMarkupBuilderImpl() {
        }

        @Override
        protected TestMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public TestMarkup build() {
            return new TestMarkup(this);
        }
    }

    public static abstract class TestMarkupBuilder<C extends TestMarkup, B extends TestMarkupBuilder<C, B>> {
        private Test test;
        private Log log;
        private float width;
        private ExtentPDFReporterConfig config;
        private ReportFont reportFont;
        private boolean bddReport$set;
        private boolean bddReport$value;

        protected abstract B self();

        public abstract C build();

        public B test(Test test) {
            this.test = test;
            return this.self();
        }

        public B log(Log log) {
            this.log = log;
            return this.self();
        }

        public B width(float width) {
            this.width = width;
            return this.self();
        }

        public B config(ExtentPDFReporterConfig config) {
            this.config = config;
            return this.self();
        }

        public B reportFont(@NonNull ReportFont reportFont) {
            if (reportFont == null) {
                throw new NullPointerException("reportFont is marked non-null but is null");
            }
            this.reportFont = reportFont;
            return this.self();
        }

        public B bddReport(boolean bddReport) {
            this.bddReport$value = bddReport;
            this.bddReport$set = true;
            return this.self();
        }

        public String toString() {
            return "TestMarkup.TestMarkupBuilder(test=" + this.test + ", log=" + this.log + ", width=" + this.width + ", config=" + (Object)((Object)this.config) + ", reportFont=" + this.reportFont + ", bddReport$value=" + this.bddReport$value + ")";
        }
    }
}

