/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.nodes.Element;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class UnorderedListMarkup
extends MarkupDisplay {
    private static final Logger logger = Logger.getLogger(UnorderedListMarkup.class.getName());
    private float width;
    private static final float STAR_COLUMN_WIDTH = 15.0f;

    @Override
    public AbstractCell displayDetails() {
        return TableWithinTableCell.builder().table(this.listTable()).build();
    }

    private Table listTable() {
        Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{15.0f, this.width - 15.0f}).fontSize(Integer.valueOf(11)).font(this.logFont).borderWidth(0.0f).wordBreak(Boolean.valueOf(true));
        TextSanitizer textSanitizer = TextSanitizer.builder().font(this.logFont).build();
        for (Element elem : this.elements) {
            String text = "";
            try {
                text = elem.text();
            }
            catch (Exception e) {
                text = "Error in accessing line.";
                logger.log(Level.SEVERE, "Unable to get text for cell, default to error message.");
            }
            tableBuilder.addRow(Row.builder().add((AbstractCell)TextCell.builder().text("*").build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(textSanitizer.sanitizeText(text)).textColor(this.textColor)).lineSpacing(1.0f)).build()).build());
        }
        return tableBuilder.build();
    }

    protected UnorderedListMarkup(UnorderedListMarkupBuilder<?, ?> b) {
        super(b);
        this.width = ((UnorderedListMarkupBuilder)b).width;
    }

    public static UnorderedListMarkupBuilder<?, ?> builder() {
        return new UnorderedListMarkupBuilderImpl();
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public String toString() {
        return "UnorderedListMarkup(width=" + this.getWidth() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnorderedListMarkup)) {
            return false;
        }
        UnorderedListMarkup other = (UnorderedListMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getWidth(), other.getWidth()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnorderedListMarkup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        return result;
    }

    private static final class UnorderedListMarkupBuilderImpl
    extends UnorderedListMarkupBuilder<UnorderedListMarkup, UnorderedListMarkupBuilderImpl> {
        private UnorderedListMarkupBuilderImpl() {
        }

        @Override
        protected UnorderedListMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public UnorderedListMarkup build() {
            return new UnorderedListMarkup(this);
        }
    }

    public static abstract class UnorderedListMarkupBuilder<C extends UnorderedListMarkup, B extends UnorderedListMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        private float width;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B width(float width) {
            this.width = width;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "UnorderedListMarkup.UnorderedListMarkupBuilder(super=" + super.toString() + ", width=" + this.width + ")";
        }
    }
}

