/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.annotation.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import tech.grasshopper.pdf.annotation.file.FileAnnotationStore;

public class FileAnnotationProcessor {
    @NonNull
    private FileAnnotationStore annotations;
    private PDDocument document;
    private File reportFile;
    private static final Logger logger = Logger.getLogger(FileAnnotationProcessor.class.getName());

    public void processAnnotations() {
        this.annotations.getFileAnnotation().forEach(f -> {
            try {
                PDAnnotationFileAttachment fileAtt = new PDAnnotationFileAttachment();
                fileAtt.setRectangle(f.getRectangle());
                PDColor pdColor = new PDColor(new float[]{0.5f, 0.5f, 0.5f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
                fileAtt.setColor(pdColor);
                PDEmbeddedFile ef = new PDEmbeddedFile(this.document, (InputStream)new FileInputStream(Paths.get(this.reportFile.getParent(), f.getLink()).toString()));
                ef.setSubtype("text/html; charset=UTF-8");
                ef.setModDate((Calendar)new GregorianCalendar());
                ef.setCreationDate((Calendar)new GregorianCalendar());
                PDComplexFileSpecification fs = new PDComplexFileSpecification();
                fs.setEmbeddedFile(ef);
                fs.setFile(f.getLink());
                fs.setFileUnicode(f.getLink());
                fileAtt.setFile((PDFileSpecification)fs);
                f.getPage().getAnnotations().add(fileAtt);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to create file annotation link", e);
            }
        });
    }

    FileAnnotationProcessor(@NonNull FileAnnotationStore annotations, PDDocument document, File reportFile) {
        if (annotations == null) {
            throw new NullPointerException("annotations is marked non-null but is null");
        }
        this.annotations = annotations;
        this.document = document;
        this.reportFile = reportFile;
    }

    public static FileAnnotationProcessorBuilder builder() {
        return new FileAnnotationProcessorBuilder();
    }

    @NonNull
    public FileAnnotationStore getAnnotations() {
        return this.annotations;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setAnnotations(@NonNull FileAnnotationStore annotations) {
        if (annotations == null) {
            throw new NullPointerException("annotations is marked non-null but is null");
        }
        this.annotations = annotations;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileAnnotationProcessor)) {
            return false;
        }
        FileAnnotationProcessor other = (FileAnnotationProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileAnnotationStore this$annotations = this.getAnnotations();
        FileAnnotationStore other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        File this$reportFile = this.getReportFile();
        File other$reportFile = other.getReportFile();
        return !(this$reportFile == null ? other$reportFile != null : !((Object)this$reportFile).equals(other$reportFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileAnnotationProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileAnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        File $reportFile = this.getReportFile();
        result = result * 59 + ($reportFile == null ? 43 : ((Object)$reportFile).hashCode());
        return result;
    }

    public String toString() {
        return "FileAnnotationProcessor(annotations=" + this.getAnnotations() + ", document=" + this.getDocument() + ", reportFile=" + this.getReportFile() + ")";
    }

    public static class FileAnnotationProcessorBuilder {
        private FileAnnotationStore annotations;
        private PDDocument document;
        private File reportFile;

        FileAnnotationProcessorBuilder() {
        }

        public FileAnnotationProcessorBuilder annotations(@NonNull FileAnnotationStore annotations) {
            if (annotations == null) {
                throw new NullPointerException("annotations is marked non-null but is null");
            }
            this.annotations = annotations;
            return this;
        }

        public FileAnnotationProcessorBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public FileAnnotationProcessorBuilder reportFile(File reportFile) {
            this.reportFile = reportFile;
            return this;
        }

        public FileAnnotationProcessor build() {
            return new FileAnnotationProcessor(this.annotations, this.document, this.reportFile);
        }

        public String toString() {
            return "FileAnnotationProcessor.FileAnnotationProcessorBuilder(annotations=" + this.annotations + ", document=" + this.document + ", reportFile=" + this.reportFile + ")";
        }
    }
}

