/*
 * Decompiled with CFR 0.152.
 */
package org.vandeseer.easytable.split;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.split.CellDataSplitter;
import org.vandeseer.easytable.split.MinimumHeightSplitCellException;
import org.vandeseer.easytable.split.SplitCellData;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.util.PdfUtil;

public class TextCellDataSplitter
implements CellDataSplitter {
    private TextCell cell;
    private float availableHeight;
    private float lineSpacing;

    @Override
    public SplitCellData splitContents() {
        SplitCellData data = new SplitCellData();
        float lineHeight = PdfUtil.getFontHeight(this.cell.getFont(), this.cell.getFontSize());
        float minimumHeight = lineHeight + this.cell.getVerticalPadding();
        if (minimumHeight > this.availableHeight) {
            throw new MinimumHeightSplitCellException();
        }
        List<String> lines = this.calculateAndGetLines(this.cell.getFont(), this.cell.getFontSize(), this.cell.getWidth() - this.cell.getHorizontalPadding());
        int count = this.lineCountInSamePage(lines, this.availableHeight, lineHeight);
        this.updateSamePageCellData(lines, data, count, lineHeight);
        this.updateNextPageCellData(lines, data, count, lineHeight);
        return data;
    }

    private List<String> calculateAndGetLines(PDFont currentFont, int currentFontSize, float maxWidth) {
        return this.cell.isWordBreak() ? PdfUtil.getOptimalTextBreakLines(this.cell.getText(), currentFont, currentFontSize, maxWidth) : Collections.singletonList(this.cell.getText());
    }

    private int lineCountInSamePage(List<String> lines, float height, float lineHeight) {
        float textHeight = this.cell.getVerticalPadding();
        int count = 0;
        for (count = 0; count < lines.size(); ++count) {
            textHeight += lineHeight;
            if (count > 0) {
                textHeight += lineHeight * this.lineSpacing;
            }
            if (textHeight > height) break;
        }
        return count;
    }

    private void updateSamePageCellData(List<String> lines, SplitCellData data, int count, float lineHeight) {
        String initialText = lines.subList(0, count).stream().collect(Collectors.joining(" "));
        data.setSamePageCell(((TextCell.TextCellBuilder)((AbstractCell.AbstractCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().settings(this.cell.getSettings())).colSpan(this.cell.getColSpan())).rowSpan(this.cell.getRowSpan())).text(initialText)).width(this.cell.getWidth())).build());
        if (count == 0) {
            data.setSamePageCellPresent(false);
        }
        data.setSamePageCellHeight(this.cell.getVerticalPadding() + (count > 0 ? (float)count * lineHeight + (float)(count - 1) * lineHeight * this.lineSpacing : 0.0f));
    }

    private void updateNextPageCellData(List<String> lines, SplitCellData data, int count, float lineHeight) {
        String lastText = lines.subList(count, lines.size()).stream().collect(Collectors.joining(" "));
        data.setNextPageCell(((TextCell.TextCellBuilder)((AbstractCell.AbstractCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().settings(this.cell.getSettings())).colSpan(this.cell.getColSpan())).rowSpan(this.cell.getRowSpan())).text(lastText)).width(this.cell.getWidth())).build());
        if (count == lines.size()) {
            data.setNextPageCellPresent(false);
        }
        data.setNextPageCellHeight(this.cell.getVerticalPadding() + (lines.size() - count > 0 ? (float)(lines.size() - count) * lineHeight + (float)(lines.size() - count - 1) * lineHeight * this.lineSpacing : 0.0f));
    }

    TextCellDataSplitter(TextCell cell, float availableHeight, float lineSpacing) {
        this.cell = cell;
        this.availableHeight = availableHeight;
        this.lineSpacing = lineSpacing;
    }

    public static TextCellDataSplitterBuilder builder() {
        return new TextCellDataSplitterBuilder();
    }

    public static class TextCellDataSplitterBuilder {
        private TextCell cell;
        private float availableHeight;
        private float lineSpacing;

        TextCellDataSplitterBuilder() {
        }

        public TextCellDataSplitterBuilder cell(TextCell cell) {
            this.cell = cell;
            return this;
        }

        public TextCellDataSplitterBuilder availableHeight(float availableHeight) {
            this.availableHeight = availableHeight;
            return this;
        }

        public TextCellDataSplitterBuilder lineSpacing(float lineSpacing) {
            this.lineSpacing = lineSpacing;
            return this;
        }

        public TextCellDataSplitter build() {
            return new TextCellDataSplitter(this.cell, this.availableHeight, this.lineSpacing);
        }

        public String toString() {
            return "TextCellDataSplitter.TextCellDataSplitterBuilder(cell=" + this.cell + ", availableHeight=" + this.availableHeight + ", lineSpacing=" + this.lineSpacing + ")";
        }
    }
}

