/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.BaseFont;
import rst.pdfbox.layout.text.ControlCharacter;
import rst.pdfbox.layout.text.ControlCharacters;
import rst.pdfbox.layout.text.Indent;
import rst.pdfbox.layout.text.IndentCharacters;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.StyledText;
import rst.pdfbox.layout.text.TextFlow;
import rst.pdfbox.layout.text.annotations.AnnotatedStyledText;
import rst.pdfbox.layout.text.annotations.AnnotationCharacters;

public class TextFlowUtil {
    public static TextFlow createTextFlow(String text, float fontSize, PDFont font) throws IOException {
        Iterable<CharSequence> parts = TextFlowUtil.fromPlainText(text);
        return TextFlowUtil.createTextFlow(parts, fontSize, font, font, font, font);
    }

    public static TextFlow createTextFlowFromMarkup(String markup, float fontSize, BaseFont baseFont) throws IOException {
        return TextFlowUtil.createTextFlowFromMarkup(markup, fontSize, baseFont.getPlainFont(), baseFont.getBoldFont(), baseFont.getItalicFont(), baseFont.getBoldItalicFont());
    }

    public static TextFlow createTextFlowFromMarkup(String markup, float fontSize, PDFont plainFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) throws IOException {
        Iterable<CharSequence> parts = TextFlowUtil.fromMarkup(markup);
        return TextFlowUtil.createTextFlow(parts, fontSize, plainFont, boldFont, italicFont, boldItalicFont);
    }

    protected static TextFlow createTextFlow(Iterable<CharSequence> parts, float fontSize, PDFont plainFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) throws IOException {
        TextFlow result = new TextFlow();
        boolean bold = false;
        boolean italic = false;
        Color color = Color.black;
        ControlCharacters.MetricsControlCharacter metricsControl = null;
        HashMap annotationMap = new HashMap();
        Stack<IndentCharacters.IndentCharacter> indentStack = new Stack<IndentCharacters.IndentCharacter>();
        for (CharSequence fragment : parts) {
            StyledText styledText;
            if (fragment instanceof ControlCharacter) {
                if (fragment instanceof ControlCharacters.NewLineControlCharacter) {
                    result.add(new NewLine(fontSize));
                }
                if (fragment instanceof ControlCharacters.BoldControlCharacter) {
                    boolean bl = bold = !bold;
                }
                if (fragment instanceof ControlCharacters.ItalicControlCharacter) {
                    boolean bl = italic = !italic;
                }
                if (fragment instanceof ControlCharacters.ColorControlCharacter) {
                    color = ((ControlCharacters.ColorControlCharacter)fragment).getColor();
                }
                if (fragment instanceof AnnotationCharacters.AnnotationControlCharacter) {
                    AnnotationCharacters.AnnotationControlCharacter annotationControlCharacter = (AnnotationCharacters.AnnotationControlCharacter)fragment;
                    if (annotationMap.containsKey(annotationControlCharacter.getAnnotationType())) {
                        annotationMap.remove(annotationControlCharacter.getAnnotationType());
                    } else {
                        annotationMap.put(annotationControlCharacter.getAnnotationType(), annotationControlCharacter.getAnnotation());
                    }
                }
                if (fragment instanceof ControlCharacters.MetricsControlCharacter) {
                    metricsControl = metricsControl != null && metricsControl.toString().equals(fragment.toString()) ? null : (ControlCharacters.MetricsControlCharacter)fragment;
                }
                if (!(fragment instanceof IndentCharacters.IndentCharacter)) continue;
                IndentCharacters.IndentCharacter currentIndent = (IndentCharacters.IndentCharacter)fragment;
                if (currentIndent.getLevel() == 0) {
                    indentStack.clear();
                    result.add(Indent.UNINDENT);
                    continue;
                }
                IndentCharacters.IndentCharacter last = null;
                while (!indentStack.isEmpty() && indentStack.peek() != null && currentIndent.getLevel() <= ((IndentCharacters.IndentCharacter)indentStack.peek()).getLevel()) {
                    last = (IndentCharacters.IndentCharacter)indentStack.pop();
                }
                if (last != null && last.equals(currentIndent)) {
                    currentIndent = last;
                }
                indentStack.push(currentIndent);
                result.add(currentIndent.createNewIndent(fontSize, plainFont, color));
                continue;
            }
            PDFont font = TextFlowUtil.getFont(bold, italic, plainFont, boldFont, italicFont, boldItalicFont);
            float baselineOffset = 0.0f;
            float currentFontSize = fontSize;
            if (metricsControl != null) {
                baselineOffset = metricsControl.getBaselineOffsetScale() * fontSize;
                currentFontSize *= metricsControl.getFontScale();
            }
            if (annotationMap.isEmpty()) {
                styledText = new StyledText(fragment.toString(), currentFontSize, font, color, baselineOffset);
                result.add(styledText);
                continue;
            }
            styledText = new AnnotatedStyledText(fragment.toString(), currentFontSize, font, color, baselineOffset, annotationMap.values());
            result.add(styledText);
        }
        return result;
    }

    protected static PDFont getFont(boolean bold, boolean italic, PDFont plainFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) {
        PDFont font = plainFont;
        if (bold && !italic) {
            font = boldFont;
        } else if (!bold && italic) {
            font = italicFont;
        } else if (bold && italic) {
            font = boldItalicFont;
        }
        return font;
    }

    public static Iterable<CharSequence> fromPlainText(CharSequence text) {
        return TextFlowUtil.fromPlainText(Collections.singleton(text));
    }

    public static Iterable<CharSequence> fromPlainText(Iterable<CharSequence> text) {
        Iterable<CharSequence> result = TextFlowUtil.splitByControlCharacter(ControlCharacters.NEWLINE_FACTORY, text);
        result = TextFlowUtil.unescapeBackslash(result);
        return result;
    }

    public static Iterable<CharSequence> fromMarkup(CharSequence markup) {
        return TextFlowUtil.fromMarkup(Collections.singleton(markup));
    }

    public static Iterable<CharSequence> fromMarkup(Iterable<CharSequence> markup) {
        Iterable<CharSequence> text = markup;
        text = TextFlowUtil.splitByControlCharacter(ControlCharacters.NEWLINE_FACTORY, text);
        text = TextFlowUtil.splitByControlCharacter(ControlCharacters.METRICS_FACTORY, text);
        text = TextFlowUtil.splitByControlCharacter(ControlCharacters.BOLD_FACTORY, text);
        text = TextFlowUtil.splitByControlCharacter(ControlCharacters.ITALIC_FACTORY, text);
        text = TextFlowUtil.splitByControlCharacter(ControlCharacters.COLOR_FACTORY, text);
        for (AnnotationCharacters.AnnotationControlCharacterFactory<?> annotationControlCharacterFactory : AnnotationCharacters.getFactories()) {
            text = TextFlowUtil.splitByControlCharacter(annotationControlCharacterFactory, text);
        }
        text = TextFlowUtil.splitByControlCharacter(IndentCharacters.INDENT_FACTORY, text);
        text = TextFlowUtil.unescapeBackslash(text);
        return text;
    }

    protected static Iterable<CharSequence> splitByControlCharacter(ControlCharacters.ControlCharacterFactory controlCharacterFactory, Iterable<CharSequence> markup) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        boolean beginOfLine = true;
        for (CharSequence current : markup) {
            if (current instanceof String) {
                String string = (String)current;
                int begin = 0;
                if (!controlCharacterFactory.patternMatchesBeginOfLine() || beginOfLine) {
                    Matcher matcher = controlCharacterFactory.getPattern().matcher(string);
                    while (matcher.find()) {
                        String part = string.substring(begin, matcher.start());
                        begin = matcher.end();
                        if (!part.isEmpty()) {
                            String unescaped = controlCharacterFactory.unescape(part);
                            result.add(unescaped);
                        }
                        result.add(controlCharacterFactory.createControlCharacter(string, matcher, result));
                    }
                }
                if (begin < string.length()) {
                    String part = string.substring(begin);
                    String unescaped = controlCharacterFactory.unescape(part);
                    result.add(unescaped);
                }
                beginOfLine = false;
                continue;
            }
            if (current instanceof ControlCharacters.NewLineControlCharacter) {
                beginOfLine = true;
            }
            result.add(current);
        }
        return result;
    }

    private static Iterable<CharSequence> unescapeBackslash(Iterable<CharSequence> chars) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        for (CharSequence current : chars) {
            if (current instanceof String) {
                result.add(ControlCharacters.unescapeBackslash((String)current));
                continue;
            }
            result.add(current);
        }
        return result;
    }
}

