/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.client;

import com.amazonservices.mws.client.MwsObject;
import com.amazonservices.mws.client.MwsUtl;
import com.amazonservices.mws.client.MwsWriter;
import java.io.Writer;
import java.util.Collection;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MwsJsonWriter
implements MwsWriter {
    private static final String[] ESCAPE_SEQ = new String[]{"\\\"", "\\\\", "\\/", "\\b", "\\f", "\\n", "\\r", "\\t"};
    private static final String ESCAPED_CHARS = "\"\\/\b\f\n\r\t";
    private Writer writer;
    private int inObject;
    private boolean needComma;

    protected void append(String value, int start, int end) {
        try {
            this.writer.write(value, start, end - start);
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    protected void append(String value) {
        try {
            this.writer.write(value);
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    private void appendValue(Object value) {
        if (value == null) {
            this.append("null");
        } else if (value instanceof MwsObject) {
            this.append("{");
            this.needComma = false;
            ((MwsObject)value).writeFragmentTo(this);
            this.append("}");
        } else if (value instanceof Boolean || value instanceof Number) {
            this.append(value.toString());
        } else if (value instanceof String) {
            this.append("\"");
            this.escape((String)value);
            this.append("\"");
        } else if (value instanceof Node) {
            this.appendValue(MwsUtl.toXmlString((Node)value));
        } else if (value instanceof XMLGregorianCalendar) {
            this.append(((XMLGregorianCalendar)value).toXMLFormat());
        } else if (value instanceof Enum) {
            this.append(value.toString());
        } else {
            throw new IllegalArgumentException("Unsupported type " + value.getClass().getName());
        }
        this.needComma = true;
    }

    private void commaName(String name) {
        if (this.needComma) {
            this.append(",");
        }
        this.append("\"");
        this.escape(name);
        this.append("\":");
    }

    private void escape(String value) {
        int n = value.length();
        int i = 0;
        for (int j = 0; j < n; ++j) {
            char c = value.charAt(j);
            int k = ESCAPED_CHARS.indexOf(c);
            if (k < 0 && c >= ' ') continue;
            if (i < j) {
                this.append(value, i, j);
            }
            if (k >= 0) {
                this.append(ESCAPE_SEQ[k]);
            } else {
                this.append("\\u");
                this.append(String.format("%04x", c));
            }
            i = j + 1;
        }
        if (i < n) {
            this.append(value, i, n);
        }
    }

    @Override
    public void beginObject(String name) {
        if (this.inObject > 0) {
            this.commaName(name);
        }
        this.append("{");
        this.needComma = false;
        ++this.inObject;
    }

    @Override
    public void endObject(String name) {
        this.append("}");
        this.needComma = true;
        --this.inObject;
    }

    @Override
    public void write(String namespace, String name, MwsObject value) {
        if (value != null) {
            this.beginObject(name);
            this.writeAttribute("xmlns", namespace);
            value.writeFragmentTo(this);
            this.endObject(name);
        }
    }

    @Override
    public void write(String name, Object value) {
        if (value != null) {
            this.commaName(name);
            this.appendValue(value);
        }
    }

    @Override
    public void writeAttribute(String name, Object value) {
        this.write(name, value);
    }

    @Override
    public void writeValue(Object value) {
        this.write("Value", value);
    }

    public MwsJsonWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void close() {
        MwsUtl.close(this.writer);
    }

    @Override
    public void writeList(String name, Collection<?> list) {
        if (list == null) {
            return;
        }
        this.commaName(name);
        this.append("[");
        this.needComma = false;
        for (Object value : list) {
            if (this.needComma) {
                this.append(",");
            }
            this.appendValue(value);
        }
        this.append("]");
        this.needComma = true;
    }

    @Override
    public void writeList(String name, String memberName, Collection<?> list) {
        this.writeList(name, list);
    }

    @Override
    public void writeAny(Collection<Element> elements) {
        if (elements != null) {
            for (Element element : elements) {
                String name = element.getLocalName();
                if (name == null) {
                    name = element.getTagName();
                }
                this.write(name, element);
            }
        }
    }
}

