/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.client;

import com.amazonservices.mws.client.MwsObject;
import com.amazonservices.mws.client.MwsReader;
import com.amazonservices.mws.client.MwsUtl;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class MwsXmlReader
implements MwsReader {
    private final InputStream is;
    private final Document document;
    private Element currentElement;
    private Node currentChild;

    private Element getChildElement(String name) {
        if (this.currentChild == null) {
            return null;
        }
        Node start = this.currentChild;
        do {
            Node node = this.currentChild;
            this.currentChild = this.currentChild.getNextSibling();
            if (this.currentChild == null) {
                this.currentChild = this.currentElement.getFirstChild();
            }
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
            return (Element)node;
        } while (this.currentChild != start);
        return null;
    }

    private String getElementText(Element element) {
        Node node = element.getFirstChild();
        if (node == null || node.getNodeType() != 3) {
            return null;
        }
        return node.getNodeValue().trim();
    }

    private <T> T parseElement(Element element, Class<T> cls) {
        Element value;
        if (element == null) {
            value = null;
        } else if (MwsObject.class.isAssignableFrom(cls)) {
            value = (Element)MwsUtl.newInstance(cls);
            Element holdElement = this.currentElement;
            Node holdChild = this.currentChild;
            this.setCurrentElement(element);
            ((MwsObject)((Object)value)).readFragmentFrom(this);
            this.currentElement = holdElement;
            this.currentChild = holdChild;
        } else if (cls == Object.class) {
            value = element;
        } else {
            String v = this.getElementText(element);
            value = this.parseString(v, cls);
        }
        return (T)value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseString(String v, Class<T> cls) {
        Object value;
        if (v == null || v.length() == 0) {
            value = null;
            return (T)value;
        } else if (cls == String.class) {
            value = v;
            return (T)value;
        } else if (cls == Boolean.class || cls == Boolean.TYPE) {
            if (v.equalsIgnoreCase("true")) {
                value = Boolean.TRUE;
                return (T)value;
            } else {
                if (!v.equalsIgnoreCase("false")) throw new IllegalStateException("Expected true/false, found text '" + v + "'.");
                value = Boolean.FALSE;
            }
            return (T)value;
        } else if (cls == Integer.class || cls == Integer.TYPE) {
            value = Integer.valueOf(v);
            return (T)value;
        } else if (cls == Long.class || cls == Long.TYPE) {
            value = Long.valueOf(v);
            return (T)value;
        } else if (cls == Float.class || cls == Float.TYPE) {
            value = Float.valueOf(v);
            return (T)value;
        } else if (cls == Double.class || cls == Double.TYPE) {
            value = Double.valueOf(v);
            return (T)value;
        } else if (cls == BigDecimal.class) {
            value = new BigDecimal(v);
            return (T)value;
        } else if (XMLGregorianCalendar.class == cls) {
            value = MwsUtl.getDTF().newXMLGregorianCalendar(v);
            return (T)value;
        } else {
            if (!Enum.class.isAssignableFrom(cls)) throw new IllegalArgumentException(String.format("Unable to parse String %s to Class %s", v, cls));
            value = MwsUtl.getEnumValue(cls, v);
        }
        return (T)value;
    }

    private void setCurrentElement(Element element) {
        this.currentElement = element;
        this.currentChild = element.getFirstChild();
    }

    @Override
    public void close() {
        MwsUtl.close(this.is);
    }

    @Override
    public <T> T read(String name, Class<T> cls) {
        Element element = this.getChildElement(name);
        T value = this.parseElement(element, cls);
        return value;
    }

    @Override
    public <T> T readAttribute(String name, Class<T> cls) {
        return this.parseString(this.currentElement.getAttribute(name), cls);
    }

    @Override
    public <T> List<T> readList(String memberName, Class<T> cls) {
        ArrayList<T> list = new ArrayList<T>();
        for (Node node = this.currentElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals(memberName)) continue;
            T value = this.parseElement((Element)node, cls);
            list.add(value);
            this.currentChild = node;
        }
        return list;
    }

    @Override
    public <T> List<T> readList(String name, String memberName, Class<T> cls) {
        ArrayList<T> list = new ArrayList<T>();
        for (Node node = this.currentElement.getFirstChild(); node != null && list.isEmpty(); node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
            if (node.hasChildNodes()) {
                for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(memberName)) continue;
                    T value = this.parseElement((Element)childNode, cls);
                    list.add(value);
                }
            }
            this.currentChild = node;
        }
        return list;
    }

    @Override
    public List<Element> readAny() {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Node node = this.currentElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            list.add((Element)node);
        }
        return list;
    }

    @Override
    public <T> T readValue(Class<T> cls) {
        return this.parseElement(this.currentElement, cls);
    }

    public MwsXmlReader(InputStream is) {
        try {
            this.is = is;
            DocumentBuilder docBuilder = MwsUtl.getDBF().newDocumentBuilder();
            this.document = docBuilder.parse(is);
            Element root = this.document.getDocumentElement();
            root.normalize();
            this.setCurrentElement(root);
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    public MwsXmlReader(String xml) {
        try {
            this.is = null;
            InputSource src = new InputSource(new StringReader(xml));
            DocumentBuilder docBuilder = MwsUtl.getDBF().newDocumentBuilder();
            this.document = docBuilder.parse(src);
            Element root = this.document.getDocumentElement();
            root.normalize();
            this.setCurrentElement(root);
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }
}

