/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.client;

import com.amazonservices.mws.client.MwsObject;
import com.amazonservices.mws.client.MwsUtl;
import com.amazonservices.mws.client.MwsWriter;
import java.io.Writer;
import java.util.Collection;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MwsXmlWriter
implements MwsWriter {
    private static final String[] ESCAPE_SEQ = new String[]{"&amp;", "&lt;", "&gt;", "&#039;", "&quot;"};
    private static final String ESCAPED_CHARS = "&<>'\"";
    protected Writer writer;
    private boolean inTag;

    private void appendValue(Object value) {
        if (value instanceof Boolean) {
            this.closeTag();
            this.append(value.toString());
        } else if (value instanceof Number) {
            this.closeTag();
            this.append(value.toString());
        } else if (value instanceof String) {
            this.closeTag();
            this.escape((String)value);
        } else if (value instanceof MwsObject) {
            ((MwsObject)value).writeFragmentTo(this);
        } else if (value instanceof Node) {
            this.closeTag();
            this.append(MwsUtl.toXmlString((Node)value));
        } else if (value instanceof Enum) {
            this.closeTag();
            this.append(((Enum)value).toString());
        } else if (value instanceof XMLGregorianCalendar) {
            this.closeTag();
            this.append(((XMLGregorianCalendar)value).toXMLFormat());
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void beginTag(String name) {
        this.closeTag();
        this.append("<");
        this.append(name);
        this.inTag = true;
    }

    private void closeTag() {
        if (this.inTag) {
            this.append(">");
            this.inTag = false;
        }
    }

    private void endTag(String name) {
        this.closeTag();
        this.append("</");
        this.append(name);
        this.append(">");
    }

    private void escape(String value) {
        int n = value.length();
        int i = 0;
        for (int j = 0; j < n; ++j) {
            int k = ESCAPED_CHARS.indexOf(value.charAt(j));
            if (k < 0) continue;
            if (i < j) {
                this.append(value, i, j);
            }
            this.append(ESCAPE_SEQ[k]);
            i = j + 1;
        }
        if (i < n) {
            this.append(value, i, n);
        }
    }

    protected void append(String v) {
        try {
            this.writer.write(v);
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    protected void append(String v, int start, int end) {
        try {
            this.writer.write(v, start, end - start);
        }
        catch (Exception e) {
            throw MwsUtl.wrap(e);
        }
    }

    @Override
    public void beginObject(String name) {
        this.beginTag(name);
    }

    @Override
    public void close() {
        MwsUtl.close(this.writer);
    }

    @Override
    public void endObject(String name) {
        this.endTag(name);
    }

    @Override
    public void write(String namespace, String name, MwsObject value) {
        if (value != null) {
            this.beginObject(name);
            this.writeAttribute("xmlns", namespace);
            value.writeFragmentTo(this);
            this.endObject(name);
        }
    }

    @Override
    public void write(String name, Object value) {
        if (value == null) {
            return;
        }
        this.beginTag(name);
        this.appendValue(value);
        this.endTag(name);
    }

    @Override
    public void writeAttribute(String name, Object value) {
        if (!this.inTag) {
            throw new IllegalStateException();
        }
        if (value == null) {
            return;
        }
        this.append(" ");
        this.append(name);
        this.append("=\"");
        this.escape(String.valueOf(value));
        this.append("\"");
    }

    @Override
    public void writeList(String name, Collection<?> list) {
        if (list != null) {
            for (Object v : list) {
                this.write(name, v);
            }
        }
    }

    @Override
    public void writeList(String name, String memberName, Collection<?> list) {
        if (list != null && list.size() > 0) {
            this.beginObject(name);
            for (Object v : list) {
                this.write(memberName, v);
            }
            this.endObject(name);
        }
    }

    @Override
    public void writeAny(Collection<Element> elements) {
        for (Element element : elements) {
            this.appendValue(element);
        }
    }

    @Override
    public void writeValue(Object value) {
        this.closeTag();
        if (value != null) {
            this.appendValue(value);
        }
    }

    public MwsXmlWriter(Writer writer) {
        this.writer = writer;
    }
}

