/*
 * Decompiled with CFR 0.152.
 */
package com.amazonservices.mws.orders._2013_09_01;

import com.amazonservices.mws.client.MwsConnection;
import com.amazonservices.mws.client.MwsException;
import com.amazonservices.mws.client.MwsObject;
import com.amazonservices.mws.client.MwsRequestType;
import com.amazonservices.mws.client.MwsResponseHeaderMetadata;
import com.amazonservices.mws.client.MwsUtl;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrders;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersConfig;
import com.amazonservices.mws.orders._2013_09_01.MarketplaceWebServiceOrdersException;
import com.amazonservices.mws.orders._2013_09_01.model.GetOrderRequest;
import com.amazonservices.mws.orders._2013_09_01.model.GetOrderResponse;
import com.amazonservices.mws.orders._2013_09_01.model.GetServiceStatusRequest;
import com.amazonservices.mws.orders._2013_09_01.model.GetServiceStatusResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsByNextTokenRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsByNextTokenResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrderItemsResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersByNextTokenRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersByNextTokenResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersRequest;
import com.amazonservices.mws.orders._2013_09_01.model.ListOrdersResponse;
import com.amazonservices.mws.orders._2013_09_01.model.MWSResponse;
import com.amazonservices.mws.orders._2013_09_01.model.ResponseHeaderMetadata;

public class MarketplaceWebServiceOrdersClient
implements MarketplaceWebServiceOrders {
    private static final String libraryName = "MarketplaceWebServiceOrders";
    private static final String libraryVersion = "2013-09-01";
    protected String servicePath;
    protected final MwsConnection connection;

    public MarketplaceWebServiceOrdersClient(String accessKey, String secretKey, String applicationName, String applicationVersion, MarketplaceWebServiceOrdersConfig config) {
        this.connection = config.copyConnection();
        this.connection.setAwsAccessKeyId(accessKey);
        this.connection.setAwsSecretKeyId(secretKey);
        this.connection.setApplicationName(applicationName);
        this.connection.setApplicationVersion(applicationVersion);
        this.connection.setLibraryVersion(libraryVersion);
        this.servicePath = config.getServicePath();
    }

    public MarketplaceWebServiceOrdersClient(String accessKey, String secretKey, MarketplaceWebServiceOrdersConfig config) {
        this(accessKey, secretKey, libraryName, libraryVersion, config);
    }

    public MarketplaceWebServiceOrdersClient(String accessKey, String secretKey, String applicationName, String applicationVersion) {
        this(accessKey, secretKey, applicationName, applicationVersion, new MarketplaceWebServiceOrdersConfig());
    }

    @Override
    public GetOrderResponse getOrder(GetOrderRequest request) {
        return (GetOrderResponse)this.connection.call(new RequestType("GetOrder", GetOrderResponse.class, this.servicePath), request);
    }

    @Override
    public GetServiceStatusResponse getServiceStatus(GetServiceStatusRequest request) {
        return (GetServiceStatusResponse)this.connection.call(new RequestType("GetServiceStatus", GetServiceStatusResponse.class, this.servicePath), request);
    }

    @Override
    public ListOrderItemsResponse listOrderItems(ListOrderItemsRequest request) {
        return (ListOrderItemsResponse)this.connection.call(new RequestType("ListOrderItems", ListOrderItemsResponse.class, this.servicePath), request);
    }

    @Override
    public ListOrderItemsByNextTokenResponse listOrderItemsByNextToken(ListOrderItemsByNextTokenRequest request) {
        return (ListOrderItemsByNextTokenResponse)this.connection.call(new RequestType("ListOrderItemsByNextToken", ListOrderItemsByNextTokenResponse.class, this.servicePath), request);
    }

    @Override
    public ListOrdersResponse listOrders(ListOrdersRequest request) {
        return (ListOrdersResponse)this.connection.call(new RequestType("ListOrders", ListOrdersResponse.class, this.servicePath), request);
    }

    @Override
    public ListOrdersByNextTokenResponse listOrdersByNextToken(ListOrdersByNextTokenRequest request) {
        return (ListOrdersByNextTokenResponse)this.connection.call(new RequestType("ListOrdersByNextToken", ListOrdersByNextTokenResponse.class, this.servicePath), request);
    }

    public static String quoteAppName(String s) {
        return MwsUtl.escapeAppName(s);
    }

    public static String quoteAppVersion(String s) {
        return MwsUtl.escapeAppVersion(s);
    }

    public static String quoteAttributeName(String s) {
        return MwsUtl.escapeAttributeName(s);
    }

    public static String quoteAttributeValue(String s) {
        return MwsUtl.escapeAttributeValue(s);
    }

    protected static class RequestType
    implements MwsRequestType {
        private final String operationName;
        private final Class<? extends MWSResponse> responseClass;
        private final String servicePath;

        public RequestType(String operationName, Class<? extends MWSResponse> responseClass, String servicePath) {
            this.operationName = operationName;
            this.responseClass = responseClass;
            this.servicePath = servicePath;
        }

        @Override
        public String getServicePath() {
            return this.servicePath;
        }

        @Override
        public String getOperationName() {
            return this.operationName;
        }

        @Override
        public Class<? extends MwsObject> getResponseClass() {
            return this.responseClass;
        }

        @Override
        public MwsException wrapException(Throwable cause) {
            return new MarketplaceWebServiceOrdersException(cause);
        }

        @Override
        public void setRHMD(MwsObject response, MwsResponseHeaderMetadata rhmd) {
            ((MWSResponse)response).setResponseHeaderMetadata(new ResponseHeaderMetadata(rhmd));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.operationName == null ? 0 : this.operationName.hashCode());
            result = 31 * result + (this.responseClass == null ? 0 : this.responseClass.hashCode());
            result = 31 * result + (this.servicePath == null ? 0 : this.servicePath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequestType other = (RequestType)obj;
            if (this.operationName == null ? other.operationName != null : !this.operationName.equals(other.operationName)) {
                return false;
            }
            if (this.responseClass == null ? other.responseClass != null : !this.responseClass.equals(other.responseClass)) {
                return false;
            }
            return !(this.servicePath == null ? other.servicePath != null : !this.servicePath.equals(other.servicePath));
        }
    }
}

