/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing.ejbql;

import oracle.toplink.essentials.internal.queryframework.*;
import oracle.toplink.essentials.exceptions.*;
import oracle.toplink.essentials.queryframework.*;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

/**
 * INTERNAL
 * <p><b>Purpose</b>:
 * Mechanism used for EJBQL.
 * <p>
 * <p><b>Responsibilities</b>:
 * Executes the appropriate call.
 *
 * @author Jon Driscoll, Joel Lucuik
 * @since TopLink 4.0
 */
public class EJBQLCallQueryMechanism extends ExpressionQueryMechanism {
    //EJBQLCall gets its own variable, rather than inheriting
    //call (because an EJBQLCall is out on its own)
    protected EJBQLCall ejbqlCall;

    /**
     * Initialize the state of the query
     * @param query - owner of mechanism
     */
    public EJBQLCallQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    /**
     * INTERNAL
     * Initialize the state of the query
     * @param query - owner of mechanism
     * @param call - Database call
     */
    public EJBQLCallQueryMechanism(DatabaseQuery query, EJBQLCall call) {
        this(query);
        this.ejbqlCall = call;
        call.setQuery(query);
    }

    public Object clone() {
        EJBQLCallQueryMechanism copyOfMyself = (EJBQLCallQueryMechanism)super.clone();
        copyOfMyself.ejbqlCall = (EJBQLCall)ejbqlCall.clone();
        return copyOfMyself;

    }

    /**
     * Internal:
     * In the case of EJBQL, an expression needs to be generated, and the query populated.
     */
    public void buildSelectionCriteria(AbstractSession newSession) {
        getEJBQLCall().setQuery(getQuery());
        getEJBQLCall().populateQuery(newSession);
    }

    public EJBQLCall getEJBQLCall() {
        return ejbqlCall;
    }

    public boolean isEJBQLCallQueryMechanism() {
        return true;
    }

    /**
     * All the query mechanism related things are initialized here.
     * This method is called on the *clone* of the query with
     * every execution.
     */
    public void prepareForExecution() throws QueryException {
    }

    public void setEJBQLCall(EJBQLCall newEJBQLCall) {
        ejbqlCall = newEJBQLCall;
    }
}
