/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.ejb.cmp3.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.toplink.essentials.ejb.cmp3.persistence.Archive;
import oracle.toplink.essentials.ejb.cmp3.persistence.DirectoryArchive;
import oracle.toplink.essentials.ejb.cmp3.persistence.DirectoryInsideJarURLArchive;
import oracle.toplink.essentials.ejb.cmp3.persistence.JarFileArchive;
import oracle.toplink.essentials.ejb.cmp3.persistence.JarInputStreamURLArchive;
import oracle.toplink.essentials.ejb.cmp3.persistence.URLArchive;

public class ArchiveFactoryImpl {
    private Logger logger;

    public ArchiveFactoryImpl() {
        this(Logger.global);
    }

    public ArchiveFactoryImpl(Logger logger) {
        this.logger = logger;
    }

    public Archive createArchive(URL url) throws URISyntaxException, IOException {
        JarURLConnection conn;
        JarEntry je;
        File f;
        this.logger.entering("ArchiveFactoryImpl", "createArchive", new Object[]{url});
        String protocol = url.getProtocol();
        this.logger.logp(Level.FINER, "ArchiveFactoryImpl", "createArchive", "protocol = {0}", protocol);
        Archive result = "file".equals(protocol) ? ((f = new File(url.toURI())).isDirectory() ? new DirectoryArchive(f) : new JarFileArchive(new JarFile(f))) : ("jar".equals(protocol) ? ((je = (conn = (JarURLConnection)JarURLConnection.class.cast(url.openConnection())).getJarEntry()) == null ? new JarFileArchive(conn.getJarFile()) : (je.isDirectory() ? new DirectoryInsideJarURLArchive(url) : new JarInputStreamURLArchive(url))) : (this.isJarInputStream(url) ? new JarInputStreamURLArchive(url) : new URLArchive(url)));
        this.logger.exiting("ArchiveFactoryImpl", "createArchive", result);
        return result;
    }

    private boolean isJarInputStream(URL url) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            if (in == null) {
                return false;
            }
            JarInputStream jis = new JarInputStream(in);
            jis.close();
            return true;
        }
        catch (IOException ioe) {
            if (in != null) {
                in.close();
            }
            return false;
        }
    }
}

