/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.base;

import java.util.Enumeration;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;

public class RepeatableWriteUnitOfWork
extends UnitOfWorkImpl {
    protected UnitOfWorkChangeSet cumulativeUOWChangeSet;
    protected IdentityHashtable unregisteredDeletedObjectsCloneToBackupAndOriginal;
    protected boolean shouldTerminateTransaction = true;
    protected boolean shouldClearForCloseInsteadOfResume = false;

    public RepeatableWriteUnitOfWork(AbstractSession parentSession) {
        super(parentSession);
    }

    public void clearForClose(boolean shouldClearCache) {
        super.clearForClose(shouldClearCache);
        this.cumulativeUOWChangeSet = null;
        this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
    }

    public boolean shouldClearForCloseOnRelease() {
        return true;
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithChangeSet(false);
        if (this.cumulativeUOWChangeSet != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
        this.mergeChangesIntoParent();
    }

    public void discoverUnregisteredNewObjects(Object clone, IdentityHashtable knownNewObjects, IdentityHashtable unregisteredExistingObjects, IdentityHashtable visitedObjects) {
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (RepeatableWriteUnitOfWork.this.isClassReadOnly(object.getClass()) || RepeatableWriteUnitOfWork.this.isObjectDeleted(object)) {
                    this.setShouldBreak(true);
                    return;
                }
                if (this.getCurrentMapping() != null && ((ForeignReferenceMapping)this.getCurrentMapping()).isCascadePersist()) {
                    ((RepeatableWriteUnitOfWork)this.getSession()).registerNewObjectForPersist(object, new IdentityHashtable());
                } else if (!RepeatableWriteUnitOfWork.this.getCloneMapping().containsKey(object)) {
                    if (!RepeatableWriteUnitOfWork.this.checkForUnregisteredExistingObject(object)) {
                        throw new IllegalStateException(ExceptionLocalization.buildMessage("new_object_found_during_commit", new Object[]{object}));
                    }
                    RepeatableWriteUnitOfWork.this.getUnregisteredExistingObjects().put(object, object);
                    this.setShouldBreak(true);
                    return;
                }
            }
        };
        this.setUnregisteredExistingObjects(unregisteredExistingObjects);
        iterator.setVisitedObjects(visitedObjects);
        iterator.setResult(knownNewObjects);
        iterator.setSession(this);
        iterator.setShouldIterateOverWrappedObjects(false);
        iterator.startIterationOn(clone);
    }

    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.getLifecycle() == 2;
    }

    public boolean isObjectDeleted(Object object) {
        if (super.isObjectDeleted(object)) {
            return true;
        }
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && this.unregisteredDeletedObjectsCloneToBackupAndOriginal.containsKey(object)) {
            return true;
        }
        if (this.hasObjectsDeletedDuringCommit()) {
            return this.getObjectsDeletedDuringCommit().containsKey(object);
        }
        return false;
    }

    public void issueSQLbeforeCompletion() {
        super.issueSQLbeforeCompletion(false);
        if (this.cumulativeUOWChangeSet != null && this.getUnitOfWorkChangeSet() != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
    }

    public void updateChangeTrackersIfRequired(Object objectToWrite, ObjectChangeSet changeSetToWrite, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        descriptor.getObjectChangePolicy().updateWithChanges(objectToWrite, changeSetToWrite, uow, descriptor);
    }

    public void writeChanges() {
        Object object;
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal == null) {
            this.unregisteredDeletedObjectsCloneToBackupAndOriginal = new IdentityHashtable(2);
        }
        IdentityHashtable allObjectsList = new IdentityHashtable();
        IdentityHashtable visitedNodes = new IdentityHashtable(2);
        IdentityHashtable newObjects = new IdentityHashtable(2);
        IdentityHashtable existingObjects = new IdentityHashtable(2);
        IdentityHashtable insertedNewObjects = new IdentityHashtable(2);
        Enumeration clones = this.getCloneMapping().keys();
        while (clones.hasMoreElements()) {
            object = clones.nextElement();
            this.discoverUnregisteredNewObjects(object, newObjects, existingObjects, visitedNodes);
            allObjectsList.put(object, object);
        }
        Enumeration newClones = this.getNewObjectsCloneToOriginal().keys();
        while (newClones.hasMoreElements()) {
            object = newClones.nextElement();
            this.assignSequenceNumber(object);
            insertedNewObjects.put(object, object);
            allObjectsList.put(object, object);
        }
        if (this.getUnitOfWorkChangeSet() == null) {
            this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
        }
        this.calculateChanges(allObjectsList, (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
        UnitOfWorkChangeSet changeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (!(changeSet.hasChanges() || changeSet.hasForcedChanges() || this.hasDeletedObjects() || this.hasModifyAllQueries())) {
            return;
        }
        try {
            this.commitToDatabaseWithPreBuiltChangeSet(changeSet, false);
            this.writesCompleted();
        }
        catch (RuntimeException ex) {
            this.setLifecycle(3);
            throw ex;
        }
        this.getDeletedObjects().clear();
        Enumeration enumDeleted = this.getObjectsDeletedDuringCommit().keys();
        while (enumDeleted.hasMoreElements()) {
            Object deletedObject = enumDeleted.nextElement();
            Object[] backupAndOriginal = new Object[]{this.getCloneMapping().get(deletedObject), this.getCloneToOriginals().get(deletedObject)};
            this.unregisteredDeletedObjectsCloneToBackupAndOriginal.put(deletedObject, backupAndOriginal);
            this.unregisterObject(deletedObject);
        }
        this.getObjectsDeletedDuringCommit().clear();
        if (this.cumulativeUOWChangeSet == null) {
            this.cumulativeUOWChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        } else {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
        }
        this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet());
        Enumeration enumtr = insertedNewObjects.elements();
        while (enumtr.hasMoreElements()) {
            Object clone = enumtr.nextElement();
            Object original = this.getNewObjectsCloneToOriginal().remove(clone);
            if (original == null) continue;
            this.getNewObjectsOriginalToClone().remove(original);
            this.getCloneToOriginals().put(clone, original);
        }
    }

    protected void registerNotRegisteredNewObjectForPersist(Object newObject, ClassDescriptor descriptor) {
        Object[] backupAndOriginal;
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && (backupAndOriginal = (Object[])this.unregisteredDeletedObjectsCloneToBackupAndOriginal.remove(newObject)) != null) {
            this.getCloneMapping().put(newObject, backupAndOriginal[0]);
            this.registerNewObjectClone(newObject, backupAndOriginal[1]);
            this.registerNewObjectInIdentityMap(newObject, newObject);
            return;
        }
        super.registerNotRegisteredNewObjectForPersist(newObject, descriptor);
    }

    public void rollbackTransaction() throws DatabaseException {
        if (this.shouldTerminateTransaction || this.getParent().getTransactionMutex().isNested()) {
            super.rollbackTransaction();
        } else {
            this.setWasTransactionBegunPrematurely(true);
        }
    }

    public void synchronizeAndResume() {
        if (this.shouldClearForCloseInsteadOfResume()) {
            this.clearForClose(false);
        } else {
            this.cumulativeUOWChangeSet = null;
            this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
            super.synchronizeAndResume();
        }
    }

    public Object getUnregisteredDeletedCloneForOriginal(Object original) {
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null) {
            Enumeration keys = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.keys();
            Enumeration values = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.elements();
            while (keys.hasMoreElements()) {
                Object deletedObjectClone = keys.nextElement();
                Object[] backupAndOriginal = (Object[])values.nextElement();
                Object currentOriginal = backupAndOriginal[1];
                if (original != currentOriginal) continue;
                return deletedObjectClone;
            }
        }
        return null;
    }

    protected void commitToDatabase(boolean commitTransaction) {
        try {
            super.commitToDatabase(commitTransaction);
        }
        catch (OptimisticLockException ole) {
            throw new javax.persistence.OptimisticLockException(ole);
        }
    }

    public void commitTransaction() throws DatabaseException {
        if (this.shouldTerminateTransaction || this.getParent().getTransactionMutex().isNested()) {
            super.commitTransaction();
        }
    }

    public void setShouldTerminateTransaction(boolean shouldTerminateTransaction) {
        this.shouldTerminateTransaction = shouldTerminateTransaction;
    }

    public void setShouldClearForCloseInsteadOfResume(boolean shouldClearForCloseInsteadOfResume) {
        this.shouldClearForCloseInsteadOfResume = shouldClearForCloseInsteadOfResume;
    }

    public boolean shouldClearForCloseInsteadOfResume() {
        return this.shouldClearForCloseInsteadOfResume;
    }
}

