/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.Transient;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.BasicAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.EmbeddedAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.EmbeddedIdAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ManyToManyAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ManyToOneAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MappedSuperclassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.NonRelationshipAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.OneToManyAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.OneToOneAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataClass;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataField;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataMethod;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataDiscriminatorColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.listeners.MetadataEntityClassListener;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.listeners.MetadataEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataEntityResult;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataFieldResult;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataNamedNativeQuery;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataNamedQuery;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataSQLResultSetMapping;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataSecondaryTable;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataTable;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLMappedSuperclassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.listeners.XMLEntityListener;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.queryframework.ColumnResult;
import oracle.toplink.essentials.queryframework.EntityResult;
import oracle.toplink.essentials.queryframework.FieldResult;
import oracle.toplink.essentials.queryframework.SQLResultSetMapping;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAccessor
extends NonRelationshipAccessor {
    protected Class m_inheritanceParentClass;
    protected Boolean m_isInheritanceSubclass;
    protected List<ClassAccessor> m_mappedSuperclasses;

    public ClassAccessor(MetadataAccessibleObject accessibleObject, MetadataProcessor processor, MetadataDescriptor descriptor) {
        super(accessibleObject, processor, descriptor);
    }

    protected void addMultipleTableKeyFields(MetadataPrimaryKeyJoinColumns primaryKeyJoinColumns, String PK_CTX, String FK_CTX) {
        for (MetadataPrimaryKeyJoinColumn primaryKeyJoinColumn : this.processPrimaryKeyJoinColumns(primaryKeyJoinColumns)) {
            String defaultPKFieldName = this.m_descriptor.getPrimaryKeyFieldName();
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX));
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, pkField.getName(), FK_CTX));
            if (fkField.getName().equals(pkField.getName())) {
                this.m_descriptor.addMultipleTablePrimaryKeyField(pkField, fkField);
                continue;
            }
            this.m_descriptor.addMultipleTableForeignKeyField(pkField, fkField);
        }
    }

    protected MetadataAccessor buildAccessor(MetadataAccessibleObject accessibleObject) {
        MetadataAccessor accessor = this.m_descriptor.getAccessorFor(accessibleObject.getAttributeName());
        if (accessor == null) {
            if (MetadataHelper.isBasic(accessibleObject, this.m_descriptor)) {
                return new BasicAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isEmbedded(accessibleObject, this.m_descriptor)) {
                return new EmbeddedAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isEmbeddedId(accessibleObject, this.m_descriptor)) {
                return new EmbeddedIdAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isManyToMany(accessibleObject, this.m_descriptor)) {
                return new ManyToManyAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isManyToOne(accessibleObject, this.m_descriptor)) {
                return new ManyToOneAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isOneToMany(accessibleObject, this.m_logger, this.m_descriptor)) {
                return new OneToManyAccessor(accessibleObject, this);
            }
            if (MetadataHelper.isOneToOne(accessibleObject, this.m_project, this.m_logger, this.m_descriptor)) {
                return new OneToOneAccessor(accessibleObject, this);
            }
            return new BasicAccessor(accessibleObject, this);
        }
        return accessor;
    }

    public void clearMappedSuperclasses() {
        this.m_mappedSuperclasses = null;
    }

    protected String getDiscriminatorValue() {
        DiscriminatorValue discriminatorValue = (DiscriminatorValue)this.getAnnotation(DiscriminatorValue.class);
        if (discriminatorValue == null) {
            return null;
        }
        return discriminatorValue.value();
    }

    protected String getEntityName() {
        Entity entity = (Entity)this.getAnnotation(Entity.class);
        return entity == null ? "" : entity.name();
    }

    public Class getInheritanceParentClass() {
        if (this.m_inheritanceParentClass == null) {
            Class lastParent = null;
            for (Class parent = this.getJavaClass().getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
                if (!this.hasInheritance(parent) && !this.m_project.containsDescriptor(parent)) continue;
                if (lastParent == null) {
                    this.m_descriptor.setParentClass(parent);
                }
                lastParent = parent;
                if (this.hasInheritance(parent)) break;
            }
            this.m_inheritanceParentClass = lastParent;
        }
        return this.m_inheritanceParentClass;
    }

    public MetadataDescriptor getInheritanceParentDescriptor() {
        return this.m_project.getDescriptor(this.getInheritanceParentClass());
    }

    protected String getInheritanceStrategy() {
        Inheritance inheritance = (Inheritance)this.getAnnotation(Inheritance.class);
        if (inheritance == null) {
            return "";
        }
        return inheritance.strategy().name();
    }

    @Override
    public Class getJavaClass() {
        return (Class)this.getAnnotatedElement();
    }

    public List<ClassAccessor> getMappedSuperclasses() {
        if (this.m_mappedSuperclasses == null) {
            this.m_mappedSuperclasses = new ArrayList<ClassAccessor>();
            for (Class parent = this.getJavaClass().getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
                if (this.m_project.hasMappedSuperclass(parent)) {
                    Node node = this.m_project.getMappedSuperclassNode(parent);
                    XMLHelper helper = this.m_project.getMappedSuperclassHelper(parent);
                    this.m_mappedSuperclasses.add(new XMLMappedSuperclassAccessor(new MetadataClass(parent), node, helper, this.m_processor, this.m_descriptor));
                    continue;
                }
                if (!this.isAnnotationPresent(MappedSuperclass.class, parent)) continue;
                this.m_mappedSuperclasses.add(new MappedSuperclassAccessor(new MetadataClass(parent), this.m_processor, this.m_descriptor));
            }
        }
        return this.m_mappedSuperclasses;
    }

    protected boolean hasEntity(Class cls) {
        return this.isAnnotationPresent(Entity.class, cls);
    }

    protected boolean hasInheritance() {
        return this.hasInheritance(this.getJavaClass());
    }

    protected boolean hasInheritance(Class entityClass) {
        return this.isAnnotationPresent(Inheritance.class, entityClass);
    }

    @Override
    public boolean isClass() {
        return true;
    }

    public boolean isInheritanceSubclass() {
        if (this.m_isInheritanceSubclass == null) {
            this.m_isInheritanceSubclass = new Boolean(this.getInheritanceParentClass() != null);
        }
        return this.m_isInheritanceSubclass;
    }

    protected boolean isTransient(AnnotatedElement annotatedElement, int modifier) {
        if (this.isAnnotationPresent(Transient.class, annotatedElement)) {
            if (MetadataHelper.getDeclaredAnnotationsCount(annotatedElement, this.m_descriptor) > 1) {
                this.m_validator.throwMappingAnnotationsAppliedToTransientAttribute(annotatedElement);
            }
            return true;
        }
        if (Modifier.isTransient(modifier)) {
            if (MetadataHelper.getDeclaredAnnotationsCount(annotatedElement, this.m_descriptor) > 0) {
                this.m_validator.throwMappingAnnotationsAppliedToTransientAttribute(annotatedElement);
            }
            return true;
        }
        return false;
    }

    protected boolean isValidPersistenceElement(AnnotatedElement annotatedElement, int modifiers) {
        return !this.isTransient(annotatedElement, modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    protected boolean isValidPersistenceField(Field field) {
        return this.isValidPersistenceElement(field, field.getModifiers());
    }

    protected boolean isValidPersistenceMethod(Method method) {
        String methodName;
        if (this.isValidPersistenceElement(method, method.getModifiers()) && MetadataHelper.isValidPersistenceMethodName(methodName = method.getName())) {
            if (method.getParameterTypes().length > 0) {
                return false;
            }
            Method setMethod = MetadataHelper.getSetMethod(method, this.getJavaClass());
            if (setMethod == null) {
                if (MetadataHelper.getDeclaredAnnotationsCount(method, this.m_descriptor) > 0) {
                    this.m_validator.throwNoCorrespondingSetterMethodDefined(this.getJavaClass(), method);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void process() {
        if (this.hasEntity(this.getJavaClass())) {
            this.m_descriptor.setIgnoreFlags();
            this.processEntity();
            this.processTableAndInheritance();
            this.processClassMetadata();
            this.processMappedSuperclasses();
            this.processAccessors();
            this.validatePrimaryKey();
            this.processSecondaryTables();
        } else {
            this.m_descriptor.setIsEmbeddable();
            this.processAccessors();
        }
    }

    protected void processAccessor(MetadataAccessor accessor) {
        if (!accessor.isProcessed()) {
            this.m_descriptor.addAccessor(accessor);
            if (accessor.isRelationship()) {
                this.m_project.addRelationshipDescriptor(this.m_descriptor);
            } else {
                accessor.process();
                accessor.setIsProcessed();
            }
        }
    }

    protected void processAccessorFields() {
        for (Field field : MetadataHelper.getFields(this.getJavaClass())) {
            if (!this.isValidPersistenceField(field)) continue;
            this.processAccessor(this.buildAccessor(new MetadataField(field)));
        }
    }

    protected void processAccessorMethods() {
        for (Method method : MetadataHelper.getDeclaredMethods(this.getJavaClass())) {
            if (!this.isValidPersistenceMethod(method)) continue;
            this.processAccessor(this.buildAccessor(new MetadataMethod(method)));
        }
    }

    protected void processAccessors() {
        if (this.m_descriptor.usesPropertyAccess()) {
            this.processAccessorMethods();
        } else {
            this.processAccessorFields();
        }
    }

    protected void processAssociationOverride(String attributeName, MetadataJoinColumns joinColumns) {
        if (joinColumns.loadedFromXML()) {
            this.m_descriptor.addAssociationOverride(attributeName, joinColumns);
        } else {
            MetadataJoinColumns existingJoinColumns = this.m_descriptor.getAssociationOverrideFor(attributeName);
            if (existingJoinColumns == null || !existingJoinColumns.loadedFromXML()) {
                this.m_descriptor.addAssociationOverride(attributeName, joinColumns);
            }
        }
    }

    protected void processAssociationOverrides() {
        AssociationOverride associationOverride;
        AssociationOverrides associationOverrides = (AssociationOverrides)this.getAnnotation(AssociationOverrides.class);
        if (associationOverrides != null) {
            for (AssociationOverride associationOverride2 : associationOverrides.value()) {
                this.processAssociationOverride(associationOverride2.name(), new MetadataJoinColumns(associationOverride2.joinColumns()));
            }
        }
        if ((associationOverride = (AssociationOverride)this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(associationOverride.name(), new MetadataJoinColumns(associationOverride.joinColumns()));
        }
    }

    protected void processAttributeOverride(MetadataColumn column) {
        String attributeName = column.getAttributeName();
        if (column.loadedFromXML()) {
            this.m_descriptor.addAttributeOverride(column);
        } else {
            MetadataColumn existingColumn = this.m_descriptor.getAttributeOverrideFor(attributeName);
            if (existingColumn == null || !existingColumn.loadedFromXML()) {
                this.m_descriptor.addAttributeOverride(column);
            }
        }
    }

    protected void processAttributeOverrides() {
        AttributeOverride attributeOverride;
        AttributeOverrides attributeOverrides = (AttributeOverrides)this.getAnnotation(AttributeOverrides.class);
        if (attributeOverrides != null) {
            for (AttributeOverride attributeOverride2 : attributeOverrides.value()) {
                this.processAttributeOverride(new MetadataColumn(attributeOverride2, this.getAnnotatedElement()));
            }
        }
        if ((attributeOverride = (AttributeOverride)this.getAnnotation(AttributeOverride.class)) != null) {
            this.processAttributeOverride(new MetadataColumn(attributeOverride, this.getAnnotatedElement()));
        }
    }

    protected void processCallbackMethods(Method[] candidateMethods, MetadataEntityListener listener) {
        for (Method method : candidateMethods) {
            if (this.isAnnotationPresent(PostLoad.class, method)) {
                this.setPostLoad(method, listener);
            }
            if (this.isAnnotationPresent(PostPersist.class, method)) {
                this.setPostPersist(method, listener);
            }
            if (this.isAnnotationPresent(PostRemove.class, method)) {
                this.setPostRemove(method, listener);
            }
            if (this.isAnnotationPresent(PostUpdate.class, method)) {
                this.setPostUpdate(method, listener);
            }
            if (this.isAnnotationPresent(PrePersist.class, method)) {
                this.setPrePersist(method, listener);
            }
            if (this.isAnnotationPresent(PreRemove.class, method)) {
                this.setPreRemove(method, listener);
            }
            if (!this.isAnnotationPresent(PreUpdate.class, method)) continue;
            this.setPreUpdate(method, listener);
        }
    }

    protected void processClassMetadata() {
        this.processAttributeOverrides();
        this.processAssociationOverrides();
        this.processNamedQueries();
        this.processNamedNativeQueries();
        this.processSqlResultSetMappings();
        this.processTableGenerator();
        this.processSequenceGenerator();
        this.processIdClass();
        this.processExcludeDefaultListeners();
        this.processExcludeSuperclassListeners();
    }

    protected void processDefaultListeners(ClassLoader loader) {
        HashMap<XMLHelper, NodeList> defaultListeners = this.m_project.getDefaultListeners();
        for (XMLHelper helper : defaultListeners.keySet()) {
            helper.setLoader(loader);
            NodeList nodes = (NodeList)defaultListeners.get(helper);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                XMLEntityListener listener = new XMLEntityListener(helper.getClassForNode(node), this.getJavaClass());
                Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForDefaultListener(listener);
                this.processLifecycleEvents(listener, node, helper, candidateMethods);
                this.processCallbackMethods(candidateMethods, listener);
                this.m_descriptor.addDefaultEventListener(listener);
            }
        }
    }

    protected void processDiscriminatorColumn() {
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.getAnnotation(DiscriminatorColumn.class);
        this.processDiscriminatorColumn(new MetadataDiscriminatorColumn(discriminatorColumn));
    }

    protected void processDiscriminatorColumn(MetadataDiscriminatorColumn discriminatorColumn) {
        DatabaseField field = new DatabaseField();
        field.setName(this.getName(discriminatorColumn.getName(), "DTYPE", "metadata_default_discriminator_column"));
        field.setLength(discriminatorColumn.getLength());
        field.setTableName(this.m_descriptor.getPrimaryTableName());
        field.setColumnDefinition(discriminatorColumn.getColumnDefinition());
        field.setType(MetadataHelper.getDiscriminatorType(discriminatorColumn.getDiscriminatorType()));
        this.m_descriptor.setClassIndicatorField(field);
    }

    protected void processDiscriminatorValue() {
        if (!Modifier.isAbstract(this.getJavaClass().getModifiers())) {
            String discriminatorValue = this.getDiscriminatorValue();
            if (discriminatorValue == null) {
                this.m_descriptor.addClassIndicator(this.getJavaClass(), Helper.getShortClassName(this.getJavaClassName()));
            } else {
                this.m_descriptor.addClassIndicator(this.getJavaClass(), discriminatorValue);
            }
        }
    }

    protected void processEntity() {
        if (this.m_descriptor.getAlias().equals("")) {
            ClassDescriptor existingDescriptor;
            String alias = this.getEntityName();
            if (alias.equals("")) {
                alias = Helper.getShortClassName(this.getJavaClassName());
                this.m_logger.logConfigMessage("metadata_default_alias", this.m_descriptor, (Object)alias);
            }
            if ((existingDescriptor = this.getProject().getSession().getProject().getDescriptorForAlias(alias)) != null) {
                this.m_validator.throwNonUniqueEntityName(existingDescriptor.getJavaClassName(), this.m_descriptor.getJavaClassName(), alias);
            }
            this.m_descriptor.setAlias(alias);
            this.getProject().getSession().getProject().addAlias(alias, this.m_descriptor.getClassDescriptor());
        }
    }

    public MetadataEntityListener processEntityEventListener(ClassLoader loader) {
        MetadataEntityClassListener listener = new MetadataEntityClassListener(this.getJavaClass());
        this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityClass(this.getJavaClass()), listener);
        return listener;
    }

    public void processEntityListeners(Class entityClass, ClassLoader loader) {
        EntityListeners entityListeners = (EntityListeners)this.getAnnotation(EntityListeners.class);
        if (entityListeners != null) {
            for (Class entityListener : entityListeners.value()) {
                MetadataEntityListener listener = new MetadataEntityListener(entityListener, entityClass);
                this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener), listener);
                this.m_descriptor.addEntityListenerEventListener(listener);
            }
        }
    }

    protected void processExcludeDefaultListeners() {
        if (this.isAnnotationPresent(ExcludeDefaultListeners.class)) {
            this.m_descriptor.setExcludeDefaultListeners(true);
        }
    }

    protected void processExcludeSuperclassListeners() {
        if (this.isAnnotationPresent(ExcludeSuperclassListeners.class)) {
            this.m_descriptor.setExcludeSuperclassListeners(true);
        }
    }

    protected void processIdClass() {
        IdClass idClass = (IdClass)this.getAnnotation(IdClass.class);
        if (idClass != null) {
            this.processIdClass(idClass.value(), "annotation_warning_ignore_id_class");
        }
    }

    protected void processIdClass(Class idClass, String ignoreCtx) {
        if (this.m_descriptor.ignoreIDs()) {
            this.m_logger.logWarningMessage(ignoreCtx, this.m_descriptor, idClass);
        } else {
            this.m_descriptor.setPKClass(idClass);
            if (this.m_descriptor.usesPropertyAccess()) {
                for (Method method : MetadataHelper.getDeclaredMethods(idClass)) {
                    String methodName = method.getName();
                    if (!MetadataHelper.isValidPersistenceMethodName(methodName)) continue;
                    this.m_descriptor.addPKClassId(MetadataHelper.getAttributeNameFromMethodName(methodName), MetadataHelper.getGenericReturnType(method));
                }
            } else {
                for (Field field : MetadataHelper.getFields(idClass)) {
                    this.m_descriptor.addPKClassId(field.getName(), MetadataHelper.getGenericType(field));
                }
            }
        }
    }

    protected void processInheritance() {
        if (this.m_descriptor.ignoreInheritance()) {
            this.m_logger.logWarningMessage("metadata_warning_ignore_inheritance", this.m_descriptor);
        } else {
            String inheritanceStrategy = this.getInheritanceStrategy();
            if (inheritanceStrategy.equals("")) {
                inheritanceStrategy = InheritanceType.SINGLE_TABLE.name();
            }
            this.m_descriptor.setInheritanceStrategy(inheritanceStrategy);
            this.processDiscriminatorColumn();
            this.processDiscriminatorValue();
        }
    }

    protected void processInheritanceSubclass(MetadataDescriptor parentDescriptor) {
        if (this.m_descriptor.ignoreInheritance()) {
            this.m_logger.logWarningMessage("metadata_warning_ignore_inheritance", this.m_descriptor);
        } else {
            if (parentDescriptor.usesSingleTableInheritanceStrategy() && !this.hasInheritance()) {
                this.m_descriptor.setSingleTableInheritanceStrategy();
            } else {
                MetadataPrimaryKeyJoinColumns primaryKeyJoinColumns = this.getPrimaryKeyJoinColumns(parentDescriptor.getPrimaryTableName(), this.m_descriptor.getPrimaryTableName());
                this.addMultipleTableKeyFields(primaryKeyJoinColumns, "metadata_default_inheritance_pk_column", "metadata_default_inheritance_fk_column");
            }
            if (!this.hasInheritance()) {
                this.processDiscriminatorValue();
            }
            if (parentDescriptor.hasCompositePrimaryKey()) {
                this.m_descriptor.setPKClass(parentDescriptor.getPKClassName());
            }
        }
    }

    protected List<MetadataJoinColumn> processJoinColumns(JoinColumn[] joinColumns) {
        ArrayList<MetadataJoinColumn> list = new ArrayList<MetadataJoinColumn>();
        for (JoinColumn joinColumn : joinColumns) {
            list.add(new MetadataJoinColumn(joinColumn));
        }
        return list;
    }

    protected void processLifecycleEvent(MetadataEntityListener listener, Node node, String event, XMLHelper helper, Method[] candidateMethods) {
        Node eventNode = helper.getNode(node, event);
        if (eventNode != null) {
            String methodName = helper.getNodeValue(eventNode, "@method-name");
            Method method = MetadataHelper.getMethodForName(candidateMethods, methodName);
            if (method == null) {
                this.m_validator.throwInvalidCallbackMethod(listener.getListenerClass(), methodName);
            } else if (event.equals("pre-persist")) {
                this.setPrePersist(method, listener);
            } else if (event.equals("post-persist")) {
                this.setPostPersist(method, listener);
            } else if (event.equals("pre-remove")) {
                this.setPreRemove(method, listener);
            } else if (event.equals("post-remove")) {
                this.setPostRemove(method, listener);
            } else if (event.equals("pre-update")) {
                this.setPreUpdate(method, listener);
            } else if (event.equals("post-update")) {
                this.setPostUpdate(method, listener);
            } else if (event.equals("post-load")) {
                this.setPostLoad(method, listener);
            }
        }
    }

    protected void processLifecycleEvents(MetadataEntityListener listener, Node node, XMLHelper helper, Method[] candidateMethods) {
        this.processLifecycleEvent(listener, node, "pre-persist", helper, candidateMethods);
        this.processLifecycleEvent(listener, node, "post-persist", helper, candidateMethods);
        this.processLifecycleEvent(listener, node, "pre-remove", helper, candidateMethods);
        this.processLifecycleEvent(listener, node, "post-remove", helper, candidateMethods);
        this.processLifecycleEvent(listener, node, "pre-update", helper, candidateMethods);
        this.processLifecycleEvent(listener, node, "post-update", helper, candidateMethods);
        this.processLifecycleEvent(listener, node, "post-load", helper, candidateMethods);
    }

    public void processListeners(ClassLoader loader) {
        this.processDefaultListeners(loader);
        if (!this.m_descriptor.excludeSuperclassListeners()) {
            List<ClassAccessor> mappedSuperclasses = this.getMappedSuperclasses();
            int mappedSuperclassesSize = mappedSuperclasses.size();
            for (int i = mappedSuperclassesSize - 1; i >= 0; --i) {
                mappedSuperclasses.get(i).processEntityListeners(this.getJavaClass(), loader);
            }
        }
        this.processEntityListeners(this.getJavaClass(), loader);
        MetadataEntityListener listener = this.processEntityEventListener(loader);
        if (!this.m_descriptor.excludeSuperclassListeners()) {
            for (ClassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
                mappedSuperclass.processMappedSuperclassEventListener(listener, this.getJavaClass(), loader);
            }
        }
        if (listener.hasCallbackMethods()) {
            this.m_descriptor.setEntityEventListener(listener);
        }
    }

    protected void processMappedSuperclass() {
        this.processClassMetadata();
        this.processAccessors();
    }

    protected void processMappedSuperclasses() {
        for (ClassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
            mappedSuperclass.process();
        }
    }

    public void processMappedSuperclassEventListener(MetadataEntityListener listener, Class entityClass, ClassLoader loader) {
        this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForMappedSuperclass(this.getJavaClass(), entityClass), listener);
    }

    protected void processNamedNativeQueries() {
        NamedNativeQuery namedNativeQuery;
        NamedNativeQueries namedNativeQueries = (NamedNativeQueries)this.getAnnotation(NamedNativeQueries.class);
        if (namedNativeQueries != null) {
            for (NamedNativeQuery namedNativeQuery2 : namedNativeQueries.value()) {
                this.processNamedNativeQuery(new MetadataNamedNativeQuery(namedNativeQuery2, this.getJavaClass()));
            }
        }
        if ((namedNativeQuery = (NamedNativeQuery)this.getAnnotation(NamedNativeQuery.class)) != null) {
            this.processNamedNativeQuery(new MetadataNamedNativeQuery(namedNativeQuery, this.getJavaClass()));
        }
    }

    protected void processNamedNativeQuery(MetadataNamedNativeQuery namedNativeQuery) {
        if (this.m_project.hasNamedNativeQuery(namedNativeQuery.getName())) {
            MetadataNamedNativeQuery existingNamedNativeQuery = this.m_project.getNamedNativeQuery(namedNativeQuery.getName());
            if (existingNamedNativeQuery.loadedFromAnnotations() && namedNativeQuery.loadedFromXML()) {
                this.m_project.addNamedNativeQuery(namedNativeQuery);
            } else {
                this.m_logger.logWarningMessage(namedNativeQuery.getIgnoreLogMessageContext(), namedNativeQuery.getLocation(), namedNativeQuery.getName());
            }
        } else {
            this.m_project.addNamedNativeQuery(namedNativeQuery);
        }
    }

    protected void processNamedQueries() {
        NamedQuery namedQuery;
        NamedQueries namedQueries = (NamedQueries)this.getAnnotation(NamedQueries.class);
        if (namedQueries != null) {
            for (NamedQuery namedQuery2 : namedQueries.value()) {
                this.processNamedQuery(new MetadataNamedQuery(namedQuery2, this.getJavaClass()));
            }
        }
        if ((namedQuery = (NamedQuery)this.getAnnotation(NamedQuery.class)) != null) {
            this.processNamedQuery(new MetadataNamedQuery(namedQuery, this.getJavaClass()));
        }
    }

    protected void processNamedQuery(MetadataNamedQuery namedQuery) {
        if (this.m_project.hasNamedQuery(namedQuery.getName())) {
            MetadataNamedQuery existingNamedQuery = this.m_project.getNamedQuery(namedQuery.getName());
            if (existingNamedQuery.loadedFromAnnotations() && namedQuery.loadedFromXML()) {
                this.m_project.addNamedQuery(namedQuery);
            } else {
                this.m_logger.logWarningMessage(namedQuery.getIgnoreLogMessageContext(), namedQuery.getLocation(), namedQuery.getName());
            }
        } else {
            this.m_project.addNamedQuery(namedQuery);
        }
    }

    protected void processSecondaryTable(MetadataSecondaryTable secondaryTable) {
        this.processTable(secondaryTable, secondaryTable.getName());
        this.m_descriptor.addTable(secondaryTable.getDatabaseTable());
        MetadataPrimaryKeyJoinColumns primaryKeyJoinColumns = secondaryTable.getPrimaryKeyJoinColumns(this.m_descriptor.getPrimaryTableName());
        this.addMultipleTableKeyFields(primaryKeyJoinColumns, "metadata_default_secondary_table_pk_column", "metadata_default_secondary_table_fk_column");
    }

    protected void processSecondaryTables() {
        SecondaryTables secondaryTables = (SecondaryTables)this.getAnnotation(SecondaryTables.class);
        if (secondaryTables != null) {
            if (this.m_descriptor.ignoreTables()) {
                this.m_logger.logWarningMessage("annotation_warning_ignore_secondary_table", this.getJavaClass());
            } else {
                for (SecondaryTable secondaryTable : secondaryTables.value()) {
                    this.processSecondaryTable(new MetadataSecondaryTable(secondaryTable, this.m_logger));
                }
            }
        } else {
            SecondaryTable secondaryTable = (SecondaryTable)this.getAnnotation(SecondaryTable.class);
            if (secondaryTable != null) {
                if (this.m_descriptor.ignoreTables()) {
                    this.m_logger.logWarningMessage("annotation_warning_ignore_secondary_table", this.getJavaClass());
                } else {
                    this.processSecondaryTable(new MetadataSecondaryTable(secondaryTable, this.m_logger));
                }
            }
        }
    }

    protected void processSqlResultSetMapping(MetadataSQLResultSetMapping sqlResultSetMapping) {
        SQLResultSetMapping mapping = new SQLResultSetMapping(sqlResultSetMapping.getName());
        for (MetadataEntityResult eResult : sqlResultSetMapping.getEntityResults()) {
            EntityResult entityResult = new EntityResult(eResult.getEntityClass().getName());
            for (MetadataFieldResult fResult : eResult.getFieldResults()) {
                entityResult.addFieldResult(new FieldResult(fResult.getName(), fResult.getColumn()));
            }
            entityResult.setDiscriminatorColumn(eResult.getDiscriminatorColumn());
            mapping.addResult(entityResult);
        }
        for (String columnResult : sqlResultSetMapping.getColumnResults()) {
            mapping.addResult(new ColumnResult(columnResult));
        }
        this.getProject().getSession().getProject().addSQLResultSetMapping(mapping);
    }

    protected void processSqlResultSetMappings() {
        SqlResultSetMappings sqlResultSetMappings = (SqlResultSetMappings)this.getAnnotation(SqlResultSetMappings.class);
        if (sqlResultSetMappings != null) {
            for (SqlResultSetMapping sqlResultSetMapping : sqlResultSetMappings.value()) {
                this.processSqlResultSetMapping(new MetadataSQLResultSetMapping(sqlResultSetMapping));
            }
        } else {
            SqlResultSetMapping sqlResultSetMapping = (SqlResultSetMapping)this.getAnnotation(SqlResultSetMapping.class);
            if (sqlResultSetMapping != null) {
                this.processSqlResultSetMapping(new MetadataSQLResultSetMapping(sqlResultSetMapping));
            }
        }
    }

    protected void processTable() {
        if (this.m_descriptor.ignoreTables()) {
            this.m_logger.logWarningMessage("annotation_warning_ignore_table", this.getJavaClass());
        } else {
            Table table = (Table)this.getAnnotation(Table.class);
            this.processTable(new MetadataTable(table, this.m_logger));
        }
    }

    protected void processTable(MetadataTable table) {
        this.processTable(table, this.m_descriptor.getDefaultTableName());
        this.m_descriptor.setPrimaryTable(table.getDatabaseTable());
    }

    protected void processTableAndInheritance() {
        if (this.isInheritanceSubclass()) {
            MetadataDescriptor parentDescriptor = this.getInheritanceParentDescriptor();
            ClassAccessor parentAccessor = parentDescriptor.getClassAccessor();
            if (parentAccessor == null) {
                parentAccessor = this.processAccessor(parentDescriptor);
            }
            if (!parentDescriptor.hasInheritance()) {
                parentAccessor.processInheritance();
            }
            if (this.hasInheritance()) {
                this.processTable();
                this.processInheritance();
                this.processInheritanceSubclass(parentDescriptor);
            } else {
                if (parentDescriptor.usesJoinedInheritanceStrategy()) {
                    this.processTable();
                }
                this.processInheritanceSubclass(parentDescriptor);
            }
        } else {
            this.processTable();
            if (this.hasInheritance()) {
                this.processInheritance();
            }
        }
    }

    protected void setPostLoad(Method method, MetadataEntityListener listener) {
        listener.setPostBuildMethod(method);
        listener.setPostCloneMethod(method);
        listener.setPostRefreshMethod(method);
    }

    protected void setPostPersist(Method method, MetadataEntityListener listener) {
        listener.setPostInsertMethod(method);
    }

    protected void setPostRemove(Method method, MetadataEntityListener listener) {
        listener.setPostDeleteMethod(method);
    }

    protected void setPostUpdate(Method method, MetadataEntityListener listener) {
        listener.setPostUpdateMethod(method);
    }

    protected void setPrePersist(Method method, MetadataEntityListener listener) {
        listener.setPrePersistMethod(method);
    }

    protected void setPreRemove(Method method, MetadataEntityListener listener) {
        listener.setPreRemoveMethod(method);
    }

    protected void setPreUpdate(Method method, MetadataEntityListener listener) {
        listener.setPreUpdateWithChangesMethod(method);
    }

    protected void validatePrimaryKey() {
        if (this.m_descriptor.hasCompositePrimaryKey()) {
            if (this.m_descriptor.pkClassWasNotValidated()) {
                this.m_validator.throwInvalidCompositePKSpecification(this.getJavaClass(), this.m_descriptor.getPKClassName());
            }
        } else if (!this.m_descriptor.hasPrimaryKeyFields() && !this.isInheritanceSubclass()) {
            this.m_validator.throwNoPrimaryKeyAnnotationsFound(this.getJavaClass());
        }
    }
}

