/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.JoinTable;
import javax.persistence.MapKey;
import javax.persistence.OrderBy;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.RelationshipAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataJoinTable;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;

public abstract class CollectionAccessor
extends RelationshipAccessor {
    public CollectionAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    protected void addManyToManyRelationKeyFields(MetadataJoinColumns joinColumns, ManyToManyMapping mapping, String defaultFieldName, MetadataDescriptor descriptor, boolean isSource) {
        String FK_CTX;
        String PK_CTX;
        if (isSource) {
            PK_CTX = "metadata_default_source_pk_column";
            FK_CTX = "metadata_default_source_fk_column";
        } else {
            PK_CTX = "metadata_default_target_pk_column";
            FK_CTX = "metadata_default_target_fk_column";
        }
        for (MetadataJoinColumn joinColumn : this.processJoinColumns(joinColumns, descriptor)) {
            String defaultPKFieldName = descriptor.getPrimaryKeyFieldName();
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX));
            pkField.setTableName(descriptor.getPrimaryKeyTableName());
            DatabaseField fkField = joinColumn.getForeignKeyField();
            String defaultFKFieldName = defaultFieldName + "_" + defaultPKFieldName;
            fkField.setName(this.getName(fkField, defaultFKFieldName, FK_CTX));
            fkField.setTableName(mapping.getRelationTableQualifiedName());
            if (isSource) {
                mapping.addSourceRelationKeyField(fkField, pkField);
                continue;
            }
            mapping.addTargetRelationKeyField(fkField, pkField);
        }
    }

    protected MetadataJoinTable getJoinTable() {
        JoinTable joinTable = (JoinTable)this.getAnnotation(JoinTable.class);
        return new MetadataJoinTable(joinTable, this.m_logger);
    }

    public String getMapKey() {
        if (this.isAnnotationPresent(MapKey.class)) {
            MapKey mapKey = (MapKey)this.getAnnotation(MapKey.class);
            return mapKey.name();
        }
        return "";
    }

    public String getOrderBy() {
        OrderBy orderBy = (OrderBy)this.getAnnotation(OrderBy.class);
        return orderBy.value();
    }

    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = this.m_accessibleObject.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    this.m_validator.throwUnableToDetermineTargetEntity(this.getAttributeName(), this.getJavaClass());
                } else {
                    this.m_logger.logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
                }
            }
        }
        return this.m_referenceClass;
    }

    public boolean hasOrderBy() {
        return this.isAnnotationPresent(OrderBy.class);
    }

    public boolean isMapCollectionAccessor() {
        return this.getRawClass().equals(Map.class);
    }

    protected void process(CollectionMapping mapping) {
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(false);
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        this.processOrderBy(mapping);
        String mapKey = this.processMapKey(mapping);
        this.setIndirectionPolicy(mapping, mapKey);
    }

    protected void processJoinTable(MetadataJoinTable joinTable, ManyToManyMapping mapping) {
        String defaultName = this.m_descriptor.getPrimaryTableName() + "_" + this.getReferenceDescriptor().getPrimaryTableName();
        this.processTable(joinTable, defaultName);
        mapping.setRelationTable(joinTable.getDatabaseTable());
        String defaultSourceFieldName = this.getReferenceDescriptor().hasBiDirectionalManyToManyAccessorFor(this.getJavaClassName(), this.getAttributeName()) ? this.getReferenceDescriptor().getBiDirectionalManyToManyAccessor(this.getJavaClassName(), this.getAttributeName()).getAttributeName() : this.m_descriptor.getAlias();
        this.addManyToManyRelationKeyFields(joinTable.getJoinColumns(), mapping, defaultSourceFieldName, this.m_descriptor, true);
        String defaultTargetFieldName = this.getAttributeName();
        this.addManyToManyRelationKeyFields(joinTable.getInverseJoinColumns(), mapping, defaultTargetFieldName, this.getReferenceDescriptor(), false);
    }

    protected String processMapKey(CollectionMapping mapping) {
        String mapKey = null;
        if (this.isMapCollectionAccessor()) {
            MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
            String mapKeyValue = this.getMapKey();
            if (!mapKeyValue.equals("") || !referenceDescriptor.hasCompositePrimaryKey()) {
                String string = referenceDescriptor.getIdAttributeName();
                this.getLogger();
                String fieldOrPropertyName = this.getName(mapKeyValue, string, "metadata_default_map_key_attribute_name");
                MetadataAccessor referenceAccessor = referenceDescriptor.getAccessorFor(fieldOrPropertyName);
                if (referenceAccessor == null) {
                    this.m_validator.throwCouldNotFindMapKey(fieldOrPropertyName, referenceDescriptor.getJavaClass(), mapping);
                }
                mapKey = referenceAccessor.getName();
            }
        }
        return mapKey;
    }

    protected void processOrderBy(CollectionMapping mapping) {
        block10: {
            if (!this.hasOrderBy()) break block10;
            String orderBy = this.getOrderBy();
            MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
            if (orderBy.equals("")) {
                List<String> orderByAttributes = referenceDescriptor.getIdOrderByAttributeNames();
                if (referenceDescriptor.hasEmbeddedIdAttribute()) {
                    String embeddedIdAttributeName = referenceDescriptor.getEmbeddedIdAttributeName();
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addAggregateOrderBy(embeddedIdAttributeName, orderByAttribute, false);
                    }
                } else {
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addOrderBy(orderByAttribute, false);
                    }
                }
            } else {
                StringTokenizer commaTokenizer = new StringTokenizer(orderBy, ",");
                while (commaTokenizer.hasMoreTokens()) {
                    String ordering;
                    StringTokenizer spaceTokenizer = new StringTokenizer(commaTokenizer.nextToken());
                    String propertyOrFieldName = spaceTokenizer.nextToken();
                    MetadataAccessor referenceAccessor = referenceDescriptor.getAccessorFor(propertyOrFieldName);
                    if (referenceAccessor == null) {
                        this.m_validator.throwInvalidOrderByValue(this.getJavaClass(), propertyOrFieldName, referenceDescriptor.getJavaClass(), this.getName());
                    }
                    String attributeName = referenceAccessor.getAttributeName();
                    String string = ordering = spaceTokenizer.hasMoreTokens() ? spaceTokenizer.nextToken() : "ASC";
                    if (referenceAccessor.isEmbedded()) {
                        for (String orderByAttributeName : referenceDescriptor.getOrderByAttributeNames()) {
                            mapping.addAggregateOrderBy(attributeName, orderByAttributeName, ordering.equals("DESC"));
                        }
                        continue;
                    }
                    mapping.addOrderBy(attributeName, ordering.equals("DESC"));
                }
            }
        }
    }
}

