/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.config;

/**
 * PessimisticLock hint values.
 * 
 * The class contains all the valid values for TopLinkQueryHints.PESSIMISTIC_LOCK query hint.
 * 
 * JPA Query Hint Usage:
 * 
 * query.setHint(TopLinkQueryHints.PESSIMISTIC_LOCK, PessimisticLock.Lock);
 * or 
 * @QueryHint(name=TopLinkQueryHints.PESSIMISTIC_LOCK, value=PessimisticLock.Lock)
 * 
 * Hint values are case-insensitive.
 * "" could be used instead of default value PessimisticLock.DEFAULT.
 * 
 * @see TopLinkQueryHints
 */
public class PessimisticLock {
    public static final String  NoLock = "NoLock";
    public static final String  Lock = "Lock";
    public static final String  LockNoWait = "LockNoWait";
 
    public static final String DEFAULT = NoLock;
}
