/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;

/**
 * INTERNAL:
 * EqualsAssignmentNode is implemented to distinguish nodes that hold updates in an update
 * query from other BinaryOperatorNodes
 */
public class EqualsAssignmentNode extends BinaryOperatorNode {

    /**
     * INTERNAL
     * Validate the current node and calculates its type.
     */
    public void validate(ParseTreeContext context) {
        // look for any field access that is not qualified with an variable
        super.validate(context);
        validateTarget(left, context);
    }

    /** */
    private void validateTarget(Node node, ParseTreeContext context) {
        if (node.isDotNode()) {
            TypeHelper typeHelper = context.getTypeHelper();
            Node path = node.getLeft();
            Object type = path.getType();
            AttributeNode attributeNode = (AttributeNode)node.getRight();
            String attribute = attributeNode.getAttributeName();
            if (typeHelper.isSingleValuedRelationship(type, attribute) || 
                typeHelper.isSimpleStateAttribute(type, attribute)) {
                validateNavigation(path, context);
            } else {
                throw EJBQLException.invalidSetClauseTarget(
                    context.getQueryInfo(), attributeNode.getLine(), 
                    attributeNode.getColumn(), path.getAsString(), attribute);
            }
        }
    }

    /** */
    private void validateNavigation(Node qualifier, ParseTreeContext context) {
        if (qualifier.isDotNode()) {
            TypeHelper typeHelper = context.getTypeHelper();
            Node left = qualifier.getLeft();
            AttributeNode attributeNode = (AttributeNode)qualifier.getRight();
            String attribute = attributeNode.getAttributeName();
            Object type = left.getType();
            if (!typeHelper.isEmbeddedAttribute(type, attribute)) {
                throw EJBQLException.invalidSetClauseNavigation(
                    context.getQueryInfo(), attributeNode.getLine(), 
                    attributeNode.getColumn(), qualifier.getAsString(), attribute);
            }
            validateNavigation(left, context);
        }
    }
    
}
