/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions.i18n;

import java.util.ListResourceBundle;

/**
 * INTERNAL:
 * English ResourceBundle for ConcurrencyException messages.
 *
 * Creation date: (12/6/00 9:47:38 AM)
 * @author: Xi Chen
 */
public class ConcurrencyExceptionResource extends ListResourceBundle {
    static final Object[][] contents = {
                                           { "2001", "Wait was interrupted. {0}Message: [{1}]" },
                                           { "2002", "Wait failure on ServerSession." },
                                           { "2003", "Wait failure on ClientSession." },
                                           { "2004", "A signal was attempted before wait() on ConcurrencyManager. This normally means that an attempt was made to {0}commit or rollback a transaction before it was started, or to rollback a transaction twice." },
                                           { "2005", "Wait failure on Sequencing Connection Handler for DatabaseSession." },
                                           { "2006", "Attempt to acquire sequencing values through a single Connection({0}) simultaneously in multiple threads" },
                                           { "2007", "Max number of attempts to lock object: {0} exceded.  Failed to clone the object." },
                                           { "2008", "Max number of attempts to lock object: {0} exceded.  Failed to merge the transaction." },
                                           { "2009", "Max number of attempts to lock object exceded.  Failed to build the object. Thread: {0} has a lock on the object but thread: {1} is building the object"}																					 
    };

    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
