/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.queries;

import java.util.List;
import java.util.ArrayList;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataEntityResult;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries.MetadataSQLResultSetMapping;

/**
 * Object to hold onto an XML sql result set mapping metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLSQLResultSetMapping extends MetadataSQLResultSetMapping {
    protected Node m_node;
    protected XMLHelper m_helper;

    /**
     * INTERNAL:
     */
    public XMLSQLResultSetMapping(Node node, XMLHelper helper) {
        m_node = node;
        m_helper = helper;
    }
    
   /**
     * INTERNAL:
     */
    public List<MetadataEntityResult> getEntityResults() {
        if (m_entityResults == null) {
            m_entityResults = new ArrayList<MetadataEntityResult>();
            NodeList entityResultNodes = m_helper.getNodes(m_node, XMLConstants.ENTITY_RESULT);
            
            if (entityResultNodes != null) {
                for (int i = 0; i < entityResultNodes.getLength(); i++) {
                    m_entityResults.add(new XMLEntityResult(entityResultNodes.item(i), m_helper));
                }
            }
        }
        
        return m_entityResults;
    }
    
    /**
     * INTERNAL:
     */
    public List<String> getColumnResults() {
        if (m_columnResults == null) {
            m_columnResults = new ArrayList<String>();    
            NodeList columnResultList = m_helper.getNodes(m_node, XMLConstants.COLUMN_RESULT);
            
            if (columnResultList != null) {
                for (int i = 0; i < columnResultList.getLength(); i++) {
                    m_columnResults.add(m_helper.getNodeValue(columnResultList.item(i), XMLConstants.ATT_NAME));
                }
            }
        }
        
        return m_columnResults;
    }
    
    /**
     * INTERNAL:
     */
    public String getName() {
        return m_helper.getNodeValue(m_node, XMLConstants.ATT_NAME);
    }
}
