/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.expressions;

import java.util.*;
import oracle.toplink.essentials.internal.helper.*;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

/**
 * <p><b>Purpose</b>: Mirror SQL behavior.
 * <p><b>Responsibilities</b>:<ul>
 * <li> Mirror SQL behavior.
 * <li> Print as SQL string.
 * </ul>
 *    @author Dorin Sandu
 *    @since TOPLink/Java 1.0
 */
public abstract class SQLModifyStatement extends SQLStatement {
    protected DatabaseTable table;
    protected AbstractRecord modifyRow;
    protected Vector returnFields;

    public AbstractRecord getModifyRow() {
        return modifyRow;
    }

    public Vector getReturnFields() {
        return returnFields;
    }

    public DatabaseTable getTable() {
        return table;
    }

    public void setModifyRow(AbstractRecord row) {
        modifyRow = row;
    }

    public void setReturnFields(Vector fields) {
        returnFields = fields;
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
    }

    public DatabaseCall buildCall(AbstractSession session) {
        SQLCall sqlCall = buildCallWithoutReturning(session);
        if ((getReturnFields() == null) || getReturnFields().isEmpty()) {
            return sqlCall;
        } else {
            return session.getPlatform().buildCallWithReturning(sqlCall, getReturnFields());
        }
    }

    protected SQLCall buildCallWithoutReturning(AbstractSession session) {
        return null;
    }
}
