/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.queryframework;

import oracle.toplink.essentials.exceptions.*;

/**
 * <p><b>Purpose</b>:
 * Used for updating existing objects into the database.
 * This class does not have much behavior.
 * It inherits most of it's behavior from WriteObjectQuery
 *
 * @author Yvon Lavoie
 * @since TOPLink/Java 1.0
 */
public class UpdateObjectQuery extends WriteObjectQuery {

    /**
     * PUBLIC:
     * Default constructor.
     */
    public UpdateObjectQuery() {
        super();
    }

    /**
     * PUBLIC:
     * Create an update query with the object being updated.
     */
    public UpdateObjectQuery(Object objectToUpdate) {
        this();
        setObject(objectToUpdate);
    }

    /**
     * PUBLIC:
     * Create an update query with the custom call.
     */
    public UpdateObjectQuery(Call call) {
        this();
        setCall(call);
    }

    /**
     * INTERNAL:
     * Perform an update.
     */
    public void executeCommit() throws DatabaseException, OptimisticLockException {
        getQueryMechanism().updateObjectForWrite();
    }
    
    /**
     * INTERNAL:
     * Perform an update.
     */
    public void executeCommitWithChangeSet() throws DatabaseException, OptimisticLockException {
        getQueryMechanism().updateObjectForWriteWithChangeSet();
    }

    /**
     * INTERNAL:
     * Prepare the receiver for execution in a session.
     */
    protected void prepare() {
        super.prepare();

        getQueryMechanism().prepareUpdateObject();
    }

    /**
     * PUBLIC:
     * Return if this is an update object query.
     */
    public boolean isUpdateObjectQuery() {
        return true;
    }
}
