/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.config;

/**
 * 
 * The class defines TopLink query hints' names.
 * 
 * JPA Query Hint Usage:
 * 
 * query.setHint(TopLinkQueryHints.CACHE_USAGE, CacheUsage.CheckCacheOnly);
 * or 
 * @QueryHint(name=TopLinkQueryHints.CACHE_USAGE, value=CacheUsage.CheckCacheOnly)
 * 
 * Hint values are case-insensitive; "" could be used instead of default value.
 * 
 * @see HintValues
 * @see CacheUsage
 * @see PessimisticLock
 */
public class TopLinkQueryHints {
   /**
    * Valid values are:  HintValues.PERSISTENCE_UNIT_DEFAULT, HintValues.TRUE, HintValues.FALSE
    * "" could be used instead of default value HintValues.PERSISTENCE_UNIT_DEFAULT
    */
    public static final String BIND_PARAMETERS = "toplink.jdbc.bind-parameters";

   /**
    * Valid values are all declared in CacheUsage class.
    */
    public static final String CACHE_USAGE = "toplink.cache-usage";
    
   /**
    * Valid values are all declared in PessimisticLock class.
    */
    public static final String PESSIMISTIC_LOCK = "toplink.pessimistic-lock";
    
   /**
    * Valid values are:  HintValues.FALSE, HintValues.TRUE
    * "" could be used instead of default value HintValues.FALSE
    */
    public static final String REFRESH = "toplink.refresh";
}
