/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns;

import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorColumn;

/**
 * Object to hold onto discriminator column metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataDiscriminatorColumn  {    
    public static final int DEFAULT_LENGTH = 31;
    public static final String DEFAULT_NAME = "DTYPE";
    public static final String DEFAULT_COLUMN_DEFINITION = "";
    public static final String DEFAULT_DISCRIMINATOR_TYPE = DiscriminatorType.STRING.name();
    
    protected DiscriminatorColumn m_discriminatorColumn;
    
    /**
     * INTERNAL:
     */
    protected MetadataDiscriminatorColumn() {}
    
    /**
     * INTERNAL:
     */
    public MetadataDiscriminatorColumn(DiscriminatorColumn discriminatorColumn) {
        m_discriminatorColumn = discriminatorColumn;
    }

    /**
     * INTERNAL:
     */
    public String getColumnDefinition() {
        return (m_discriminatorColumn == null) ? DEFAULT_COLUMN_DEFINITION : m_discriminatorColumn.columnDefinition();
    }
    
    /**
     * INTERNAL:
     */
    public String getDiscriminatorType() {
        return (m_discriminatorColumn == null) ? DEFAULT_DISCRIMINATOR_TYPE : m_discriminatorColumn.discriminatorType().name();
    }
    
    /**
     * INTERNAL:
     */
    public int getLength() {
        return (m_discriminatorColumn == null) ? DEFAULT_LENGTH : m_discriminatorColumn.length();
    }
    
    /**
     * INTERNAL:
     */
    public String getName() {
        return (m_discriminatorColumn == null) ? null : m_discriminatorColumn.name();
    }
}
