/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.Set;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.LogicalOperatorNode;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class OrNode
extends LogicalOperatorNode {
    private Set leftOuterScopeVariables = null;
    private Set rightOuterScopeVariables = null;

    public void validate(ParseTreeContext context) {
        Set saved = context.getOuterScopeVariables();
        if (this.left != null) {
            context.resetOuterScopeVariables();
            this.left.validate(context);
            this.leftOuterScopeVariables = context.getOuterScopeVariables();
        }
        if (this.right != null) {
            context.resetOuterScopeVariables();
            this.right.validate(context);
            this.rightOuterScopeVariables = context.getOuterScopeVariables();
        }
        context.resetOuterScopeVariables(saved);
        if (this.left != null && this.right != null) {
            this.left.validateParameter(context, this.right.getType());
            this.right.validateParameter(context, this.left.getType());
        }
        TypeHelper typeHelper = context.getTypeHelper();
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression leftExpr = this.getLeft().generateExpression(context);
        leftExpr = this.appendOuterScopeVariableJoins(leftExpr, this.leftOuterScopeVariables, context);
        Expression rightExpr = this.getRight().generateExpression(context);
        rightExpr = this.appendOuterScopeVariableJoins(rightExpr, this.rightOuterScopeVariables, context);
        return leftExpr.or(rightExpr);
    }

    private Expression appendOuterScopeVariableJoins(Expression expr, Set outerScopeVariables, GenerationContext context) {
        if (outerScopeVariables == null || outerScopeVariables.isEmpty()) {
            return expr;
        }
        Expression joins = context.joinVariables(outerScopeVariables);
        return this.appendExpression(expr, joins);
    }
}

