/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import oracle.toplink.essentials.PersistenceProvider;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;
import oracle.toplink.essentials.ejb.cmp3.persistence.Archive;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.ejb.cmp3.persistence.SEPersistenceUnitInfo;
import oracle.toplink.essentials.exceptions.EntityManagerSetupException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerSetupImpl;
import oracle.toplink.essentials.logging.AbstractSessionLog;

public class JavaSECMPInitializer {
    public static Instrumentation globalInstrumentation;
    protected boolean shouldCreateInternalLoader = true;
    protected static JavaSECMPInitializer javaSECMPInitializer;
    protected ClassLoader sessionClassLoader = null;

    public static synchronized JavaSECMPInitializer getJavaSECMPInitializer() {
        if (javaSECMPInitializer == null) {
            javaSECMPInitializer = new JavaSECMPInitializer();
        }
        AbstractSessionLog.getLog().setLevel(JavaSECMPInitializer.getTopLinkLoggingLevel());
        return javaSECMPInitializer;
    }

    public static boolean isSingletonInitialized() {
        return javaSECMPInitializer != null;
    }

    public static int getTopLinkLoggingLevel() {
        String logLevel = System.getProperty("toplink.logging.level");
        return AbstractSessionLog.translateStringToLoggingLevel(logLevel);
    }

    protected JavaSECMPInitializer() {
    }

    protected boolean callPredeploy(SEPersistenceUnitInfo persistenceUnitInfo, Map m) {
        ClassLoader tempLoader = null;
        String providerClassName = persistenceUnitInfo.getPersistenceProviderClassName();
        if (providerClassName == null || providerClassName.equals("") || providerClassName.equals(EntityManagerFactoryProvider.class.getName()) || providerClassName.equals(PersistenceProvider.class.getName())) {
            EntityManagerSetupImpl emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(persistenceUnitInfo.getPersistenceUnitRootUrl() + persistenceUnitInfo.getPersistenceUnitName());
            if (emSetupImpl != null && !emSetupImpl.isUndeployed()) {
                return false;
            }
            Set<String> tempLoaderSet = PersistenceUnitProcessor.buildClassSet(persistenceUnitInfo, Thread.currentThread().getContextClassLoader());
            Map mergedProperties = EntityManagerFactoryProvider.mergeMaps(m, persistenceUnitInfo.getProperties());
            String weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.weaving", mergedProperties, null);
            if (globalInstrumentation == null) {
                if (weaving == null) {
                    mergedProperties.put("toplink.weaving", "false");
                } else if (weaving.equalsIgnoreCase("true")) {
                    throw new PersistenceException(EntityManagerSetupException.wrongWeavingPropertyValue());
                }
            }
            if (weaving != null && weaving.equalsIgnoreCase("false")) {
                this.shouldCreateInternalLoader = false;
            }
            tempLoader = this.createTempLoader(tempLoaderSet);
            persistenceUnitInfo.setNewTempClassLoader(tempLoader);
            persistenceUnitInfo.setClassLoader(JavaSECMPInitializer.getMainLoader());
            if (emSetupImpl == null) {
                emSetupImpl = new EntityManagerSetupImpl();
                EntityManagerFactoryProvider.addEntityManagerSetupImpl(persistenceUnitInfo.getPersistenceUnitRootUrl() + persistenceUnitInfo.getPersistenceUnitName(), emSetupImpl);
            }
            AbstractSessionLog.getLog().log(2, "cmp_init_invoke_predeploy", persistenceUnitInfo.getPersistenceUnitName());
            final ClassTransformer transformer = emSetupImpl.predeploy(persistenceUnitInfo, mergedProperties);
            if (transformer != null && globalInstrumentation != null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", persistenceUnitInfo.getPersistenceUnitName());
                globalInstrumentation.addTransformer(new ClassFileTransformer(){

                    @Override
                    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                        return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                    }
                });
            } else if (transformer == null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
            } else if (globalInstrumentation == null) {
                AbstractSessionLog.getLog().log(2, "cmp_init_globalInstrumentation_is_null");
            }
            return true;
        }
        return false;
    }

    protected ClassLoader createTempLoader(Collection col) {
        return this.createTempLoader(col, true);
    }

    protected ClassLoader createTempLoader(Collection col, boolean shouldOverrideLoadClassForCollectionMembers) {
        if (!this.shouldCreateInternalLoader) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof URLClassLoader)) {
            return currentLoader;
        }
        URL[] urlPath = ((URLClassLoader)currentLoader).getURLs();
        TempEntityLoader tempLoader = new TempEntityLoader(urlPath, currentLoader, col, shouldOverrideLoadClassForCollectionMembers);
        AbstractSessionLog.getLog().log(2, "cmp_init_tempLoader_created", tempLoader);
        AbstractSessionLog.getLog().log(2, "cmp_init_shouldOverrideLoadClassForCollectionMembers", new Boolean(shouldOverrideLoadClassForCollectionMembers));
        return tempLoader;
    }

    public static ClassLoader getMainLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected void initPersistenceUnits(Archive archive, Map m) {
        for (SEPersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.sessionClassLoader)) {
            this.callPredeploy(persistenceUnitInfo, m);
        }
    }

    public void initialize(Map m) {
        this.sessionClassLoader = JavaSECMPInitializer.getMainLoader();
        Set<Archive> pars = PersistenceUnitProcessor.findPersistenceArchives();
        for (Archive archive : pars) {
            AbstractSessionLog.getLog().log(2, "cmp_init_initialize", archive);
            this.initPersistenceUnits(archive, m);
        }
    }

    protected static void initializeFromAgent(Instrumentation instrumentation) throws Exception {
        AbstractSessionLog.getLog().setLevel(JavaSECMPInitializer.getTopLinkLoggingLevel());
        globalInstrumentation = instrumentation;
        javaSECMPInitializer = new JavaSECMPInitializer();
        javaSECMPInitializer.initialize(new HashMap());
    }

    protected Set loadEntityClasses(Collection entityNames, ClassLoader classLoader) {
        HashSet entityClasses = new HashSet();
        AbstractSessionLog.getLog().log(2, "cmp_loading_entities_using_loader", classLoader);
        for (String entityClassName : entityNames) {
            try {
                entityClasses.add(classLoader.loadClass(entityClassName));
            }
            catch (ClassNotFoundException cnfEx) {
                throw ValidationException.entityClassNotFound(entityClassName, classLoader, cnfEx);
            }
        }
        return entityClasses;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TempEntityLoader
    extends URLClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.getParent().getResources(name);
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
            super(urls, parent);
            this.classNames = classNames;
            this.shouldOverrideLoadClassForCollectionMembers = shouldOverrideLoadClassForCollectionMembers;
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames) {
            this(urls, parent, classNames, true);
        }

        protected boolean shouldOverrideLoadClass(String name) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(name);
            }
            return !name.startsWith("java.") && !name.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(name));
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

