/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.sessions.Record;

public abstract class AbstractRecord
implements Record,
Cloneable,
Serializable,
Map {
    protected Vector fields;
    protected Vector values;
    protected DatabaseField lookupField;
    public static final NoEntry noEntry = new NoEntry();

    public AbstractRecord() {
        this.fields = new Vector();
        this.values = new Vector();
    }

    public AbstractRecord(int initialCapacity) {
        this.fields = new Vector(initialCapacity);
        this.values = new Vector(initialCapacity);
    }

    public AbstractRecord(Vector fields, Vector values) {
        this.fields = fields;
        this.values = values;
    }

    public void add(DatabaseField key, Object value) {
        this.getFields().addElement(key);
        this.getValues().addElement(value);
    }

    public void clear() {
        this.fields = new Vector();
        this.values = new Vector();
    }

    public Object clone() {
        try {
            AbstractRecord clone = (AbstractRecord)super.clone();
            clone.setFields((Vector)this.getFields().clone());
            clone.setValues((Vector)this.getValues().clone());
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.containsKey((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.containsKey((DatabaseField)key);
        }
        return false;
    }

    public boolean containsKey(String fieldName) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(fieldName);
        } else {
            this.lookupField.resetQualifiedName(fieldName);
        }
        return this.containsKey(this.lookupField);
    }

    public boolean containsKey(DatabaseField key) {
        DatabaseField field;
        int index = key.getIndex();
        if (index >= 0 && index < this.getFields().size() && ((field = (DatabaseField)this.getFields().elementAt(index)) == key || field.equals(key))) {
            return true;
        }
        return this.getFields().contains(key);
    }

    public boolean containsValue(Object value) {
        return this.getValues().contains(value);
    }

    public Enumeration elements() {
        return this.getValues().elements();
    }

    public Set entrySet() {
        int size = this.size();
        HashMap tempMap = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            tempMap.put(this.getFields().elementAt(i), this.getValues().elementAt(i));
        }
        return tempMap.entrySet();
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.get((DatabaseField)key);
        }
        return null;
    }

    public Object get(String fieldName) {
        Object value = this.getIndicatingNoEntry(fieldName);
        if (value == noEntry) {
            return null;
        }
        return value;
    }

    public Object getIndicatingNoEntry(String fieldName) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(fieldName);
        } else {
            this.lookupField.resetQualifiedName(fieldName);
        }
        return this.getIndicatingNoEntry(this.lookupField);
    }

    public Object get(DatabaseField key) {
        Object value = this.getIndicatingNoEntry(key);
        if (value == noEntry) {
            return null;
        }
        return value;
    }

    public Object getValues(DatabaseField key) {
        return this.get(key);
    }

    public Object getValues(String key) {
        return this.get(key);
    }

    public Object getIndicatingNoEntry(DatabaseField key) {
        DatabaseField field;
        int index = key.getIndex();
        if (index >= 0 && index < this.fields.size() && ((field = (DatabaseField)this.fields.elementAt(index)) == key || field.equals(key))) {
            return this.values.elementAt(index);
        }
        index = this.fields.indexOf(key);
        if (index >= 0) {
            if (key.getIndex() == -1) {
                key.setIndex(index);
            }
            return this.values.elementAt(index);
        }
        return noEntry;
    }

    public DatabaseField getField(DatabaseField key) {
        DatabaseField field;
        int index = key.getIndex();
        if (index >= 0 && index < this.getFields().size() && ((field = (DatabaseField)this.getFields().elementAt(index)) == key || field.equals(key))) {
            return field;
        }
        for (index = 0; index < this.getFields().size(); ++index) {
            field = (DatabaseField)this.getFields().elementAt(index);
            if (field != key && !field.equals(key)) continue;
            return field;
        }
        return null;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration keys() {
        return this.getFields().elements();
    }

    public Set keySet() {
        return new HashSet(this.getFields());
    }

    public void mergeFrom(AbstractRecord row) {
        for (int index = 0; index < row.size(); ++index) {
            this.put(row.getFields().get(index), row.getValues().get(index));
        }
    }

    public Object put(Object key, Object value) throws ValidationException {
        if (key instanceof String) {
            return this.put((String)key, value);
        }
        if (key instanceof DatabaseField) {
            return this.put((DatabaseField)key, value);
        }
        throw ValidationException.onlyFieldsAreValidKeysForDatabaseRows();
    }

    public Object put(String key, Object value) {
        return this.put(new DatabaseField(key), value);
    }

    public Object put(DatabaseField key, Object value) {
        int index = this.getFields().indexOf(key);
        if (index >= 0) {
            Object oldValue = this.getValues().elementAt(index);
            this.replaceAt(value, index);
            return oldValue;
        }
        this.add(key, value);
        return null;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        if (key instanceof String) {
            return this.remove((String)key);
        }
        if (key instanceof DatabaseField) {
            return this.remove((DatabaseField)key);
        }
        return null;
    }

    public Object remove(String fieldName) {
        return this.remove(new DatabaseField(fieldName));
    }

    public Object remove(DatabaseField key) {
        int index = this.getFields().indexOf(key);
        if (index >= 0) {
            this.getFields().removeElementAt(index);
            Object value = this.getValues().elementAt(index);
            this.getValues().removeElementAt(index);
            return value;
        }
        return null;
    }

    public void replaceAt(Object value, int index) {
        this.getValues().setElementAt(value, index);
    }

    protected void setFields(Vector fields) {
        this.fields = fields;
    }

    protected void setValues(Vector values) {
        this.values = values;
    }

    public int size() {
        return this.getFields().size();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("(");
        for (int index = 0; index < this.getFields().size(); ++index) {
            writer.write(Helper.cr());
            writer.write("\t");
            writer.write(String.valueOf(this.getFields().elementAt(index)));
            writer.write(" => ");
            writer.write(String.valueOf(this.getValues().elementAt(index)));
        }
        writer.write(")");
        return writer.toString();
    }

    public Collection values() {
        return this.getValues();
    }

    public static class NoEntry {
        private NoEntry() {
        }
    }
}

