/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.security;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedNewInstanceFromClass;
import oracle.toplink.essentials.internal.security.Securable;

public class SecurableObjectHolder {
    private static final String JCE_ENCRYPTION_CLASS_NAME = "oracle.toplink.essentials.internal.security.JCEEncryptor";
    private String m_securableClassName;
    private Securable m_securableObject = null;

    public SecurableObjectHolder() {
        this(null);
    }

    public SecurableObjectHolder(String securableClassName) {
        this.m_securableClassName = securableClassName;
    }

    public void setEncryptionClassName(String securableClassName) {
        this.m_securableClassName = securableClassName;
    }

    public Securable getSecurableObject() {
        if (this.m_securableObject == null) {
            this.initSecurableObject();
        }
        return this.m_securableObject;
    }

    public boolean hasSecurableObject() {
        return this.m_securableObject != null;
    }

    private void initSecurableObject() {
        block7: {
            boolean initPassThroughEncryptor = false;
            if (this.m_securableClassName == null) {
                initPassThroughEncryptor = true;
                this.m_securableClassName = JCE_ENCRYPTION_CLASS_NAME;
            }
            try {
                ConversionManager cm = ConversionManager.getDefaultManager();
                Class securableClass = (Class)cm.convertObject(this.m_securableClassName, Class.class);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.m_securableObject = (Securable)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(securableClass));
                        break block7;
                    }
                    catch (PrivilegedActionException exception) {
                        throw exception.getException();
                    }
                }
                this.m_securableObject = (Securable)PrivilegedAccessHelper.newInstanceFromClass(securableClass);
            }
            catch (Throwable e) {
                if (initPassThroughEncryptor) {
                    this.m_securableObject = new PassThroughEncryptor();
                }
                throw ValidationException.invalidEncryptionClass(this.m_securableClassName, e);
            }
        }
    }

    private class PassThroughEncryptor
    implements Securable {
        private PassThroughEncryptor() {
        }

        public String encryptPassword(String pswd) {
            return pswd;
        }

        public String decryptPassword(String encryptedPswd) {
            return encryptedPswd;
        }
    }
}

