/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.descriptors.DescriptorQueryManager;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.AggregateChangeRecord;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.ObjectCopyingPolicy;

public abstract class AggregateMapping
extends DatabaseMapping {
    protected Class referenceClass;
    protected String referenceClassName;
    protected ClassDescriptor referenceDescriptor;

    protected DeleteObjectQuery buildAggregateDeleteQuery(WriteObjectQuery sourceQuery, Object sourceAttributeValue) {
        DeleteObjectQuery aggregateQuery = new DeleteObjectQuery();
        this.buildAggregateModifyQuery(sourceQuery, aggregateQuery, sourceAttributeValue);
        return aggregateQuery;
    }

    protected void buildAggregateModifyQuery(ObjectLevelModifyQuery sourceQuery, ObjectLevelModifyQuery aggregateQuery, Object sourceAttributeValue) {
        if (sourceQuery.getSession().isUnitOfWork()) {
            Object backupAttributeValue = this.getAttributeValueFromBackupClone(sourceQuery.getBackupClone());
            if (backupAttributeValue == null) {
                backupAttributeValue = this.getObjectBuilder(sourceAttributeValue, sourceQuery.getSession()).buildNewInstance();
            }
            aggregateQuery.setBackupClone(backupAttributeValue);
        }
        aggregateQuery.setCascadePolicy(sourceQuery.getCascadePolicy());
        aggregateQuery.setObject(sourceAttributeValue);
        aggregateQuery.setTranslationRow(sourceQuery.getTranslationRow());
        aggregateQuery.setSession(sourceQuery.getSession());
        aggregateQuery.setProperties(sourceQuery.getProperties());
    }

    protected WriteObjectQuery buildAggregateWriteQuery(WriteObjectQuery sourceQuery, Object sourceAttributeValue) {
        WriteObjectQuery aggregateQuery = new WriteObjectQuery();
        this.buildAggregateModifyQuery(sourceQuery, aggregateQuery, sourceAttributeValue);
        return aggregateQuery;
    }

    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(clone);
        this.setAttributeValueInObject(backup, this.buildBackupClonePart(attributeValue, unitOfWork));
    }

    protected Object buildBackupClonePart(Object attributeValue, UnitOfWorkImpl unitOfWork) {
        if (attributeValue == null) {
            return null;
        }
        return this.getObjectBuilder(attributeValue, unitOfWork).buildBackupClone(attributeValue, unitOfWork);
    }

    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinedAttributeManager) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        this.setAttributeValueInObject(clone, this.buildClonePart(original, attributeValue, unitOfWork));
    }

    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        Object cloneAttributeValue = this.valueFromRow(databaseRow, joinManager, sourceQuery, executionSession);
        this.setAttributeValueInObject(clone, cloneAttributeValue);
    }

    protected Object buildClonePart(Object original, Object attributeValue, UnitOfWorkImpl unitOfWork) {
        if (attributeValue == null) {
            return null;
        }
        if (unitOfWork.isOriginalNewObject(original)) {
            unitOfWork.addNewAggregate(attributeValue);
        }
        if (unitOfWork.isClassReadOnly(attributeValue.getClass())) {
            return attributeValue;
        }
        ObjectBuilder aggregateObjectBuilder = this.getObjectBuilder(attributeValue, unitOfWork);
        Object clonedAttributeValue = aggregateObjectBuilder.instantiateWorkingCopyClone(attributeValue, unitOfWork);
        aggregateObjectBuilder.populateAttributesForClone(attributeValue, clonedAttributeValue, unitOfWork, null);
        return clonedAttributeValue;
    }

    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        this.setAttributeValueInObject(copy, this.buildCopyOfAttributeValue(attributeValue, policy));
    }

    protected Object buildCopyOfAttributeValue(Object attributeValue, ObjectCopyingPolicy policy) {
        if (attributeValue == null) {
            return null;
        }
        return this.getObjectBuilder(attributeValue, policy.getSession()).copyObject(attributeValue, policy);
    }

    protected Object buildNewMergeInstanceOf(Object sourceAttributeValue, AbstractSession session) {
        return this.getObjectBuilder(sourceAttributeValue, session).buildNewInstance();
    }

    protected boolean compareAttributeValues(Object attributeValue1, Object attributeValue2, AbstractSession session) {
        if (attributeValue1 == null && attributeValue2 == null) {
            return true;
        }
        if (attributeValue1 == null || attributeValue2 == null) {
            return false;
        }
        if (attributeValue1.getClass() != attributeValue2.getClass()) {
            return false;
        }
        return this.getObjectBuilder(attributeValue1, session).compareObjects(attributeValue1, attributeValue2, session);
    }

    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = this.getAttributeValueFromObject(clone);
        Object backupAttribute = null;
        if (!owner.isNew()) {
            backupAttribute = this.getAttributeValueFromObject(backup);
            if (cloneAttribute == null && backupAttribute == null) {
                return null;
            }
            if (cloneAttribute != null && backupAttribute != null && !cloneAttribute.getClass().equals(backupAttribute.getClass())) {
                backupAttribute = null;
            }
        }
        AggregateChangeRecord changeRecord = new AggregateChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        if (cloneAttribute == null) {
            changeRecord.setChangedObject(null);
            return changeRecord;
        }
        ObjectBuilder builder = this.getObjectBuilder(cloneAttribute, session);
        ObjectChangeSet initialChanges = builder.createObjectChangeSet(cloneAttribute, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), backupAttribute == null, session);
        ObjectChangeSet changeSet = builder.compareForChange(cloneAttribute, backupAttribute, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
        if (changeSet == null) {
            if (initialChanges.isNew()) {
                changeSet = initialChanges;
            } else {
                return null;
            }
        }
        changeRecord.setChangedObject(changeSet);
        return changeRecord;
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        return this.compareAttributeValues(this.getAttributeValueFromObject(firstObject), this.getAttributeValueFromObject(secondObject), session);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class referenceClass;
        block5: {
            referenceClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exception.getException());
                    }
                }
                referenceClass = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exc);
            }
        }
        this.setReferenceClass(referenceClass);
    }

    protected void executeEvent(int eventCode, ObjectLevelModifyQuery query) {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor(query.getObject(), query.getSession());
        if (referenceDescriptor.getEventManager().hasAnyEventListeners()) {
            referenceDescriptor.getEventManager().executeEvent(new DescriptorEvent(eventCode, query));
        }
    }

    protected Object getAttributeValueFromBackupClone(Object backupClone) {
        return this.getAttributeValueFromObject(backupClone);
    }

    protected ObjectBuilder getObjectBuilderForClass(Class javaClass, AbstractSession session) {
        return this.getReferenceDescriptor(javaClass, session).getObjectBuilder();
    }

    protected ObjectBuilder getObjectBuilder(Object attributeValue, AbstractSession session) {
        return this.getReferenceDescriptor(attributeValue, session).getObjectBuilder();
    }

    protected DescriptorQueryManager getQueryManager(Object attributeValue, AbstractSession session) {
        return this.getReferenceDescriptor(attributeValue, session).getQueryManager();
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public ClassDescriptor getReferenceDescriptor() {
        return this.referenceDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor().getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subclassDescriptor = session.getDescriptor(theClass);
        if (subclassDescriptor == null) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subclassDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Object attributeValue, AbstractSession session) {
        if (attributeValue == null) {
            return this.getReferenceDescriptor();
        }
        return this.getReferenceDescriptor(attributeValue.getClass(), session);
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.setReferenceDescriptor(session.getDescriptor(this.getReferenceClass()));
        ClassDescriptor refDescriptor = this.getReferenceDescriptor();
        if (refDescriptor == null) {
            session.getIntegrityChecker().handleError(DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this));
        }
        if (refDescriptor.isAggregateDescriptor()) {
            refDescriptor.checkInheritanceTreeAggregateSettings(session, this);
        } else {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getReferenceClass().getName(), this));
        }
    }

    public boolean isAggregateMapping() {
        return true;
    }

    public void iterate(DescriptorIterator iterator) {
        this.iterateOnAttributeValue(iterator, this.getAttributeValueFromObject(iterator.getVisitedParent()));
    }

    protected void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        iterator.iterateForAggregateMapping(attributeValue, this, this.getReferenceDescriptor(attributeValue, iterator.getSession()));
    }

    protected void mergeAttributeValue(Object targetAttributeValue, boolean isTargetUnInitialized, Object sourceAttributeValue, MergeManager mergeManager) {
        if (mergeManager.getSession().isClassReadOnly(sourceAttributeValue.getClass())) {
            return;
        }
        if (mergeManager.getSession().isClassReadOnly(targetAttributeValue.getClass())) {
            return;
        }
        this.getObjectBuilder(sourceAttributeValue, mergeManager.getSession()).mergeIntoObject(targetAttributeValue, isTargetUnInitialized, sourceAttributeValue, mergeManager);
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        ObjectChangeSet aggregateChangeSet = (ObjectChangeSet)((AggregateChangeRecord)changeRecord).getChangedObject();
        if (aggregateChangeSet == null) {
            this.setAttributeValueInObject(target, null);
            return;
        }
        Object sourceAggregate = null;
        if (source != null) {
            sourceAggregate = this.getAttributeValueFromObject(source);
        }
        ObjectBuilder objectBuilder = this.getObjectBuilderForClass(aggregateChangeSet.getClassType(mergeManager.getSession()), mergeManager.getSession());
        Object targetAggregate = this.getAttributeValueFromObject(target);
        if (targetAggregate == null) {
            targetAggregate = objectBuilder.buildNewInstance();
        } else if (sourceAggregate != null && sourceAggregate.getClass() != targetAggregate.getClass()) {
            targetAggregate = objectBuilder.buildNewInstance();
        }
        objectBuilder.mergeChangesIntoObject(targetAggregate, aggregateChangeSet, sourceAggregate, mergeManager);
        this.setAttributeValueInObject(target, targetAggregate);
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        Object sourceAttributeValue = this.getAttributeValueFromObject(source);
        if (sourceAttributeValue == null) {
            this.setAttributeValueInObject(target, null);
            return;
        }
        Object targetAttributeValue = this.getAttributeValueFromObject(target);
        if (targetAttributeValue == null) {
            targetAttributeValue = this.buildNewMergeInstanceOf(sourceAttributeValue, mergeManager.getSession());
            this.mergeAttributeValue(targetAttributeValue, true, sourceAttributeValue, mergeManager);
            this.getDescriptor().getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), this.getAttributeValueFromObject(target), targetAttributeValue);
        } else {
            this.mergeAttributeValue(targetAttributeValue, isTargetUnInitialized, sourceAttributeValue, mergeManager);
        }
        this.setAttributeValueInObject(target, targetAttributeValue);
    }

    public void postDelete(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postDeleteAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    protected void postDeleteAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        DeleteObjectQuery aggregateQuery = this.buildAggregateDeleteQuery(query, attributeValue);
        this.getQueryManager(attributeValue, query.getSession()).postDelete(aggregateQuery);
        this.executeEvent(3, aggregateQuery);
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postInsertAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    protected void postInsertAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        WriteObjectQuery aggregateQuery = this.buildAggregateWriteQuery(query, attributeValue);
        this.getQueryManager(attributeValue, query.getSession()).postInsert(aggregateQuery);
        this.executeEvent(5, aggregateQuery);
        this.executeEvent(1, aggregateQuery);
    }

    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postUpdateAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    protected void postUpdateAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        ObjectChangeSet changeSet = null;
        UnitOfWorkChangeSet uowChangeSet = null;
        if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
            uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
            changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(attributeValue);
        }
        WriteObjectQuery aggregateQuery = this.buildAggregateWriteQuery(query, attributeValue);
        aggregateQuery.setObjectChangeSet(changeSet);
        this.getQueryManager(attributeValue, query.getSession()).postUpdate(aggregateQuery);
        this.executeEvent(7, aggregateQuery);
        this.executeEvent(1, aggregateQuery);
    }

    public void preDelete(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preDeleteAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    protected void preDeleteAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        DeleteObjectQuery aggregateQuery = this.buildAggregateDeleteQuery(query, attributeValue);
        this.executeEvent(2, aggregateQuery);
        this.getQueryManager(attributeValue, query.getSession()).preDelete(aggregateQuery);
    }

    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preInsertAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    protected void preInsertAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        WriteObjectQuery aggregateQuery = this.buildAggregateWriteQuery(query, attributeValue);
        this.getQueryManager(attributeValue, query.getSession()).preInsert(aggregateQuery);
    }

    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preUpdateAttributeValue(query, this.getAttributeValueFromObject(query.getObject()));
        }
    }

    protected void preUpdateAttributeValue(WriteObjectQuery query, Object attributeValue) throws DatabaseException, OptimisticLockException {
        if (attributeValue == null) {
            return;
        }
        WriteObjectQuery aggregateQuery = this.buildAggregateWriteQuery(query, attributeValue);
        ObjectChangeSet changeSet = null;
        UnitOfWorkChangeSet uowChangeSet = null;
        if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
            uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
            changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(aggregateQuery.getObject());
        }
        aggregateQuery.setObjectChangeSet(changeSet);
        if (changeSet == null) {
            this.executeEvent(0, aggregateQuery);
            this.executeEvent(6, aggregateQuery);
        }
        this.getQueryManager(attributeValue, query.getSession()).preUpdate(aggregateQuery);
    }

    public void setReferenceClass(Class aClass) {
        this.referenceClass = aClass;
    }

    public void setReferenceClassName(String aClassName) {
        this.referenceClassName = aClassName;
    }

    protected void setReferenceDescriptor(ClassDescriptor aDescriptor) {
        this.referenceDescriptor = aDescriptor;
    }

    public void updateChangeRecord(Object sourceClone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        AggregateChangeRecord changeRecord = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new AggregateChangeRecord(objectChangeSet);
            changeRecord.setAttribute(this.getAttributeName());
            changeRecord.setMapping(this);
            objectChangeSet.addChange(changeRecord);
        }
        if (sourceClone.getClass().equals(objectChangeSet.getClassType(uow))) {
            ClassDescriptor referenceDescriptor = this.getReferenceDescriptor(newValue, (AbstractSession)uow);
            if (newValue == null) {
                changeRecord.setChangedObject(null);
                return;
            }
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet();
            ObjectChangeSet aggregateChangeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(newValue);
            if (aggregateChangeSet != null) {
                aggregateChangeSet.clear();
            }
            changeRecord.setChangedObject(referenceDescriptor.getObjectChangePolicy().createObjectChangeSetThroughComparison(newValue, oldValue, uowChangeSet, oldValue == null, uow, referenceDescriptor));
            referenceDescriptor.getObjectChangePolicy().setChangeSetOnListener((ObjectChangeSet)changeRecord.getChangedObject(), newValue);
        } else {
            changeRecord.setChangedObject(this.referenceDescriptor.getObjectChangePolicy().createObjectChangeSetThroughComparison(sourceClone, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), true, uow, this.referenceDescriptor));
        }
    }

    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        return this.verifyDeleteOfAttributeValue(this.getAttributeValueFromObject(object), session);
    }

    protected boolean verifyDeleteOfAttributeValue(Object attributeValue, AbstractSession session) throws DatabaseException {
        if (attributeValue == null) {
            return true;
        }
        Enumeration<DatabaseMapping> mappings = this.getReferenceDescriptor(attributeValue, session).getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (mapping.verifyDelete(attributeValue, session)) continue;
            return false;
        }
        return true;
    }
}

