/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.ForUpdateClause;
import oracle.toplink.essentials.internal.expressions.ObjectExpression;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;

public class ForUpdateOfClause
extends ForUpdateClause {
    protected Vector lockedExpressions;

    public void addLockedExpression(ObjectExpression expression) {
        this.getLockedExpressions().addElement(expression);
    }

    public Vector getLockedExpressions() {
        if (this.lockedExpressions == null) {
            this.lockedExpressions = NonSynchronizedVector.newInstance();
        }
        return this.lockedExpressions;
    }

    public boolean isForUpdateOfClause() {
        return true;
    }

    public boolean isReferenceClassLocked() {
        if (this.lockedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.lockedExpressions.size(); ++i) {
            if (!((Expression)this.lockedExpressions.elementAt(i)).isExpressionBuilder()) continue;
            return true;
        }
        return false;
    }

    public void setLockedExpressions(Vector lockedExpressions) {
        this.lockedExpressions = lockedExpressions;
    }

    public void setLockMode(short lockMode) {
        this.lockMode = lockMode;
    }

    public void printSQL(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        ExpressionBuilder clonedBuilder = statement.getBuilder();
        printer.printString(printer.getSession().getPlatform().getSelectForUpdateOfString());
        printer.setIsFirstElementPrinted(false);
        Enumeration enumtr = this.getLockedExpressions().elements();
        while (enumtr.hasMoreElements()) {
            ObjectExpression next = (ObjectExpression)enumtr.nextElement();
            next = (ObjectExpression)next.rebuildOn(clonedBuilder);
            next.writeForUpdateOfFields(printer, statement);
        }
        if (this.lockMode == 2) {
            printer.printString(printer.getSession().getPlatform().getSelectForUpdateNoWaitString());
        }
    }
}

