/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.sequencing.DefaultSequence;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sequencing.TableSequence;
import oracle.toplink.essentials.tools.schemaframework.SequenceDefinition;
import oracle.toplink.essentials.tools.schemaframework.TableDefinition;

public class TableSequenceDefinition
extends SequenceDefinition {
    public TableSequenceDefinition(Sequence sequence) {
        super(sequence);
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("INSERT INTO ");
            writer.write(this.getSequenceTableName());
            writer.write("(" + this.getSequenceNameFieldName());
            writer.write(", " + this.getSequenceCounterFieldName());
            writer.write(") values (");
            writer.write("'" + this.getName() + "', " + Integer.toString(this.sequence.getInitialValue() - 1) + ")");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DELETE FROM ");
            writer.write(this.getSequenceTableName());
            writer.write(" WHERE " + this.getSequenceNameFieldName());
            writer.write(" = '" + this.getName() + "'");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public boolean checkIfExist(AbstractSession session) throws DatabaseException {
        Vector results = session.executeSelectingCall(new SQLCall("SELECT * FROM " + this.getSequenceTableName() + " WHERE " + this.getSequenceNameFieldName() + " = '" + this.getName() + "'"));
        return !results.isEmpty();
    }

    public String getSequenceTableName() {
        return this.getTableSequence().getTableName();
    }

    public String getSequenceCounterFieldName() {
        return this.getTableSequence().getCounterFieldName();
    }

    public String getSequenceNameFieldName() {
        return this.getTableSequence().getNameFieldName();
    }

    public TableDefinition buildTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName(this.getSequenceTableName());
        definition.addPrimaryKeyField(this.getSequenceNameFieldName(), String.class, 50);
        definition.addField(this.getSequenceCounterFieldName(), BigDecimal.class);
        return definition;
    }

    protected TableSequence getTableSequence() {
        if (this.sequence instanceof TableSequence) {
            return (TableSequence)this.sequence;
        }
        return (TableSequence)((DefaultSequence)this.sequence).getDefaultSequence();
    }
}

