/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.indirection.IndirectContainer;
import oracle.toplink.essentials.internal.expressions.ForUpdateClause;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.queryframework.FetchGroup;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;

public abstract class ObjectBuildingQuery
extends ReadQuery {
    protected Class referenceClass;
    protected String referenceClassName;
    protected boolean shouldRefreshIdentityMapResult = false;
    protected boolean shouldRefreshRemoteIdentityMapResult;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected boolean shouldProcessResultsInUnitOfWork = true;
    protected ForUpdateClause lockingClause;
    public static final short NO_LOCK = 0;
    public static final short LOCK = 1;
    public static final short LOCK_NOWAIT = 2;
    public static final short DEFAULT_LOCK_MODE = -1;
    protected boolean isPrePrepared;
    protected long executionTime = 0L;
    protected boolean shouldUseExclusiveConnection = false;
    public static final String LOCK_RESULT_PROPERTY = "LOCK_RESULT";
    protected boolean wasDefaultLockMode = false;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class referenceClass;
        block5: {
            super.convertClassNamesToClasses(classLoader);
            referenceClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exception.getException());
                    }
                }
                referenceClass = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), exc);
            }
        }
        this.setReferenceClass(referenceClass);
    }

    protected boolean wasDefaultLockMode() {
        return this.wasDefaultLockMode;
    }

    protected void setWasDefaultLockMode(boolean wasDefaultLockMode) {
        this.wasDefaultLockMode = wasDefaultLockMode;
    }

    public void dontRefreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(false);
    }

    public void dontRefreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(false);
    }

    public FetchGroup getFetchGroup() {
        return null;
    }

    public short getLockMode() {
        if (this.lockingClause == null) {
            return -1;
        }
        return this.lockingClause.getLockMode();
    }

    public List getDataResults() {
        return null;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public boolean hasPartialAttributeExpressions() {
        return false;
    }

    public boolean isLockQuery() {
        return this.getLockMode() > 0;
    }

    public boolean isObjectBuildingQuery() {
        return true;
    }

    protected boolean isRegisteringResults() {
        return this.shouldRegisterResultsInUnitOfWork() && this.getDescriptor().shouldRegisterResultsInUnitOfWork() || this.isLockQuery();
    }

    public void refreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(true);
    }

    public void refreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(true);
    }

    public Object registerIndividualResult(Object result, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRows, JoinedAttributeManager joinManager) {
        Object clone = null;
        if (buildDirectlyFromRows) {
            return this.buildObject((AbstractRecord)result);
        }
        if (!this.isRegisteringResults()) {
            clone = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(result);
            if (clone == null) {
                clone = result;
            }
        } else {
            clone = unitOfWork.registerExistingObject(result);
        }
        if (this.shouldRefreshIdentityMapResult()) {
            if (unitOfWork.getParent().getIdentityMapAccessor().containsObjectInIdentityMap(clone)) {
                if (this.shouldCascadeAllParts()) {
                    unitOfWork.deepRevertObject(clone);
                } else if (this.shouldCascadePrivateParts()) {
                    unitOfWork.revertObject(clone);
                } else if (this.shouldCascadeByMapping()) {
                    unitOfWork.revertObject(clone, 4);
                } else if (!this.shouldCascadeParts()) {
                    unitOfWork.shallowRevertObject(clone);
                }
            } else if (this.shouldCascadeAllParts()) {
                unitOfWork.deepMergeClone(result);
            } else if (this.shouldCascadePrivateParts()) {
                unitOfWork.mergeClone(result);
            } else if (this.shouldCascadeByMapping()) {
                unitOfWork.mergeClone(result, 4);
            } else if (!this.shouldCascadeParts()) {
                unitOfWork.shallowMergeClone(result);
            }
        }
        this.recordCloneForPessimisticLocking(clone, unitOfWork);
        if (joinManager != null && joinManager.hasJoinedAttributeExpressions()) {
            this.triggerJoinExpressions(unitOfWork, joinManager, clone);
        }
        return clone;
    }

    private void triggerJoinExpressions(UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinManager, Object clone) {
        List joinExpressions = joinManager.getJoinedAttributeExpressions();
        int size = joinExpressions.size();
        if (size == 0 || clone == null) {
            return;
        }
        ClassDescriptor descriptor = unitOfWork.getDescriptor(clone);
        for (int index = 0; index < size; ++index) {
            QueryKeyExpression queryKeyExpression;
            Object attributeValue;
            DatabaseMapping mapping = descriptor.getMappingForAttributeName((String)joinManager.getJoinedAttributes().get(index));
            if (mapping == null || (attributeValue = mapping.getRealAttributeValueFromObject(clone, unitOfWork)) == null) continue;
            if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).getIndirectionPolicy().usesTransparentIndirection()) {
                ((IndirectContainer)attributeValue).getValueHolder().getValue();
            }
            if ((queryKeyExpression = (QueryKeyExpression)joinExpressions.get(index)).getBaseExpression().isExpressionBuilder()) continue;
            ObjectLevelReadQuery nestedQuery = null;
            if (joinManager.getJoinedMappingQueries_() != null) {
                nestedQuery = (ObjectLevelReadQuery)joinManager.getJoinedMappingQueries_().get(mapping);
            }
            if (nestedQuery == null || nestedQuery.getJoinedAttributeManager() == null) continue;
            if (!mapping.isCollectionMapping()) {
                this.triggerJoinExpressions(unitOfWork, nestedQuery.getJoinedAttributeManager(), attributeValue);
                continue;
            }
            ContainerPolicy cp = ((CollectionMapping)mapping).getContainerPolicy();
            Object iterator = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iterator)) {
                this.triggerJoinExpressions(unitOfWork, nestedQuery.getJoinedAttributeManager(), cp.next(iterator, unitOfWork));
            }
        }
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public void setLockMode(short lockMode) {
        this.lockingClause = ForUpdateClause.newInstance(lockMode);
    }

    public void setReferenceClass(Class aClass) {
        this.referenceClass = aClass;
        this.setIsPrepared(false);
    }

    public void setReferenceClassName(String aClass) {
        this.referenceClassName = aClass;
        this.setIsPrepared(false);
    }

    public void setShouldRefreshIdentityMapResult(boolean shouldRefreshIdentityMapResult) {
        this.shouldRefreshIdentityMapResult = shouldRefreshIdentityMapResult;
        if (shouldRefreshIdentityMapResult) {
            this.setShouldRefreshRemoteIdentityMapResult(true);
        }
    }

    public void setShouldRefreshRemoteIdentityMapResult(boolean shouldRefreshIdentityMapResult) {
        this.shouldRefreshRemoteIdentityMapResult = shouldRefreshIdentityMapResult;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean shouldRegisterResultsInUnitOfWork) {
        this.shouldRegisterResultsInUnitOfWork = shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldReadAllMappings() {
        return true;
    }

    public boolean shouldReadMapping(DatabaseMapping mapping) {
        return true;
    }

    public boolean shouldRefreshIdentityMapResult() {
        return this.shouldRefreshIdentityMapResult;
    }

    public boolean shouldRefreshRemoteIdentityMapResult() {
        return this.shouldRefreshRemoteIdentityMapResult;
    }

    public String toString() {
        if (this.getReferenceClass() == null) {
            return super.toString();
        }
        return Helper.getShortClassName(this.getClass()) + "(" + this.getReferenceClass().getName() + ")";
    }

    public void setShouldProcessResultsInUnitOfWork(boolean processResultsInUnitOfWork) {
        this.shouldProcessResultsInUnitOfWork = processResultsInUnitOfWork;
    }

    public boolean shouldProcessResultsInUnitOfWork() {
        return this.shouldProcessResultsInUnitOfWork;
    }

    public boolean isAttributeJoined(ClassDescriptor mappingDescriptor, String attributeName) {
        return false;
    }

    public boolean isClonePessimisticLocked(Object clone, UnitOfWorkImpl uow) {
        return false;
    }

    public void recordCloneForPessimisticLocking(Object clone, UnitOfWorkImpl uow) {
        if (this.isLockQuery() && this.lockingClause.isReferenceClassLocked()) {
            uow.addPessimisticLockedClone(clone);
        }
    }

    public boolean isDefaultLock() {
        return this.lockingClause == null;
    }
}

