/*
 * Decompiled with CFR 0.152.
 */
package uk.co.grahamcox.spring.cli;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import uk.co.grahamcox.spring.cli.Arguments;

public class CliRunner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final String RUNNER_DEFAULT_NAME = "runner";
    private Properties properties = new Properties();
    private String[] args = new String[0];

    public void addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void setArguments(String[] args) {
        this.args = args;
    }

    public void run() {
        ArrayList<String> configFiles = new ArrayList<String>();
        configFiles.add("classpath:/spring-cli.context");
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!key.startsWith("context.") && !"context".equals(key)) continue;
            String configFile = this.properties.getProperty(key);
            this.LOG.info((Object)("Adding config file: " + configFile));
            configFiles.add(configFile);
        }
        StaticApplicationContext parentContext = new StaticApplicationContext();
        AbstractBeanDefinition argsBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(Arguments.class).addConstructorArgValue((Object)this.args).getBeanDefinition();
        parentContext.registerBeanDefinition("arguments", (BeanDefinition)argsBeanDefinition);
        parentContext.refresh();
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(configFiles.toArray(new String[0]), true, (ApplicationContext)parentContext);
        String runnerName = this.properties.getProperty(RUNNER_DEFAULT_NAME, RUNNER_DEFAULT_NAME);
        this.LOG.info((Object)("Loading runner with name: " + runnerName));
        Runnable runner = null;
        if (context.containsBean(runnerName)) {
            runner = (Runnable)context.getBean(runnerName, Runnable.class);
        }
        if (runner == null) {
            this.LOG.error((Object)"Runner not found!");
        } else {
            this.LOG.info((Object)("Found runner: " + runner.getClass().getName()));
            runner.run();
        }
    }
}

