/*
 * Decompiled with CFR 0.152.
 */
package uk.co.grahamcox.spring.cli.options;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import uk.co.grahamcox.spring.cli.Arguments;
import uk.co.grahamcox.spring.cli.options.WireOption;

public class CommandLineBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private CommandLineParser commandLineParser;
    @Autowired(required=true)
    private Arguments arguments;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
        Object result = bean;
        if (bean == null) {
            result = null;
        } else if (this.arguments != null && this.commandLineParser != null && result instanceof CommandLine) {
            String[] optionsNames = this.applicationContext.getBeanNamesForType(Options.class);
            Options options = (Options)this.applicationContext.getBean(optionsNames[0]);
            try {
                result = this.commandLineParser.parse(options, this.arguments.getArguments());
            }
            catch (ParseException e) {
                throw new BeanCreationException("Error parsing arguments", (Throwable)e);
            }
        } else {
            CommandLine cl = null;
            for (Method met : bean.getClass().getMethods()) {
                String[] clNames;
                WireOption wo = met.getAnnotation(WireOption.class);
                if (wo == null || (cl = (CommandLine)this.applicationContext.getBean((clNames = this.applicationContext.getBeanNamesForType(CommandLine.class))[0])) == null) continue;
                String option = wo.value();
                Class<?>[] paramTypes = met.getParameterTypes();
                Object[] params = new Object[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (paramTypes[i].isAssignableFrom(Boolean.TYPE)) {
                        params[i] = cl.hasOption(option);
                        continue;
                    }
                    if (paramTypes[i].isAssignableFrom(String.class)) {
                        params[i] = cl.getOptionValue(option);
                        continue;
                    }
                    throw new BeanCreationException("Unable to assign option value to setter. Parameters must be Boolean or String types");
                }
                try {
                    met.invoke(bean, params);
                }
                catch (IllegalArgumentException e) {
                    throw new BeanCreationException("Illegal argument supplied to Option setter", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new BeanCreationException("Illegal access to Option setter", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new BeanCreationException("Error invoking Option setter", (Throwable)e);
                }
            }
        }
        return result;
    }
}

