/*
 * Decompiled with CFR 0.152.
 */
package uk.co.grahamcox.spring.cli.options;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class OptionsBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        if (bean instanceof Options) {
            this.LOG.info((Object)("Processing an Options bean: " + name));
            Options options = (Options)bean;
            for (String option : this.applicationContext.getBeanNamesForType(Option.class)) {
                Option opt = (Option)this.applicationContext.getBean(option);
                this.LOG.info((Object)("Adding option " + opt + " to options"));
                options.addOption(opt);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
        return bean;
    }
}

