/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.log4j.Logger;
import uk.co.jemos.podam.annotations.PodamBooleanValue;
import uk.co.jemos.podam.annotations.PodamByteValue;
import uk.co.jemos.podam.annotations.PodamCharValue;
import uk.co.jemos.podam.annotations.PodamCollection;
import uk.co.jemos.podam.annotations.PodamConstructor;
import uk.co.jemos.podam.annotations.PodamDoubleValue;
import uk.co.jemos.podam.annotations.PodamFloatValue;
import uk.co.jemos.podam.annotations.PodamIntValue;
import uk.co.jemos.podam.annotations.PodamLongValue;
import uk.co.jemos.podam.annotations.PodamShortValue;
import uk.co.jemos.podam.annotations.PodamStrategyValue;
import uk.co.jemos.podam.annotations.PodamStringValue;
import uk.co.jemos.podam.annotations.strategies.ObjectStrategy;
import uk.co.jemos.podam.api.AttributeStrategy;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamFactory;
import uk.co.jemos.podam.api.RandomDataProviderStrategy;
import uk.co.jemos.podam.dto.ClassInfo;
import uk.co.jemos.podam.exceptions.PodamMockeryException;
import uk.co.jemos.podam.utils.PodamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
@Immutable
public class PodamFactoryImpl
implements PodamFactory {
    private final Logger LOG = Logger.getLogger((String)PodamFactoryImpl.class.getName());
    private final DataProviderStrategy strategy;

    public PodamFactoryImpl() {
        this(RandomDataProviderStrategy.getInstance());
    }

    public PodamFactoryImpl(DataProviderStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public <T> T manufacturePojo(Class<T> pojoClass) {
        return this.manufacturePojoInternal(pojoClass, 0);
    }

    @Override
    public DataProviderStrategy getStrategy() {
        return this.strategy;
    }

    private Object createNewInstanceForClassWithoutConstructors(Class<?> pojoClass, Class<?> clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            Object[] parameterValues = null;
            for (Method candidateConstructor : declaredMethods) {
                if (!Modifier.isStatic(candidateConstructor.getModifiers()) || !candidateConstructor.getReturnType().equals(clazz)) continue;
                if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
                    if (candidateConstructor.getParameterTypes().length != 0) continue;
                    return candidateConstructor.invoke(clazz, new Object[0]);
                }
                parameterValues = new Object[candidateConstructor.getParameterTypes().length];
                Type[] parameterTypes = candidateConstructor.getGenericParameterTypes();
                if (parameterTypes.length == 0) {
                    retValue = candidateConstructor.invoke(clazz, new Object[0]);
                } else {
                    Annotation[][] parameterAnnotations = candidateConstructor.getParameterAnnotations();
                    int idx = 0;
                    for (Type paramType : parameterTypes) {
                        int i;
                        PodamCollection ann;
                        int nbrElements;
                        Class<?> parameterType = Class.forName(PodamUtils.extractClassNameFromParameterisedTypeInField(paramType));
                        List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
                        String attributeName = null;
                        if (Collection.class.isAssignableFrom(parameterType)) {
                            Collection<? super Object> listType = this.resolveCollectionType(parameterType);
                            Class<?> elementType = this.retrieveClassFromCollectionTypeInConstructor(paramType.toString());
                            nbrElements = 1;
                            for (Annotation annotation : annotations) {
                                if (!annotation.annotationType().equals(PodamCollection.class)) continue;
                                ann = (PodamCollection)annotation;
                                nbrElements = ann.nbrElements();
                            }
                            for (i = 0; i < nbrElements; ++i) {
                                Object attributeValue = this.manufactureAttributeValue(clazz, elementType, annotations, attributeName);
                                listType.add(attributeValue);
                            }
                            parameterValues[idx] = listType;
                        } else if (Map.class.isAssignableFrom(parameterType)) {
                            Map<? super Object, ? super Object> mapType = this.resolveMapType(parameterType);
                            Class<?>[] keyValueClasses = this.retrieveClassFromMapTypeInConstructor(paramType.toString());
                            nbrElements = 1;
                            for (Annotation annotation : annotations) {
                                if (!annotation.annotationType().equals(PodamCollection.class)) continue;
                                ann = (PodamCollection)annotation;
                                nbrElements = ann.nbrElements();
                            }
                            for (i = 0; i < nbrElements; ++i) {
                                Object keyValue = this.manufactureAttributeValue(clazz, keyValueClasses[0], annotations, attributeName);
                                Object elementValue = this.manufactureAttributeValue(clazz, keyValueClasses[1], annotations, attributeName);
                                mapType.put(keyValue, elementValue);
                            }
                            parameterValues[idx] = mapType;
                        } else {
                            parameterValues[idx] = this.manufactureAttributeValue(clazz, parameterType, annotations, attributeName);
                        }
                        ++idx;
                    }
                }
                retValue = candidateConstructor.invoke(clazz, parameterValues);
                break;
            }
        } else {
            boolean resolved = false;
            for (Constructor<?> constructor : constructors) {
                try {
                    Object[] constructorArgs = this.getParameterValuesForConstructor(constructor, pojoClass);
                    retValue = constructor.newInstance(constructorArgs);
                    resolved = true;
                    this.LOG.info((Object)("For class: " + clazz.getName() + " a valid constructor: " + constructor + " was found. PODAM will use it to create an instance."));
                    break;
                }
                catch (Throwable t) {
                    this.LOG.warn((Object)("Couldn't create attribute with constructor: " + constructor + ". Will check if other constructors are available"));
                }
            }
            if (!resolved) {
                this.LOG.warn((Object)("For class: " + clazz.getName() + " PODAM could not possibly create a value. This attribute will be returned as null."));
            }
        }
        return retValue;
    }

    private Object resolvePrimitiveValue(Class<?> primitiveClass, List<Annotation> annotations) {
        Constable retValue = null;
        if (primitiveClass.equals(Integer.TYPE)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getInteger();
            } else {
                retValue = this.getIntegerValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getInteger();
                }
            }
        } else if (primitiveClass.equals(Long.TYPE)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getLong();
            } else {
                retValue = this.getLongValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getLong();
                }
            }
        } else if (primitiveClass.equals(Float.TYPE)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getFloat();
            } else {
                retValue = this.getFloatValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getFloat();
                }
            }
        } else if (primitiveClass.equals(Double.TYPE)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getDouble();
            } else {
                retValue = this.getDoubleValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getDouble();
                }
            }
        } else if (primitiveClass.equals(Boolean.TYPE)) {
            retValue = annotations.isEmpty() ? this.strategy.getBoolean() : this.getBooleanValueForAnnotation(annotations);
        } else if (primitiveClass.equals(Byte.TYPE)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getByte();
            } else {
                retValue = this.getByteValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getByte();
                }
            }
        } else if (primitiveClass.equals(Short.TYPE)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getShort();
            } else {
                retValue = this.getShortValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getShort();
                }
            }
        } else if (primitiveClass.equals(Character.TYPE)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getCharacter();
            } else {
                retValue = this.getCharacterValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getCharacter();
                }
            }
        }
        return retValue;
    }

    private Boolean getBooleanValueForAnnotation(List<Annotation> annotations) {
        Boolean retValue = null;
        for (Annotation annotation : annotations) {
            if (!PodamBooleanValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamBooleanValue strategy = (PodamBooleanValue)annotation;
            retValue = strategy.boolValue();
            break;
        }
        return retValue;
    }

    private Byte getByteValueWithinRange(List<Annotation> annotations) {
        Byte retValue = null;
        for (Annotation annotation : annotations) {
            byte maxValue;
            if (!PodamByteValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamByteValue intStrategy = (PodamByteValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Byte.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a byte type. An exception will be thrown.";
                    this.LOG.error((Object)errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            byte minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getByteInRange(minValue, maxValue);
            break;
        }
        return retValue;
    }

    private Short getShortValueWithinRange(List<Annotation> annotations) {
        Short retValue = null;
        for (Annotation annotation : annotations) {
            short maxValue;
            if (!PodamShortValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamShortValue shortStrategy = (PodamShortValue)annotation;
            String numValueStr = shortStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Short.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The precise value: " + numValueStr + " cannot be converted to a short type. An exception will be thrown.";
                    this.LOG.error((Object)errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            short minValue = shortStrategy.minValue();
            if (minValue > (maxValue = shortStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getShortInRange(minValue, maxValue);
            break;
        }
        return retValue;
    }

    private Character getCharacterValueWithinRange(List<Annotation> annotations) {
        Character retValue = null;
        for (Annotation annotation : annotations) {
            char maxValue;
            if (!PodamCharValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamCharValue annotationStrategy = (PodamCharValue)annotation;
            char charValue = annotationStrategy.charValue();
            if (charValue != ' ') {
                retValue = Character.valueOf(charValue);
                break;
            }
            char minValue = annotationStrategy.minValue();
            if (minValue > (maxValue = annotationStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getCharacterInRange(minValue, maxValue);
            break;
        }
        return retValue;
    }

    private Integer getIntegerValueWithinRange(List<Annotation> annotations) {
        Integer retValue = null;
        for (Annotation annotation : annotations) {
            int maxValue;
            if (!PodamIntValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamIntValue intStrategy = (PodamIntValue)annotation;
            String numValueStr = intStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Integer.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to an Integer. An exception will be thrown.";
                    this.LOG.error((Object)errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            int minValue = intStrategy.minValue();
            if (minValue > (maxValue = intStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getIntegerInRange(minValue, maxValue);
            break;
        }
        return retValue;
    }

    private Float getFloatValueWithinRange(List<Annotation> annotations) {
        Float retValue = null;
        for (Annotation annotation : annotations) {
            float maxValue;
            if (!PodamFloatValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamFloatValue floatStrategy = (PodamFloatValue)annotation;
            String numValueStr = floatStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Float.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Float. An exception will be thrown.";
                    this.LOG.error((Object)errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            float minValue = floatStrategy.minValue();
            if (minValue > (maxValue = floatStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getFloatInRange(minValue, maxValue);
            break;
        }
        return retValue;
    }

    private Double getDoubleValueWithinRange(List<Annotation> annotations) {
        Double retValue = null;
        for (Annotation annotation : annotations) {
            double maxValue;
            if (!PodamDoubleValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamDoubleValue doubleStrategy = (PodamDoubleValue)annotation;
            String numValueStr = doubleStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Double.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Double. An exception will be thrown.";
                    this.LOG.error((Object)errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            double minValue = doubleStrategy.minValue();
            if (minValue > (maxValue = doubleStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getDoubleInRange(minValue, maxValue);
            break;
        }
        return retValue;
    }

    private Long getLongValueWithinRange(List<Annotation> annotations) {
        Long retValue = null;
        for (Annotation annotation : annotations) {
            long maxValue;
            if (!PodamLongValue.class.isAssignableFrom(annotation.getClass())) continue;
            PodamLongValue longStrategy = (PodamLongValue)annotation;
            String numValueStr = longStrategy.numValue();
            if (null != numValueStr && !"".equals(numValueStr)) {
                try {
                    retValue = Long.valueOf(numValueStr);
                    break;
                }
                catch (NumberFormatException nfe) {
                    String errMsg = "The annotation value: " + numValueStr + " could not be converted to a Long. An exception will be thrown.";
                    this.LOG.error((Object)errMsg);
                    throw new IllegalArgumentException(errMsg, nfe);
                }
            }
            long minValue = longStrategy.minValue();
            if (minValue > (maxValue = longStrategy.maxValue())) {
                maxValue = minValue;
            }
            retValue = this.strategy.getLongInRange(minValue, maxValue);
            break;
        }
        return retValue;
    }

    private Object resolveWrapperValue(Class<?> candidateWrapperClass, List<Annotation> annotations) {
        Constable retValue = null;
        if (candidateWrapperClass.equals(Integer.class)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getInteger();
            } else {
                retValue = this.getIntegerValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getInteger();
                }
            }
        } else if (candidateWrapperClass.equals(Long.class)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getLong();
            } else {
                retValue = this.getLongValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getLong();
                }
            }
        } else if (candidateWrapperClass.equals(Float.class)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getFloat();
            } else {
                retValue = this.getFloatValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getFloat();
                }
            }
        } else if (candidateWrapperClass.equals(Double.class)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getDouble();
            } else {
                retValue = this.getDoubleValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getDouble();
                }
            }
        } else if (candidateWrapperClass.equals(Boolean.class)) {
            retValue = annotations.isEmpty() ? this.strategy.getBoolean() : this.getBooleanValueForAnnotation(annotations);
        } else if (candidateWrapperClass.equals(Byte.class)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getByte();
            } else {
                retValue = this.getByteValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getByte();
                }
            }
        } else if (candidateWrapperClass.equals(Short.class)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getShort();
            } else {
                retValue = this.getShortValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getShort();
                }
            }
        } else if (candidateWrapperClass.equals(Character.class)) {
            if (annotations.isEmpty()) {
                retValue = this.strategy.getCharacter();
            } else {
                retValue = this.getCharacterValueWithinRange(annotations);
                if (retValue == null) {
                    retValue = this.strategy.getCharacter();
                }
            }
        }
        return retValue;
    }

    private <T> T resolvePojoWithoutSetters(Class<T> pojoClass, int depth) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        Constructor<?>[] constructors = pojoClass.getConstructors();
        if (constructors.length == 0) {
            retValue = this.createNewInstanceForClassWithoutConstructors(pojoClass, pojoClass);
        } else {
            boolean podamConstructorAnnotationFound = this.checkIfConstructorAnnotationPresent(constructors);
            for (Constructor<?> constructor : constructors) {
                if (constructor.getAnnotation(PodamConstructor.class) == null && podamConstructorAnnotationFound) continue;
                Object[] parameterValues = this.getParameterValuesForConstructor(constructor, pojoClass);
                retValue = constructor.newInstance(parameterValues);
                break;
            }
        }
        return (T)retValue;
    }

    private boolean checkIfConstructorAnnotationPresent(Constructor<?>[] constructors) {
        boolean retValue = false;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getAnnotation(PodamConstructor.class) == null) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    private Class<?> retrieveClassFromCollectionTypeInConstructor(String typeStr) {
        Class retValue = null;
        if (!typeStr.contains("<") && !typeStr.contains(">")) {
            this.LOG.warn((Object)("The Collection type in the constructor: " + typeStr + " is non generic. We will assume Collection<Object> for you."));
            retValue = Object.class;
        } else {
            int startIdx = typeStr.indexOf("<") + 1;
            int endIdx = typeStr.indexOf(">");
            String classType = typeStr.substring(startIdx, endIdx);
            try {
                retValue = Class.forName(classType);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class " + classType + " could not be loaded!");
            }
        }
        return retValue;
    }

    private Class<?>[] retrieveClassFromMapTypeInConstructor(String typeStr) {
        Class[] retValue = new Class[2];
        if (!typeStr.contains("<") && !typeStr.contains(">")) {
            this.LOG.warn((Object)("The Map type in the constructor: " + typeStr + " is non generic. We will assume Map<Object, Object> for you."));
            retValue[0] = Object.class;
            retValue[1] = Object.class;
        } else {
            int startIdx = typeStr.indexOf("<") + 1;
            int endIdx = typeStr.indexOf(">");
            String classType = typeStr.substring(startIdx, endIdx);
            String[] keyValueTypeStr = classType.split(",");
            try {
                retValue[0] = Class.forName(keyValueTypeStr[0].trim());
                retValue[1] = Class.forName(keyValueTypeStr[1].trim());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class " + classType + " could not be loaded!");
            }
        }
        return retValue;
    }

    private <T> T manufacturePojoInternal(Class<T> pojoClass, int depth) {
        try {
            T retValue = null;
            if (pojoClass.isPrimitive()) {
                throw new PodamMockeryException("It's not possible to instantiate an interface or a primitive type.");
            }
            if (pojoClass.isInterface() || Modifier.isAbstract(pojoClass.getModifiers())) {
                this.LOG.warn((Object)"Cannot instantiate an interface or abstract class. Returning null.");
                return null;
            }
            ClassInfo classInfo = PodamUtils.getClassInfo(pojoClass);
            if (classInfo.getClassSetters().isEmpty()) {
                return this.resolvePojoWithoutSetters(pojoClass, depth);
            }
            Constructor<T> defaultConstructor = null;
            try {
                defaultConstructor = pojoClass.getConstructor(new Class[0]);
                retValue = defaultConstructor.newInstance(new Object[0]);
            }
            catch (SecurityException e) {
                throw new PodamMockeryException("Security exception while applying introspection.", e);
            }
            catch (NoSuchMethodException e) {
                try {
                    this.LOG.warn((Object)("The POJO " + pojoClass + " does not have a public no-arg constructor. This violates JavaBean standards. " + "However in our kindness we'll look for an alternate public constructor " + "for you and we'll use the first we find..."));
                    Constructor<?>[] constructors = pojoClass.getConstructors();
                    if (constructors == null || constructors.length == 0) {
                        this.LOG.warn((Object)"No public constructors were found. We'll look for a default, non-public constructor. ");
                        defaultConstructor = pojoClass.getDeclaredConstructor(new Class[0]);
                        this.LOG.info((Object)("Will use: " + defaultConstructor));
                        defaultConstructor.setAccessible(true);
                        retValue = defaultConstructor.newInstance(new Object[0]);
                    } else {
                        this.LOG.info((Object)("Will use: " + constructors[0]));
                        Object[] parameterValuesForConstructor = this.getParameterValuesForConstructor(constructors[0], pojoClass);
                        constructors[0].setAccessible(true);
                        retValue = (T)constructors[0].newInstance(parameterValuesForConstructor);
                    }
                }
                catch (SecurityException e1) {
                    throw new PodamMockeryException("Security exception while applying introspection.", e);
                }
                catch (NoSuchMethodException e2) {
                    this.LOG.warn((Object)"No default (public or non-public) constructors were found. Also no other public constructors were found. Your last hope is that we find a non-public, non-default constructor.");
                    Constructor<?>[] constructors = pojoClass.getDeclaredConstructors();
                    if (constructors == null || constructors.length == 0) {
                        throw new IllegalStateException("The POJO " + pojoClass + " appears without constructors. How is this possible? ");
                    }
                    this.LOG.info((Object)("Will use: " + constructors[0]));
                    Object[] parameterValuesForConstructor = this.getParameterValuesForConstructor(constructors[0], pojoClass);
                    constructors[0].setAccessible(true);
                    retValue = (T)constructors[0].newInstance(parameterValuesForConstructor);
                }
            }
            Class<?>[] parameterTypes = null;
            Class<?> attributeType = null;
            Object setterArg = null;
            for (Method setter : classInfo.getClassSetters()) {
                List<Annotation> pojoAttributeAnnotations = this.retrieveFieldAnnotations(pojoClass, setter);
                String attributeName = PodamUtils.extractFieldNameFromSetterMethod(setter);
                parameterTypes = setter.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalStateException("A JavaBean setter should have only one argument");
                }
                attributeType = parameterTypes[0];
                PodamStrategyValue attributeStrategyAnnotation = this.containsAttributeStrategyAnnotation(pojoAttributeAnnotations);
                if (null != attributeStrategyAnnotation) {
                    AttributeStrategy<?> attributeStrategy = attributeStrategyAnnotation.value().newInstance();
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("The attribute: " + attributeName + " will be filled using the following strategy: " + attributeStrategy));
                    }
                    setterArg = this.returnAttributeDataStrategyValue(attributeType, attributeStrategy);
                } else {
                    if (attributeType.equals(pojoClass)) {
                        if (depth < 1) {
                            setterArg = this.manufacturePojoInternal(attributeType, ++depth);
                            setter.invoke(retValue, setterArg);
                            continue;
                        }
                        setterArg = this.createNewInstanceForClassWithoutConstructors(pojoClass, pojoClass);
                        setter.invoke(retValue, setterArg);
                        depth = 0;
                        continue;
                    }
                    setterArg = this.manufactureAttributeValue(pojoClass, attributeType, pojoAttributeAnnotations, attributeName);
                }
                if (setterArg != null) {
                    if (!Modifier.isPublic(setter.getModifiers())) {
                        this.LOG.warn((Object)("The setter: " + setter.getName() + " is not public. Setting it to accessible(true). " + "However if you have got security in place to avoid these kind of things, you will get an error"));
                        setter.setAccessible(true);
                    }
                    setter.invoke(retValue, setterArg);
                    continue;
                }
                this.LOG.warn((Object)("Couldn't find a suitable value for attribute: " + attributeName + ". This POJO attribute will be left to null."));
            }
            return retValue;
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException("An instantiation exception occurred", e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException("An illegal access occurred", e);
        }
        catch (IllegalArgumentException e) {
            throw new PodamMockeryException("An illegal argument was passed", e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException("Invocation Target Exception", e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException("Invocation Target Exception", e);
        }
    }

    private Object manufactureAttributeValue(Class<?> pojoClass, Class<?> attributeType, List<Annotation> annotations, String attributeName) throws InstantiationException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, ClassNotFoundException {
        Object attributeValue = null;
        if (attributeType.isPrimitive()) {
            attributeValue = this.resolvePrimitiveValue(attributeType, annotations);
        } else if (this.isWrapper(attributeType)) {
            attributeValue = this.resolveWrapperValue(attributeType, annotations);
        } else if (attributeType.equals(String.class)) {
            attributeValue = this.resolveStringValue(annotations);
        } else if (attributeType.getName().startsWith("[")) {
            attributeValue = this.resolveArrayElementValue(attributeType, annotations, pojoClass, attributeName);
        } else if (Collection.class.isAssignableFrom(attributeType)) {
            attributeValue = this.resolveCollectionValueWhenCollectionIsPojoAttribute(pojoClass, attributeType, attributeName, annotations);
        } else if (Map.class.isAssignableFrom(attributeType)) {
            attributeValue = this.resolveMapValueWhenMapIsPojoAttribute(pojoClass, attributeType, attributeName, annotations);
        } else if (attributeType.getName().startsWith("java.") || attributeType.getName().startsWith("javax.")) {
            attributeValue = this.createNewInstanceForClassWithoutConstructors(pojoClass, attributeType);
        } else if (attributeType.isEnum()) {
            int enumConstantsLength = attributeType.getEnumConstants().length;
            if (enumConstantsLength > 0) {
                attributeValue = attributeType.getEnumConstants()[0];
            }
        } else {
            attributeValue = this.manufacturePojo(attributeType);
        }
        return attributeValue;
    }

    private String resolveStringValue(List<Annotation> annotations) throws InstantiationException, IllegalAccessException {
        String retValue = null;
        if (annotations == null || annotations.isEmpty()) {
            retValue = this.strategy.getStringValue();
        } else {
            for (Annotation annotation : annotations) {
                if (!PodamStringValue.class.isAssignableFrom(annotation.getClass())) continue;
                PodamStringValue podamAnnotation = (PodamStringValue)annotation;
                if (podamAnnotation.strValue() != null && podamAnnotation.strValue().length() > 0) {
                    retValue = podamAnnotation.strValue();
                    continue;
                }
                retValue = this.strategy.getStringOfLength(podamAnnotation.length());
            }
            if (retValue == null) {
                retValue = this.strategy.getStringValue();
            }
        }
        return retValue;
    }

    private PodamStrategyValue containsAttributeStrategyAnnotation(List<Annotation> annotations) {
        PodamStrategyValue retValue = null;
        for (Annotation annotation : annotations) {
            if (!PodamStrategyValue.class.isAssignableFrom(annotation.getClass())) continue;
            retValue = (PodamStrategyValue)annotation;
            break;
        }
        return retValue;
    }

    private boolean isWrapper(Class<?> candidateWrapperClass) {
        return candidateWrapperClass.equals(Byte.class) ? true : (candidateWrapperClass.equals(Boolean.class) ? true : (candidateWrapperClass.equals(Character.class) ? true : (candidateWrapperClass.equals(Short.class) ? true : (candidateWrapperClass.equals(Integer.class) ? true : (candidateWrapperClass.equals(Long.class) ? true : (candidateWrapperClass.equals(Float.class) ? true : candidateWrapperClass.equals(Double.class)))))));
    }

    private List<Annotation> retrieveFieldAnnotations(Class<?> clazz, Method setter) {
        Annotation[] annotations;
        List<Annotation> retValue = new ArrayList<Annotation>();
        String attributeName = PodamUtils.extractFieldNameFromSetterMethod(setter);
        AccessibleObject setterField = null;
        while (clazz != null) {
            try {
                setterField = clazz.getDeclaredField(attributeName);
                break;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
            catch (SecurityException e) {
                throw e;
            }
        }
        if (setterField != null && (annotations = setterField.getAnnotations()) != null && annotations.length != 0) {
            retValue = Arrays.asList(annotations);
        }
        return retValue;
    }

    private Collection<? super Object> resolveCollectionValueWhenCollectionIsPojoAttribute(Class<?> pojoClass, Class<?> collectionType, String attributeName, List<Annotation> annotations) {
        this.validateAttributeName(attributeName);
        Collection<? super Object> retValue = null;
        try {
            Object newInstance = pojoClass.newInstance();
            Field field = pojoClass.getDeclaredField(attributeName);
            field.setAccessible(true);
            Collection<? super Object> coll = (Collection<? super Object>)field.get(newInstance);
            retValue = null != coll ? coll : this.resolveCollectionType(collectionType);
            Class<Object> typeClass = null;
            Type genericType = field.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                this.LOG.warn((Object)("The collection attribute: " + attributeName + " does not have a type. We will assume Object for you"));
                typeClass = Object.class;
            } else {
                ParameterizedType pType = (ParameterizedType)genericType;
                Type actualTypeArguments = pType.getActualTypeArguments()[0];
                typeClass = Class.forName(PodamUtils.extractClassNameFromParameterisedTypeInField(actualTypeArguments));
            }
            this.fillCollection(pojoClass, attributeName, annotations, retValue, typeClass);
        }
        catch (SecurityException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (NoSuchFieldException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (IllegalArgumentException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException("An exception occurred while resolving the collection", e);
        }
        return retValue;
    }

    private void fillCollection(Class<?> pojoClass, String attributeName, List<Annotation> annotations, Collection<? super Object> collection, Class<?> collectionElementType) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : annotations) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        int nbrElements = 1;
        if (null != collectionAnnotation) {
            nbrElements = collectionAnnotation.nbrElements();
            elementStrategy = collectionAnnotation.collectionElementStrategy().newInstance();
        }
        for (int i = 0; i < nbrElements; ++i) {
            if (null != elementStrategy && ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass()) && Object.class.equals(collectionElementType)) {
                this.LOG.debug((Object)"Element strategy is ObjectStrategy and collection element is of type Object: using the ObjectStrategy strategy");
                collection.add(elementStrategy.getValue());
                continue;
            }
            if (null != elementStrategy && !ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass())) {
                this.LOG.debug((Object)("Collection elements will be filled using the following strategy: " + elementStrategy));
                Object strategyValue = this.returnAttributeDataStrategyValue(collectionElementType, elementStrategy);
                collection.add(strategyValue);
                continue;
            }
            collection.add(this.manufactureAttributeValue(pojoClass, collectionElementType, annotations, attributeName));
        }
    }

    private Map<? super Object, ? super Object> resolveMapValueWhenMapIsPojoAttribute(Class<?> pojoClass, Class<?> attributeType, String attributeName, List<Annotation> annotations) {
        this.validateAttributeName(attributeName);
        Map<? super Object, ? super Object> retValue = null;
        Object newInstance = null;
        try {
            newInstance = pojoClass.newInstance();
            Field field = pojoClass.getDeclaredField(attributeName);
            field.setAccessible(true);
            Map<? super Object, ? super Object> coll = (Map<? super Object, ? super Object>)field.get(newInstance);
            retValue = null != coll ? coll : this.resolveMapType(attributeType);
            Type genericType = field.getGenericType();
            Class keyClass = null;
            Class elementClass = null;
            if (null != genericType && genericType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pType.getActualTypeArguments();
                if (actualTypeArguments.length != 2) {
                    throw new IllegalStateException("In a Map only key value generic type are expected.");
                }
                keyClass = Class.forName(PodamUtils.extractClassNameFromParameterisedTypeInField(actualTypeArguments[0]));
                elementClass = Class.forName(PodamUtils.extractClassNameFromParameterisedTypeInField(actualTypeArguments[1]));
            } else {
                this.LOG.warn((Object)("Map attribute: " + attributeName + " is non-generic. We will assume a Map<Object, Object> for you."));
                keyClass = Object.class;
                elementClass = Object.class;
            }
            this.fillMap(pojoClass, attributeName, annotations, retValue, keyClass, elementClass);
        }
        catch (InstantiationException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (IllegalAccessException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (SecurityException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (NoSuchFieldException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (ClassNotFoundException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        catch (InvocationTargetException e) {
            throw new PodamMockeryException("An exception occurred while creating a Map object", e);
        }
        return retValue;
    }

    private void fillMap(Class<?> pojoClass, String attributeName, List<Annotation> annotations, Map<? super Object, ? super Object> mapToBeFilled, Class<?> keyClass, Class<?> elementClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> keyStrategy = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : annotations) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        int nbrElements = 1;
        if (null != collectionAnnotation) {
            nbrElements = collectionAnnotation.nbrElements();
            keyStrategy = collectionAnnotation.mapKeyStrategy().newInstance();
            elementStrategy = collectionAnnotation.mapElementStrategy().newInstance();
        }
        for (int i = 0; i < nbrElements; ++i) {
            Object keyValue = null;
            Object elementValue = null;
            keyValue = this.getMapKeyOrElementValue(pojoClass, attributeName, annotations, keyClass, collectionAnnotation, keyStrategy);
            elementValue = this.getMapKeyOrElementValue(pojoClass, attributeName, annotations, elementClass, collectionAnnotation, elementStrategy);
            mapToBeFilled.put(keyValue, elementValue);
        }
    }

    private Object getMapKeyOrElementValue(Class<?> pojoClass, String attributeName, List<Annotation> annotations, Class<?> keyOrValueType, PodamCollection collectionAnnotation, AttributeStrategy<?> elementStrategy) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object retValue = null;
        if (null != elementStrategy && ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass()) && Object.class.equals(keyOrValueType)) {
            this.LOG.debug((Object)"Element strategy is ObjectStrategy and Map key or value type is of type Object: using the ObjectStrategy strategy");
            retValue = elementStrategy.getValue();
        } else if (null != elementStrategy && !ObjectStrategy.class.isAssignableFrom(elementStrategy.getClass())) {
            this.LOG.debug((Object)("Map key or value will be filled using the following strategy: " + elementStrategy));
            retValue = this.returnAttributeDataStrategyValue(keyOrValueType, elementStrategy);
        } else {
            retValue = this.manufactureAttributeValue(pojoClass, keyOrValueType, annotations, attributeName);
        }
        return retValue;
    }

    private Object resolveArrayElementValue(Class<?> attributeType, List<Annotation> annotations, Class<?> pojoClass, String attributeName) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> componentType = attributeType.getComponentType();
        int nbrElements = 1;
        Object arrayElement = null;
        PodamCollection collectionAnnotation = null;
        AttributeStrategy<?> elementStrategy = null;
        for (Annotation annotation : annotations) {
            if (!PodamCollection.class.isAssignableFrom(annotation.getClass())) continue;
            collectionAnnotation = (PodamCollection)annotation;
            break;
        }
        if (null != collectionAnnotation) {
            nbrElements = collectionAnnotation.nbrElements();
            elementStrategy = collectionAnnotation.collectionElementStrategy().newInstance();
        }
        Object array = Array.newInstance(componentType, nbrElements);
        for (int i = 0; i < nbrElements; ++i) {
            if (null != elementStrategy && ObjectStrategy.class.isAssignableFrom(collectionAnnotation.collectionElementStrategy()) && Object.class.equals(componentType)) {
                this.LOG.debug((Object)"Element strategy is ObjectStrategy and array element is of type Object: using the ObjectStrategy strategy");
                arrayElement = elementStrategy.getValue();
            } else if (null != elementStrategy && !ObjectStrategy.class.isAssignableFrom(collectionAnnotation.collectionElementStrategy())) {
                this.LOG.debug((Object)("Array elements will be filled using the following strategy: " + elementStrategy));
                arrayElement = this.returnAttributeDataStrategyValue(componentType, elementStrategy);
            } else {
                arrayElement = this.manufactureAttributeValue(pojoClass, componentType, annotations, attributeName);
            }
            Array.set(array, i, arrayElement);
        }
        return array;
    }

    private Collection<? super Object> resolveCollectionType(Class<?> collectionType) {
        AbstractCollection retValue = null;
        if (List.class.isAssignableFrom(collectionType) || collectionType.equals(Collection.class)) {
            retValue = new ArrayList();
        } else if (Queue.class.isAssignableFrom(collectionType)) {
            retValue = new LinkedList();
        } else if (Set.class.isAssignableFrom(collectionType)) {
            retValue = new HashSet();
        } else {
            throw new IllegalArgumentException("Collection type: " + collectionType + " not supported");
        }
        return retValue;
    }

    private Map<? super Object, ? super Object> resolveMapType(Class<?> attributeType) {
        AbstractMap retValue = null;
        retValue = SortedMap.class.isAssignableFrom(attributeType) ? new TreeMap() : (ConcurrentMap.class.isAssignableFrom(attributeType) ? new ConcurrentHashMap() : new HashMap());
        return retValue;
    }

    private void validateAttributeName(String attributeName) {
        if (attributeName == null || "".equals(attributeName)) {
            throw new IllegalArgumentException("The field name must not be null or empty!");
        }
    }

    private Object[] getParameterValuesForConstructor(Constructor<?> constructor, Class<?> pojoClass) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        Object[] parameterValues = new Object[constructor.getParameterTypes().length];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        int idx = 0;
        for (Class<?> parameterType : parameterTypes) {
            List<Annotation> annotations = Arrays.asList(parameterAnnotations[idx]);
            if (parameterType.equals(pojoClass)) {
                Class<?> declaringClass = constructor.getDeclaringClass();
                Constructor<?> noArgConstructor = null;
                try {
                    noArgConstructor = declaringClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    String errorMsg = "For class: " + declaringClass + " a constructor with its own type as argument does not have a no-arg constructor. Impossible to create an instance of this argument.";
                    this.LOG.error((Object)errorMsg);
                    throw new IllegalArgumentException(errorMsg);
                }
                parameterValues[idx] = noArgConstructor.newInstance(new Object[0]);
            } else {
                Type type;
                String attributeName = null;
                if (Collection.class.isAssignableFrom(parameterType)) {
                    Collection<? super Object> collection = this.resolveCollectionType(parameterType);
                    type = constructor.getGenericParameterTypes()[idx];
                    String typeStr = type.toString();
                    Class<?> collectionElementType = this.retrieveClassFromCollectionTypeInConstructor(typeStr);
                    this.fillCollection(pojoClass, attributeName, annotations, collection, collectionElementType);
                    parameterValues[idx] = collection;
                } else if (Map.class.isAssignableFrom(parameterType)) {
                    Map<? super Object, ? super Object> mapType = this.resolveMapType(parameterType);
                    type = constructor.getGenericParameterTypes()[idx];
                    Class<?>[] keyValueClasses = this.retrieveClassFromMapTypeInConstructor(type.toString());
                    this.fillMap(pojoClass, attributeName, annotations, mapType, keyValueClasses[0], keyValueClasses[1]);
                    parameterValues[idx] = mapType;
                } else {
                    parameterValues[idx] = this.manufactureAttributeValue(pojoClass, parameterType, annotations, attributeName);
                }
            }
            ++idx;
        }
        return parameterValues;
    }

    private Object returnAttributeDataStrategyValue(Class<?> attributeType, AttributeStrategy<?> attributeStrategy) throws InstantiationException, IllegalAccessException {
        Object retValue = null;
        Method attributeStrategyMethod = null;
        try {
            attributeStrategyMethod = attributeStrategy.getClass().getMethod("getValue", new Class[0]);
            if (!attributeType.isAssignableFrom(attributeStrategyMethod.getReturnType())) {
                String errMsg = "The type of the Podam Attribute Strategy is not " + attributeType.getName() + " but " + attributeStrategyMethod.getReturnType().getName() + ". An exception will be thrown.";
                this.LOG.error((Object)errMsg);
                throw new IllegalArgumentException(errMsg);
            }
            retValue = attributeStrategy.getValue();
        }
        catch (SecurityException e) {
            throw new IllegalStateException("A security issue occurred while retrieving the Podam Attribute Strategy details", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("It seems the Podam Attribute Annotation is of the wrong type", e);
        }
        return retValue;
    }
}

