/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.util.Random;
import org.apache.log4j.Logger;
import uk.co.jemos.podam.api.DataProviderStrategy;

public class RandomDataProviderStrategy
implements DataProviderStrategy {
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final RandomDataProviderStrategy SINGLETON = new RandomDataProviderStrategy();
    private static final Logger LOG = Logger.getLogger((String)RandomDataProviderStrategy.class.getName());

    private RandomDataProviderStrategy() {
    }

    public static RandomDataProviderStrategy getInstance() {
        return SINGLETON;
    }

    public Boolean getBoolean() {
        return Boolean.TRUE;
    }

    public Byte getByte() {
        byte nextByte = (byte)RANDOM.nextInt(127);
        while (nextByte == 0) {
            nextByte = (byte)RANDOM.nextInt(127);
        }
        return nextByte;
    }

    public Byte getByteInRange(byte minValue, byte maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        byte retValue = (byte)(minValue + (byte)(Math.random() * (double)(maxValue - minValue + 1)));
        while (retValue < minValue || retValue > maxValue) {
            retValue = (byte)(minValue + (byte)(Math.random() * (double)(maxValue - minValue + 1)));
        }
        return retValue;
    }

    public Character getCharacter() {
        return Character.valueOf((char)this.getIntegerInRange(48, 126));
    }

    public Character getCharacterInRange(char minValue, char maxValue) {
        if (minValue == maxValue) {
            return Character.valueOf(minValue);
        }
        char retValue = (char)(minValue + (char)(Math.random() * (double)(maxValue - minValue + 1)));
        while (retValue < minValue || retValue > maxValue) {
            retValue = (char)(minValue + (char)(Math.random() * (double)(maxValue - minValue + 1)));
        }
        return Character.valueOf(retValue);
    }

    public Double getDouble() {
        double retValue = RANDOM.nextDouble();
        while (retValue == 0.0) {
            retValue = RANDOM.nextDouble();
        }
        return retValue;
    }

    public Double getDoubleInRange(double minValue, double maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        double retValue = minValue + Math.random() * (maxValue - minValue + 1.0);
        while (retValue < minValue || retValue > maxValue) {
            retValue = minValue + Math.random() * (maxValue - minValue + 1.0);
        }
        return retValue;
    }

    public Float getFloat() {
        float retValue = RANDOM.nextFloat();
        while (retValue == 0.0f) {
            retValue = RANDOM.nextFloat();
        }
        return Float.valueOf(retValue);
    }

    public Float getFloatInRange(float minValue, float maxValue) {
        if (minValue == maxValue) {
            return Float.valueOf(minValue);
        }
        float retValue = minValue + (float)(Math.random() * (double)(maxValue - minValue + 1.0f));
        while (retValue < minValue || retValue > maxValue) {
            retValue = minValue + (float)(Math.random() * (double)(maxValue - minValue + 1.0f));
        }
        return Float.valueOf(retValue);
    }

    public Integer getInteger() {
        Integer retValue = RANDOM.nextInt();
        while (retValue == 0) {
            retValue = RANDOM.nextInt();
        }
        return retValue;
    }

    public int getIntegerInRange(int minValue, int maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        int retValue = minValue + (int)(Math.random() * (double)(maxValue - minValue + 1));
        while (retValue < minValue || retValue > maxValue) {
            retValue = minValue + (int)(Math.random() * (double)(maxValue - minValue + 1));
        }
        return retValue;
    }

    public Long getLong() {
        return System.currentTimeMillis();
    }

    public Long getLongInRange(long minValue, long maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        long retValue = minValue + (long)(Math.random() * (double)(maxValue - minValue + 1L));
        while (retValue < minValue || retValue > maxValue) {
            retValue = minValue + (long)(Math.random() * (double)(maxValue - minValue + 1L));
        }
        return retValue;
    }

    public Short getShort() {
        short retValue = (short)RANDOM.nextInt(127);
        while (retValue == 0) {
            retValue = (short)RANDOM.nextInt(127);
        }
        return retValue;
    }

    public Short getShortInRange(short minValue, short maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        short retValue = (short)(minValue + (short)(Math.random() * (double)(maxValue - minValue + 1)));
        while (retValue < minValue || retValue > maxValue) {
            retValue = (short)(minValue + (short)(Math.random() * (double)(maxValue - minValue + 1)));
        }
        return retValue;
    }

    public String getStringValue() {
        return this.getStringOfLength(10);
    }

    public String getStringOfLength(int length) {
        StringBuilder buff = new StringBuilder("UTF-8");
        buff.setLength(0);
        while (buff.length() < length) {
            buff.append(this.getCharacter());
        }
        return buff.toString();
    }
}

