/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import uk.co.jemos.podam.annotations.PodamExclude;
import uk.co.jemos.podam.dto.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PodamUtils {
    private PodamUtils() {
        throw new AssertionError();
    }

    public static ClassInfo getClassInfo(Class<?> clazz) {
        Set<String> classFields = PodamUtils.getDeclaredInstanceFields(clazz);
        Set<Method> classSetters = PodamUtils.getPojoSetters(clazz, classFields);
        return new ClassInfo(clazz, classFields, classSetters);
    }

    public static Set<String> getDeclaredInstanceFields(Class<?> clazz) {
        HashSet<String> classFields = new HashSet<String>();
        while (clazz != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                int modifiers;
                if (field.getAnnotation(PodamExclude.class) != null || Modifier.isStatic(modifiers = field.getModifiers())) continue;
                classFields.add(field.getName());
            }
            clazz = clazz.getSuperclass();
        }
        return classFields;
    }

    public static Set<Method> getPojoSetters(Class<?> clazz, Set<String> classFields) {
        HashSet<Method> classSetters = new HashSet<Method>();
        while (clazz != null) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            String candidateField = null;
            for (Method method : declaredMethods) {
                if (!method.getName().startsWith("set") || !method.getReturnType().equals(Void.TYPE) || !classFields.contains(candidateField = PodamUtils.extractFieldNameFromSetterMethod(method))) continue;
                classSetters.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return classSetters;
    }

    public static String extractFieldNameFromSetterMethod(Method method) {
        String candidateField = method.getName().substring(3);
        candidateField = Character.toLowerCase(candidateField.charAt(0)) + candidateField.substring(1);
        return candidateField;
    }

    public static String extractClassNameFromParameterisedTypeInField(Type type) {
        String typeStr = type.toString();
        if (typeStr.startsWith("class")) {
            return typeStr.substring(6);
        }
        if (typeStr.startsWith("interface")) {
            return typeStr.substring(10);
        }
        if (typeStr.contains("<")) {
            int idx = typeStr.indexOf("<");
            return typeStr.substring(0, idx).trim();
        }
        throw new IllegalArgumentException("Type is not recognised");
    }
}

