/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.common.ConstructorComparator;
import uk.co.jemos.podam.common.MethodComparator;

public abstract class AbstractRandomDataProviderStrategy
implements DataProviderStrategy {
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final ConstructorComparator CONSTRUCTOR_COMPARATOR = new ConstructorComparator();
    private static final MethodComparator METHOD_COMPARATOR = new MethodComparator();
    public static final char[] NICE_ASCII_CHARACTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};
    public static final int MAX_DEPTH = 1;
    public static final int DEFAULT_NBR_COLLECTION_ELEMENTS = 5;
    private int maxDepth = 1;
    private int nbrOfCollectionElements;
    private boolean isMemoizationEnabled;
    private final Map<Class<?>, Class<?>> specificTypes = new HashMap();
    private final Set<Class<? extends Annotation>> excludedAnnotations = new HashSet<Class<? extends Annotation>>();

    public AbstractRandomDataProviderStrategy() {
        this(5);
    }

    public AbstractRandomDataProviderStrategy(int nbrOfCollectionElements) {
        this.nbrOfCollectionElements = nbrOfCollectionElements;
    }

    @Override
    public Boolean getBoolean(AttributeMetadata attributeMetadata) {
        return Boolean.TRUE;
    }

    @Override
    public Byte getByte(AttributeMetadata attributeMetadata) {
        byte nextByte = (byte)RANDOM.nextInt(127);
        while (nextByte == 0) {
            nextByte = (byte)RANDOM.nextInt(127);
        }
        return nextByte;
    }

    @Override
    public Byte getByteInRange(byte minValue, byte maxValue, AttributeMetadata attributeMetadata) {
        if (minValue == maxValue) {
            return minValue;
        }
        byte retValue = (byte)(minValue + (byte)(Math.random() * (double)(maxValue - minValue + 1)));
        while (retValue < minValue || retValue > maxValue) {
            retValue = (byte)(minValue + (byte)(Math.random() * (double)(maxValue - minValue + 1)));
        }
        return retValue;
    }

    @Override
    public Character getCharacter(AttributeMetadata attributeMetadata) {
        int randomCharIdx = this.getIntegerInRange(0, NICE_ASCII_CHARACTERS.length - 1, attributeMetadata);
        int charToReturnIdx = randomCharIdx % NICE_ASCII_CHARACTERS.length;
        return Character.valueOf(NICE_ASCII_CHARACTERS[charToReturnIdx]);
    }

    @Override
    public Character getCharacterInRange(char minValue, char maxValue, AttributeMetadata attributeMetadata) {
        if (minValue == maxValue) {
            return Character.valueOf(minValue);
        }
        char retValue = (char)(minValue + (char)(Math.random() * (double)(maxValue - minValue + 1)));
        while (retValue < minValue || retValue > maxValue) {
            retValue = (char)(minValue + (char)(Math.random() * (double)(maxValue - minValue + 1)));
        }
        return Character.valueOf(retValue);
    }

    @Override
    public Double getDouble(AttributeMetadata attributeMetadata) {
        double retValue = RANDOM.nextDouble();
        while (retValue == 0.0) {
            retValue = RANDOM.nextDouble();
        }
        return retValue;
    }

    @Override
    public Double getDoubleInRange(double minValue, double maxValue, AttributeMetadata attributeMetadata) {
        if (minValue == maxValue) {
            return minValue;
        }
        double retValue = minValue + Math.random() * (maxValue - minValue + 1.0);
        while (retValue < minValue || retValue > maxValue) {
            retValue = minValue + Math.random() * (maxValue - minValue + 1.0);
        }
        return retValue;
    }

    @Override
    public Float getFloat(AttributeMetadata attributeMetadata) {
        float retValue = RANDOM.nextFloat();
        while (retValue == 0.0f) {
            retValue = RANDOM.nextFloat();
        }
        return Float.valueOf(retValue);
    }

    @Override
    public Float getFloatInRange(float minValue, float maxValue, AttributeMetadata attributeMetadata) {
        if (minValue == maxValue) {
            return Float.valueOf(minValue);
        }
        float retValue = minValue + (float)(Math.random() * (double)(maxValue - minValue + 1.0f));
        while (retValue < minValue || retValue > maxValue) {
            retValue = minValue + (float)(Math.random() * (double)(maxValue - minValue + 1.0f));
        }
        return Float.valueOf(retValue);
    }

    @Override
    public Integer getInteger(AttributeMetadata attributeMetadata) {
        Integer retValue = RANDOM.nextInt();
        while (retValue == 0) {
            retValue = RANDOM.nextInt();
        }
        return retValue;
    }

    @Override
    public int getIntegerInRange(int minValue, int maxValue, AttributeMetadata attributeMetadata) {
        if (minValue == maxValue) {
            return minValue;
        }
        int retValue = minValue + (int)(Math.random() * (double)(maxValue - minValue + 1));
        while (retValue < minValue || retValue > maxValue) {
            retValue = minValue + (int)(Math.random() * (double)(maxValue - minValue + 1));
        }
        return retValue;
    }

    @Override
    public Long getLong(AttributeMetadata attributeMetadata) {
        return System.nanoTime();
    }

    @Override
    public Long getLongInRange(long minValue, long maxValue, AttributeMetadata attributeMetadata) {
        if (minValue == maxValue) {
            return minValue;
        }
        long retValue = minValue + (long)(Math.random() * (double)(maxValue - minValue + 1L));
        while (retValue < minValue || retValue > maxValue) {
            retValue = minValue + (long)(Math.random() * (double)(maxValue - minValue + 1L));
        }
        return retValue;
    }

    @Override
    public Short getShort(AttributeMetadata attributeMetadata) {
        short retValue = (short)RANDOM.nextInt(127);
        while (retValue == 0) {
            retValue = (short)RANDOM.nextInt(127);
        }
        return retValue;
    }

    @Override
    public Short getShortInRange(short minValue, short maxValue, AttributeMetadata attributeMetadata) {
        if (minValue == maxValue) {
            return minValue;
        }
        short retValue = (short)(minValue + (short)(Math.random() * (double)(maxValue - minValue + 1)));
        while (retValue < minValue || retValue > maxValue) {
            retValue = (short)(minValue + (short)(Math.random() * (double)(maxValue - minValue + 1)));
        }
        return retValue;
    }

    @Override
    public String getStringValue(AttributeMetadata attributeMetadata) {
        return this.getStringOfLength(10, attributeMetadata);
    }

    @Override
    public String getStringOfLength(int length, AttributeMetadata attributeMetadata) {
        StringBuilder buff = new StringBuilder("UTF-8");
        buff.setLength(0);
        while (buff.length() < length) {
            buff.append(this.getCharacter(attributeMetadata));
        }
        return buff.toString();
    }

    @Override
    public int getNumberOfCollectionElements(Class<?> type) {
        return this.nbrOfCollectionElements;
    }

    public void setNumberOfCollectionElements(int newNumberOfCollectionElements) {
        this.nbrOfCollectionElements = newNumberOfCollectionElements;
    }

    @Override
    public int getMaxDepth(Class<?> type) {
        return this.maxDepth;
    }

    public void setMaxDepth(int newMaxDepth) {
        this.maxDepth = newMaxDepth;
    }

    @Override
    public boolean isMemoizationEnabled() {
        return this.isMemoizationEnabled;
    }

    public void setMemoizationEnabled(boolean value) {
        this.isMemoizationEnabled = value;
    }

    @Override
    public void sort(Constructor<?>[] constructors) {
        Arrays.sort(constructors, CONSTRUCTOR_COMPARATOR);
    }

    @Override
    public void sort(Method[] methods) {
        Arrays.sort(methods, METHOD_COMPARATOR);
    }

    public <T> AbstractRandomDataProviderStrategy addSpecific(Class<T> abstractClass, Class<? extends T> specificClass) {
        this.specificTypes.put(abstractClass, specificClass);
        return this;
    }

    public <T> AbstractRandomDataProviderStrategy removeSpecific(Class<T> abstractClass) {
        this.specificTypes.remove(abstractClass);
        return this;
    }

    @Override
    public <T> Class<? extends T> getSpecificClass(Class<T> nonInstantiatableClass) {
        Class<Object> found = this.specificTypes.get(nonInstantiatableClass);
        if (found == null) {
            found = nonInstantiatableClass;
        }
        return found;
    }

    public AbstractRandomDataProviderStrategy addExcludedAnnotation(Class<? extends Annotation> annotation) {
        this.excludedAnnotations.add(annotation);
        return this;
    }

    public AbstractRandomDataProviderStrategy removeExcludedAnnotation(Class<? extends Annotation> annotation) {
        this.excludedAnnotations.remove(annotation);
        return this;
    }

    @Override
    public Set<Class<? extends Annotation>> getExcludedAnnotations() {
        return this.excludedAnnotations;
    }
}

